/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice;

import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.component.page.Viewport;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.theme.Theme;
import de.mahlsdorf.groupservice.service.cache.CacheConfiguration;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication(scanBasePackages={"de.mahlsdorf"})
@EnableCaching
@ComponentScan(basePackages={"de.mahlsdorf"})
@EnableScheduling
@Import(value={CacheConfiguration.class})
@PWA(name="lms-neo4j-vaadin", shortName="lms-neo4j-vaadin")
@Theme(value="demo")
@Viewport(value="width=device-width, minimum-scale=1.0, initial-scale=1.0, user-scalable=yes")
@Push
@CssImport(value="/styles/styles.css")
public class Neo4jWithUIApplication
implements AppShellConfigurator,
AsyncConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(Neo4jWithUIApplication.class);
    public static final String NEO_4_J_BOLT_URI = "NEO4J_BOLT_URI";
    public static final String NEO_4_J_HTTP_URI = "NEO4J_HTTP_URI";
    public static final String PLATFORM_BASE_URI = "PLATFORM_BASE_URI";
    public static final String VAADINEO_FILE_DIR = "VAADINEO_FILE_DIR";
    public static final String NEO_4_J_USER = "NEO4J_USER";
    public static final String NEO_4_J_PASSWORD = "NEO4J_PASSWORD";
    private static final List<String> ENV_NAMES = List.of("NEO4J_BOLT_URI", "NEO4J_HTTP_URI", "NEO4J_USER", "NEO4J_PASSWORD", "PLATFORM_BASE_URI", "VAADINEO_FILE_DIR");
    private static final List URL_ENVS = List.of("NEO4J_BOLT_URI", "NEO4J_HTTP_URI", "PLATFORM_BASE_URI");

    public static void main(String[] args) {
        Neo4jWithUIApplication.checkEnvironmentVars();
        SpringApplication.run(Neo4jWithUIApplication.class, (String[])args);
    }

    private static void checkEnvironmentVars() {
        boolean hasError = false;
        for (String env : ENV_NAMES) {
            logger.trace("check sytem environment variable {}", (Object)env);
            String value = System.getenv(env);
            if (StringUtils.isEmpty((CharSequence)value)) {
                logger.error("SystemEnvironment {} has no value ", (Object)env);
                hasError = true;
            } else if ("PLATFORM_BASE_URI".equals(env)) {
                if (!value.endsWith("/")) {
                    logger.error("System Environment variable {} value '{}' must have a trailing /", (Object)"PLATFORM_BASE_URI", (Object)value);
                    hasError = true;
                }
            } else if (URL_ENVS.contains(env) && !Pattern.compile("(bolt:|http:|https:)\\/\\/?[\\d\\w\\-\\.]{1,}(\\:[\\d]{2,5}|){0,1}(\\/\\S*){0,1}").matcher(value).matches()) {
                logger.error("SystemEnvironment Variable {} value '{}' is not a valid URL", (Object)env, (Object)value);
                hasError = true;
            }
            if (!"VAADINEO_FILE_DIR".equals(env)) continue;
            value = System.getenv(env);
            File fileDir = new File(value);
            if (!fileDir.isDirectory()) {
                logger.error("directory '{}' is not a directory or does not exist", (Object)value);
                hasError = true;
                if (!fileDir.mkdirs()) {
                    logger.error("cant create directory '{}' ", (Object)value);
                    hasError = true;
                }
            }
            if (fileDir.canWrite()) continue;
            logger.error("directory '{}' is not writable ", (Object)value);
            hasError = true;
        }
        if (hasError) {
            logger.error("please check the system environment variables {}", (Object)ENV_NAMES);
            logger.error("Env Vars {} have to be valid URLS  ", (Object)URL_ENVS);
            System.exit(1);
        }
    }

    @Bean
    public TaskScheduler taskScheduler() {
        return new ConcurrentTaskScheduler();
    }

    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(5);
        executor.setMaxPoolSize(20);
        executor.setQueueCapacity(10);
        executor.setThreadNamePrefix("AsyncExecutor-");
        executor.initialize();
        return executor;
    }
}

