/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.controller;

import de.mahlsdorf.groupservice.service.lti13.LaunchDeepLinkService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/platformapi/v1/lti13/"})
public class DeeplinkController {
    private static final Logger logger = LoggerFactory.getLogger(DeeplinkController.class);
    private LaunchDeepLinkService launchDeepLinkService;

    @GetMapping(value={"deepLinkingStart/"})
    public String startDeeplink(@RequestParam String teacherId, @RequestParam String courseId, @RequestParam String localeTag, @RequestParam(required=false) String toolId, HttpServletRequest request, HttpServletResponse response) {
        logger.info("starting DeepLinkingStart Controller ");
        Locale locale = Locale.forLanguageTag(localeTag);
        return this.launchDeepLinkService.launchDeeplinking(toolId, teacherId, courseId, request, response, locale, true);
    }

    @PostMapping(value={"deepLinkingResponse/{toolId}/{courseId}/"})
    public String insertDeeplinkResponse(@RequestBody MultiValueMap<String, String> formData, @PathVariable String toolId, @PathVariable String courseId, HttpServletRequest request, HttpServletResponse response) {
        logger.info("starting return Deeplink Controller toolId {} courseId {}", (Object)toolId, (Object)courseId);
        return this.launchDeepLinkService.insertDeepLinkingResponse(formData, toolId, courseId);
    }

    @Autowired
    public void setLaunchDeepLinkService(LaunchDeepLinkService launchDeepLinkService) {
        this.launchDeepLinkService = launchDeepLinkService;
    }
}

