/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.controller;

import de.mahlsdorf.groupservice.service.groupservice.DirectGraphControllerService;
import de.mahlsdorf.lti13.exception.exception.VaadineoNeo4jException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DirectGraphController {
    private DirectGraphControllerService directGraphContollerService;

    public DirectGraphController(DirectGraphControllerService directGraphContollerService) {
        this.directGraphContollerService = directGraphContollerService;
    }

    @PostMapping(value={"platformapi/v1/graph/lg"})
    public ResponseEntity<String> getGraphFromNeo4J(@RequestBody String teacherIdJson) throws VaadineoNeo4jException {
        String cypherStatementBase = " optional MATCH (n:School)-[et:TeacherIn]-(t:Teacher)-[eh:TeacherHasGroup]-(l:LearningGroup)-[es:StudentInGroup]-(s:Student) %s    RETURN n,et,t,eh,l,es,s.firstname,s.lastname  ";
        return this.directGraphContollerService.createCypherAndSendToDB(teacherIdJson, cypherStatementBase);
    }

    @PostMapping(value={"platformapi/v1/graph/course"})
    public ResponseEntity<String> getGraphFromNeo4JForCourse(@RequestBody String teacherIdJson) throws VaadineoNeo4jException {
        String cypherStatementBase = " optional MATCH (n:School)-[et:TeacherIn]-(t:Teacher)-[eh:TeacherHasGroup]-(l:LearningGroup)-[es:LearngroupToCourse]-(c:Course) %s   RETURN *";
        return this.directGraphContollerService.createCypherAndSendToDB(teacherIdJson, cypherStatementBase);
    }
}

