/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.controller;

import de.mahlsdorf.groupservice.service.groupservice.GraphViewTemplateService;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class GraphTaskController {
    private GraphViewTemplateService graphViewTemplateService;

    public GraphTaskController(@Autowired GraphViewTemplateService graphViewTemplateService) {
        this.graphViewTemplateService = graphViewTemplateService;
    }

    @GetMapping(value={"/platformapi/v1/template/task"})
    public String getTemplateForTask(@RequestParam String schoolId, @RequestParam String loggedInUserId, @RequestParam String localeString) {
        Locale locale = LocaleUtils.toLocale((String)localeString);
        return this.graphViewTemplateService.getTaskViewTemplate(schoolId, loggedInUserId, locale);
    }

    @GetMapping(value={"/platformapi/v1/template/learningGroup"})
    public String getTemplateForLearningGroup(@RequestParam String schoolId, @RequestParam String loggedInUserId, @RequestParam String localeString) {
        Locale locale = LocaleUtils.toLocale((String)localeString);
        return this.graphViewTemplateService.getGroupViewTemplate(schoolId, loggedInUserId, locale);
    }
}

