/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.converter;

import de.mahlsdorf.groupservice.model.node.Course;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.NullValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CourseConverter
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(CourseConverter.class);

    public List<Course> convertToCourse(List<Record> statementResult, String resultName) {
        if (statementResult == null) {
            logger.info("nothing found for course search()");
            return new ArrayList<Course>();
        }
        ArrayList<Course> result = new ArrayList<Course>();
        for (Record record : statementResult) {
            Value value = record.get(resultName);
            if (value instanceof NullValue) continue;
            Course course = new Course();
            course.setCourseId(value.get("courseId").asString());
            course.setName(value.get("name").asString());
            course.setSubject(value.get("subject", ""));
            course.setSubjectId(value.get("subjectId", ""));
            course.setStartsAt(Long.valueOf(value.get("startedAt").asLong()));
            course.setEndsAt(Long.valueOf(value.get("endsAt").asLong()));
            course.setComment(value.get("comment").asString());
            result.add(course);
        }
        return result;
    }
}

