/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.converter;

import de.mahlsdorf.groupservice.model.node.DbMigrationVersionNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DbMigrationVersionNodeConverter
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DbMigrationVersionNodeConverter.class);

    public List<DbMigrationVersionNode> convertToDbMigrationNode(List<Record> statementResult, String resultName) {
        ArrayList<DbMigrationVersionNode> result = new ArrayList<DbMigrationVersionNode>();
        for (Record myRecord : statementResult) {
            DbMigrationVersionNode node = new DbMigrationVersionNode();
            Value value = myRecord.get(resultName);
            if (!value.get("dbMigrationVersions").isNull()) {
                node.setVersionSetAsString(value.get("dbMigrationVersions").asString());
            } else {
                node.setVersionSetAsString("[]");
            }
            result.add(node);
            logger.debug(" add tool {}", (Object)node);
        }
        return result;
    }
}

