/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.converter;

import de.mahlsdorf.groupservice.model.node.LearningGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LearnGroupConverter
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(LearnGroupConverter.class);

    public List<LearningGroup> convertToLearningGroup(List<Record> statementResult, String resultName) {
        ArrayList<LearningGroup> result = new ArrayList<LearningGroup>();
        for (Record record : statementResult) {
            try {
                LearningGroup learnGroup = new LearningGroup();
                Value value = record.get(resultName);
                if (value.isNull()) continue;
                learnGroup.setLearnGroupname(value.get("learngroupName", ""));
                learnGroup.setGroupId(value.get("groupId", ""));
                result.add(learnGroup);
            }
            catch (Exception e) {
                logger.warn("Exception during convert of learning Group {} ", (Object)e.getMessage(), (Object)e);
            }
        }
        return result;
    }
}

