/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.converter;

import de.mahlsdorf.groupservice.model.node.School;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.springframework.stereotype.Component;

@Component
public class SchoolConverter
implements Serializable {
    public List<School> convertToSchool(List<Record> statementResult, String resultName) {
        ArrayList<School> result = new ArrayList<School>();
        for (Record myRecord : statementResult) {
            School school = new School();
            Value value = myRecord.get(resultName);
            school.setName(value.get("name", ""));
            school.setZip(value.get("zip", ""));
            school.setLocation(value.get("location", ""));
            school.setStreet(value.get("street", ""));
            school.setStreetNumber(value.get("streetNumber", ""));
            school.setCountry(value.get("country", ""));
            school.setSchoolId(value.get("schoolId").asString());
            school.setBackgroundImage(value.get("backgroundImage", ""));
            school.setCreatedAt(value.get("createdAt", 0L));
            school.setModifiedAt(value.get("modifiedAt", 0L));
            result.add(school);
        }
        return result;
    }
}

