/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.converter;

import de.mahlsdorf.groupservice.model.node.Student;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StudentConverter
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(StudentConverter.class);

    public List<Student> convertToStudent(List<Record> statementResult, String resultName) {
        ArrayList<Student> result = new ArrayList<Student>();
        if (statementResult == null) {
            logger.error("statement Result is null returning empty list ");
            return result;
        }
        for (Record record : statementResult) {
            Student student = new Student();
            Value value = record.get(resultName);
            if (!value.get("firstname").isNull()) {
                student.setFirstName(value.get("firstname").asString());
            }
            if (!value.get("lastname").isNull()) {
                student.setLastName(value.get("lastname").asString());
            }
            if (!value.get("email").isNull()) {
                student.setEmail(value.get("email").asString());
            }
            if (!value.get("studentId").isNull()) {
                student.setStudentId(value.get("studentId").asString());
            }
            if (!value.get("comment1").isNull()) {
                student.setComment1(value.get("comment1").asString());
            }
            if (!value.get("comment2").isNull()) {
                student.setComment2(value.get("comment2").asString());
            }
            if (!value.get("comment3").isNull()) {
                student.setComment3(value.get("comment3").asString());
            }
            if (!value.get("loginName").isNull()) {
                student.setLoginName(value.get("loginName").asString());
            }
            if (!value.get("password").isNull()) {
                student.setPassword(value.get("password").asString());
            }
            result.add(student);
        }
        return result;
    }
}

