/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.converter;

import de.mahlsdorf.groupservice.model.node.Subject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.NullValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SubjectConverter
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(SubjectConverter.class);

    public List<Subject> convertToSubject(List<Record> statementResult, String resultName) {
        ArrayList<Subject> result = new ArrayList<Subject>();
        for (Record record : statementResult) {
            Value value = record.get(resultName);
            if (value instanceof NullValue) continue;
            Subject subject = new Subject();
            subject.setSubjectId(value.get("subjectId").asString());
            subject.setSubjectName(value.get("subjectName", ""));
            subject.setDescription(value.get("description", ""));
            result.add(subject);
        }
        return result;
    }
}

