/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.converter;

import de.mahlsdorf.groupservice.model.node.Task;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.NullValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskConverter
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(TaskConverter.class);

    public List<Task> convertToTask(List<Record> statementResult, String resultName) {
        ArrayList<Task> result = new ArrayList<Task>();
        for (Record record : statementResult) {
            Value value = record.get(resultName);
            if (value instanceof NullValue) continue;
            Task task = new Task();
            task.setTaskId(value.get("taskId").asString());
            task.setName(value.get("name").asString());
            task.setDescription(value.get("description").asString());
            if (!value.get("ltiLiLineItemMaxPoints").isNull()) {
                task.setLtiLineItemMaxPoints(Double.valueOf(value.get("ltiLiLineItemMaxPoints") == null ? 0.0 : value.get("ltiLiLineItemMaxPoints").asDouble()));
            }
            if (!value.get("ltiLiLineItemTag").isNull()) {
                task.setLtiLiLineItemTag(value.get("ltiLiLineItemTag") == null ? "" : value.get("ltiLiLineItemTag").asString());
            }
            if (!value.get("ltiLiResourceId").isNull()) {
                task.setLtiLiResourceId(value.get("ltiLiResourceId") == null ? "" : value.get("ltiLiResourceId").asString());
            }
            if (!value.get("ltiResourceLinkId").isNull()) {
                task.setLtiResourceLinkId(value.get("ltiResourceLinkId") == null ? "" : value.get("ltiResourceLinkId").asString());
            }
            if (!value.get("ltiLtiLinkId").isNull()) {
                task.setLtiLtiLinkId(value.get("ltiLtiLinkId") == null ? "" : value.get("ltiLtiLinkId").asString());
            }
            if (!value.get("ltiCustomParams").isNull()) {
                task.setLtiCustomParams(value.get("ltiCustomParams") == null ? "" : value.get("ltiCustomParams").asString());
            }
            if (!value.get("ltiThumbnailUrl").isNull()) {
                task.setLtiThumbnailUrl(value.get("ltiThumbnailUrl") == null ? "" : value.get("ltiThumbnailUrl").asString());
            }
            if (!value.get("ltiIconUrl").isNull()) {
                task.setLtiIconUrl(value.get("ltiIconUrl") == null ? "" : value.get("ltiIconUrl").asString());
            }
            task.setType(value.get("type").asString());
            task.setUrl(value.get("url").asString());
            task.setStructure(value.get("structure").asString());
            task.setToolId(value.get("toolId").asString());
            result.add(task);
        }
        return result;
    }
}

