/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.converter;

import de.mahlsdorf.groupservice.model.node.TaskResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskResultConverter
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(TaskResultConverter.class);

    public List<TaskResult> convertToTaskResult(List<Record> statementResult, String resultName) {
        ArrayList<TaskResult> result = new ArrayList<TaskResult>();
        for (Record record : statementResult) {
            TaskResult taskResult = new TaskResult();
            Value value = record.get(resultName);
            taskResult.setScoreGiven(Double.valueOf(value.get("scoreGiven").asDouble()));
            taskResult.setComment(value.get("comment").asString());
            taskResult.setCreated(value.get("created").asString());
            taskResult.setUserId(value.get("studentNumber").asString());
            taskResult.setTaskId(value.get("taskId").asString());
            taskResult.setType(value.get("type").asString("-"));
            taskResult.setMaxScore(Float.valueOf(value.get("maxScore").asFloat(0.0f)));
            if (!value.get("modified").isNull()) {
                taskResult.setModified(Long.valueOf(value.get("modified").asLong()));
            } else {
                taskResult.setModified(Long.valueOf(0L));
            }
            result.add(taskResult);
        }
        return result;
    }
}

