/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.converter;

import de.mahlsdorf.groupservice.model.node.Teacher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TeacherConverter
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(TeacherConverter.class);

    public List<Teacher> convertToTeacher(List<Record> statementResult, String resultName) {
        ArrayList<Teacher> result = new ArrayList<Teacher>();
        for (Record record : statementResult) {
            Teacher teacher = new Teacher();
            Value value = record.get(resultName);
            teacher.setFirstName(value.get("firstname").asString());
            teacher.setLastName(value.get("lastname").asString());
            teacher.setTeacherId(value.get("teacherId").asString());
            if (!value.get("isAdmin").isNull()) {
                teacher.setAdmin(Boolean.valueOf(value.get("isAdmin").asBoolean()));
            }
            if (!value.get("loginName").isNull()) {
                teacher.setLoginName(value.get("loginName").asString());
            }
            if (!value.get("password").isNull()) {
                teacher.setPassword(value.get("password").asString());
            }
            result.add(teacher);
        }
        return result;
    }
}

