/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.converter;

import de.mahlsdorf.groupservice.model.node.Tool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ToolConverter
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ToolConverter.class);

    public List<Tool> convertToTool(List<Record> statementResult, String resultName) {
        ArrayList<Tool> result = new ArrayList<Tool>();
        for (Record record : statementResult) {
            Tool tool = new Tool();
            Value value = record.get(resultName);
            tool.setToolId(value.get("toolId", ""));
            tool.setToolName(value.get("toolName", ""));
            tool.setClientId(value.get("clientId", ""));
            tool.setToolDescription(value.get("toolDescription", ""));
            tool.setDeeplinkUrl(value.get("deeplinkUrl", ""));
            tool.setDeeplinkUrl(value.get("deeplinkUrl", ""));
            tool.setLoginInitUrl(value.get("loginInitUrl", ""));
            tool.setRedirectUrls(value.get("redirectUrls", ""));
            tool.setDeploymentId(value.get("deploymentId", ""));
            tool.setKeyId(value.get("keyId", ""));
            tool.setPrivateKeyAsPem(value.get("privateKeyPem", ""));
            tool.setPublicKeyAsPem(value.get("publicKeyPem", ""));
            tool.setToolJwksUrl(value.get("toolJwksUrl", ""));
            tool.setUseAgs(Boolean.valueOf(value.get("useAgs", true)));
            tool.setUseNamesAndRoles(Boolean.valueOf(value.get("useNamesAndRoles", true)));
            tool.setToolUrl(value.get("toolUrl", ""));
            result.add(tool);
            logger.debug(" add tool {}", (Object)tool);
        }
        return result;
    }
}

