/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.model.lti13.dynreg;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.mahlsdorf.groupservice.model.lti13.dynreg.DynRegLtiStrings;
import de.mahlsdorf.groupservice.model.lti13.dynreg.DynRegMessagesSupportedDTO;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynRegMessagesSupportedDeserializer
extends StdDeserializer<DynRegMessagesSupportedDTO> {
    private static final Logger log = LoggerFactory.getLogger(DynRegMessagesSupportedDeserializer.class);

    public DynRegMessagesSupportedDeserializer() {
        this(null);
    }

    protected DynRegMessagesSupportedDeserializer(Class<?> vc) {
        super(vc);
    }

    public DynRegMessagesSupportedDTO deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        DynRegMessagesSupportedDTO messagesSupported = new DynRegMessagesSupportedDTO();
        if (node.get("type") != null) {
            messagesSupported.setType(node.get("type").asText());
            if (node.get("placements") != null) {
                ArrayList<String> placements = new ArrayList<String>();
                for (JsonNode jsonNode : node.get("placements")) {
                    placements.add(jsonNode.asText());
                }
                messagesSupported.setPlacements(placements);
            }
        } else if (DynRegLtiStrings.MESSAGES_SUPPORTED_TYPES.contains(node.asText())) {
            messagesSupported.setType(node.asText());
        }
        log.debug("Deserialized Message Type:");
        log.debug(messagesSupported.getType());
        log.debug(messagesSupported.getPlacements() != null ? messagesSupported.getPlacements().toString() : null);
        return messagesSupported;
    }
}

