/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.model.node;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Course
implements Serializable {
    Logger LOG = LoggerFactory.getLogger(Course.class);
    public static final String COL_ID = "courseId";
    public static final String COL_NAME = "name";
    public static final String COL_SUBJECT = "subject";
    public static final String COL_SUBJECT_ID = "subjectId";
    public static final String COL_STARTED_AT = "startedAt";
    public static final String COL_ENDS_AT = "endsAt";
    public static final String COL_COMMENT = "comment";
    private LocalDate startsAtLocalTime;
    private LocalDate endsAtLocalTime;
    private String courseId;
    private String name = "";
    private String subject;
    private String subjectId;
    private long startsAt;
    private Long endsAt;
    private String comment = "";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Long getStartsAt() {
        return this.startsAt;
    }

    public void setStartsAt(Long startsAt) {
        Instant instant = Instant.ofEpochMilli(startsAt);
        this.startsAtLocalTime = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.startsAt = startsAt;
    }

    public Long getEndsAt() {
        return this.endsAt;
    }

    public void setEndsAt(Long endsAt) {
        Instant instant = Instant.ofEpochMilli(endsAt);
        this.endsAtLocalTime = instant.atZone(ZoneId.systemDefault()).toLocalDate();
        this.endsAt = endsAt;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCourseId() {
        return this.courseId;
    }

    public void setCourseId(String courseId) {
        this.courseId = courseId;
    }

    public String toString() {
        return this.name + " (" + this.courseId + ")";
    }

    public LocalDate getStartsAtLocalTime() {
        return this.startsAtLocalTime;
    }

    public LocalDate getEndsAtLocalTime() {
        return this.endsAtLocalTime;
    }

    public void setStartsAtLocalTime(LocalDate startsAtLocalTime) {
        this.startsAtLocalTime = startsAtLocalTime;
        this.startsAt = this.convertToEpoch(startsAtLocalTime);
    }

    public void setEndsAtLocalTime(LocalDate endsAtLocalTime) {
        this.endsAtLocalTime = endsAtLocalTime;
        this.endsAt = this.convertToEpoch(this.endsAtLocalTime);
    }

    private long convertToEpoch(LocalDate date) {
        ZoneId zoneId = ZoneId.systemDefault();
        this.LOG.info("ZoneId is " + zoneId);
        return date.atStartOfDay(zoneId).toInstant().toEpochMilli();
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Course course = (Course)o;
        return Objects.equals(this.courseId, course.courseId);
    }

    public int hashCode() {
        return Objects.hash(this.courseId);
    }
}

