/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.model.node;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.mahlsdorf.groupservice.converter.CourseConverter;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbMigrationVersionNode {
    public static final String COL_DB_MIGRATION_VERSIONS = "dbMigrationVersions";
    public static final String COL_ID = "pkey";
    private static final Logger logger = LoggerFactory.getLogger(CourseConverter.class);
    private final String id = "1";
    ObjectMapper objectMapper = new ObjectMapper();
    private final Set<String> versionSet = new TreeSet();
    private String versionJson = "[]";

    public String getId() {
        return "1";
    }

    public String getVersionJson() {
        return this.versionJson;
    }

    public void addVersion(String version) {
        this.versionSet.add(version);
        try {
            this.versionJson = this.objectMapper.writeValueAsString((Object)this.versionSet);
        }
        catch (Exception e) {
            logger.error("cant set version set as json ", (Throwable)e);
        }
    }

    public void setVersionSetAsString(String versionJson) {
        this.versionJson = versionJson;
    }

    public TreeSet<String> getSortedVersionSet() {
        Set myVersionSet = new HashSet();
        try {
            myVersionSet = (Set)this.objectMapper.readValue(this.versionJson.getBytes(), Set.class);
        }
        catch (Exception e) {
            logger.error("DBMigration cant get Versions ", (Throwable)e);
        }
        return new TreeSet<String>(myVersionSet);
    }
}

