/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.neodb;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DriverManager
implements AutoCloseable,
Serializable,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(DriverManager.class);
    private Driver driver = null;
    private String neo4JUri;
    private String neo4UserName;
    private String neo4Password;

    public Driver getDriver() {
        if (this.driver == null) {
            try {
                this.afterPropertiesSet();
            }
            catch (Exception e) {
                logger.error("Exception while creating driver {} ", (Object)e.getMessage(), (Object)e);
            }
        }
        return this.driver;
    }

    @Override
    public void close() {
        this.driver.close();
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    @Value(value="${spring.neo4j.uri}")
    public void setNeo4JUri(String neo4JUri) {
        this.neo4JUri = neo4JUri;
    }

    @Value(value="${spring.neo4j.authentication.username}")
    public void setNeo4UserName(String neo4UserName) {
        this.neo4UserName = neo4UserName;
    }

    @Value(value="${spring.neo4j.authentication.password}")
    public void setNeo4Password(String neo4Password) {
        this.neo4Password = neo4Password;
    }

    public void afterPropertiesSet() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("NEO4J Uri is {}", (Object)this.neo4JUri);
            logger.trace("NEO4J userName is {}", (Object)this.neo4UserName);
            logger.trace("NEO4J password is {}", (Object)this.neo4Password);
        }
        this.driver = GraphDatabase.driver((String)this.neo4JUri, (AuthToken)AuthTokens.basic((String)this.neo4UserName, (String)this.neo4Password), (Config)Config.builder().withMaxConnectionLifetime(2L, TimeUnit.MINUTES).withMaxConnectionPoolSize(50).withConnectionAcquisitionTimeout(20L, TimeUnit.SECONDS).build());
    }
}

