/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.neodb;

import de.mahlsdorf.groupservice.converter.CourseConverter;
import de.mahlsdorf.groupservice.converter.DbMigrationVersionNodeConverter;
import de.mahlsdorf.groupservice.converter.LearnGroupConverter;
import de.mahlsdorf.groupservice.converter.SchoolConverter;
import de.mahlsdorf.groupservice.converter.StudentConverter;
import de.mahlsdorf.groupservice.converter.SubjectConverter;
import de.mahlsdorf.groupservice.converter.TaskConverter;
import de.mahlsdorf.groupservice.converter.TaskResultConverter;
import de.mahlsdorf.groupservice.converter.TeacherConverter;
import de.mahlsdorf.groupservice.converter.ToolConverter;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.DbMigrationVersionNode;
import de.mahlsdorf.groupservice.model.node.LearningGroup;
import de.mahlsdorf.groupservice.model.node.NodeIf;
import de.mahlsdorf.groupservice.model.node.PersonIF;
import de.mahlsdorf.groupservice.model.node.School;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.model.node.Subject;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.model.node.TaskResult;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.model.relation.RelationIF;
import de.mahlsdorf.groupservice.neodb.DriverManager;
import de.mahlsdorf.groupservice.neodb.MyTransActionWork;
import de.mahlsdorf.groupservice.neodb.StatementRunner;
import de.mahlsdorf.lti13.lti13models.model.lti.grades.Lti13Score;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.driver.Record;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class Neo4JBaseService
implements InitializingBean,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Neo4JBaseService.class);
    public static final String VAR_COURSE = "Course";
    public static final String TEACHER = "Teacher";
    public static final String LEARN_GROUP = "learnGroup";
    public static final String VAR_STUDENT = "student";
    public static final String VAR_SUBJECT = "subject";
    public static final String ORDER_CLAUSE_STUDENT = " order by student.lastname,student.firstname";
    public static final String VAR_TEACHER = "teacher";
    public static final String VAR_LG = "lg";
    public static final String ORDER_BY_TEACHER = " order by teacher.lastname,teacher.firstname";
    public static final String VAR_TOOL = "tool";
    public static final String VAR_SCHOOL = "school";
    public static final String VAR_TASK = "task";
    private boolean removeBeckerAlexanderFromToolList = false;
    public static final String PROPERTIES_TOOL = "SET a.toolId = $toolId SET a.toolName = $toolName SET a.clientId  = $clientId SET a.deploymentId  = $deploymentId SET a.toolDescription  = $description SET a.deeplinkUrl  = $deeplinkUrl SET a.loginInitUrl  = $loginInitUrl SET a.toolJwksUrl  = $toolJwksUrl SET a.redirectUrls  = $redirectUrls  SET a.keyId  = $keyId  SET a.privateKeyPem  = $privateKeyAsPem  SET a.publicKeyPem  = $publicKeyAsPem  SET a.useAgs  = $useAgs  SET a.useNamesAndRoles  = $useNamesAndRoles  SET a.toolUrl  = $toolUrl  ";
    public static final String BLANK = " ";
    public static final String PROPERTIES_TASK = "SET a.taskId = $taskId SET a.name = $name SET a.description  = $description SET a.ltiLiLineItemMaxPoints = $ltiLiLineItemMaxPoints SET a.type  = $type SET a.url  = $url SET a.toolId = $toolId SET a.structure  = $structure SET a.ltiLiLineItemTag = $ltiLiLineItemTag SET a.ltiLiResourceId = $ltiLiResourceId SET a.ltiResourceLinkId = $ltiResourceLinkId SET a.ltiLtiLinkId = $ltiLtiLinkId SET a.ltiCustomParams = $ltiCustomParams SET a.ltiThumbnailUrl = $ltiThumbnailUrl SET a.ltiIconUrl = $ltiIconUrl ";
    public static final String VAR_LEARNGROUP_NUMBER = "learngroupNumber";
    private DriverManager driverManager;
    private final CourseConverter courseConverter = new CourseConverter();
    private final TaskConverter taskConverter = new TaskConverter();
    private final StudentConverter studentConverter = new StudentConverter();
    private final LearnGroupConverter learnGroupConverter = new LearnGroupConverter();
    private final TeacherConverter teacherConverter = new TeacherConverter();
    private final SchoolConverter schoolConverter = new SchoolConverter();
    private final ToolConverter toolConverter = new ToolConverter();
    private final SubjectConverter subjectConverter = new SubjectConverter();
    private final TaskResultConverter taskResultConverter = new TaskResultConverter();
    private final DbMigrationVersionNodeConverter dbNodeConverter = new DbMigrationVersionNodeConverter();
    private StatementRunner statementRunner;
    private Long teacherNumber;
    private Long studentNumber;
    private Long learnGroupNumber;

    public Neo4JBaseService(@Autowired DriverManager driverManager) {
        this.driverManager = driverManager;
        this.statementRunner = new StatementRunner(this);
    }

    public void setDriverManager(DriverManager driverManager) {
        this.driverManager = driverManager;
    }

    public Session getSessionSave() {
        if (this.driverManager == null || this.driverManager.getDriver() == null) {
            logger.error("neo4J DriverManager / driver is null abort ");
            throw new IllegalStateException("neo4J Driver Manager is null");
        }
        return this.driverManager.getDriver().session();
    }

    private void logDebugCypher(String cypher, Map<String, Object> parameter) {
        if (logger.isDebugEnabled()) {
            logger.debug("Cypher {}  parameter {}", (Object)cypher, parameter);
        }
    }

    public Transaction getNewTransaction() {
        Transaction tx = this.getSessionSave().beginTransaction();
        return tx;
    }

    void deleteAllNodes(String nodeName) {
        String cypher = " Match  (n:" + nodeName + " ) detach delete n";
        List result = this.statementRunner.runCyperStatementPrepared(cypher, null);
        if (logger.isDebugEnabled()) {
            logger.debug("deleted {}", (Object)result);
        }
    }

    public DbMigrationVersionNode getDBMigrationVersionNode() {
        Session session = this.getSessionSave();
        return this.getDBMigrationVersionNode(session);
    }

    public DbMigrationVersionNode getDBMigrationVersionNode(Session session) {
        String cypher = " Match  (n:DbMigrationNode ) where n.pkey= \"1\" return n";
        List result = this.statementRunner.runCyperStatementPrepared(cypher, null);
        if (result == null) {
            logger.info("create a new DbMigration Node");
            this.createDbMigrationVersionNode(session, new DbMigrationVersionNode());
            result = this.statementRunner.runCyperStatementPrepared(cypher, null);
        }
        if (result.size() != 0) {
            return (DbMigrationVersionNode)this.dbNodeConverter.convertToDbMigrationNode(result, "n").get(0);
        }
        DbMigrationVersionNode dbMigrationVersionNode = new DbMigrationVersionNode();
        this.createDbMigrationVersionNode(session, dbMigrationVersionNode);
        if (logger.isDebugEnabled()) {
            logger.debug("Result {} ", (Object)result);
        }
        return new DbMigrationVersionNode();
    }

    public void createDbMigrationVersionNode(DbMigrationVersionNode node) {
        Session session = this.getSessionSave();
        this.createDbMigrationVersionNode(session, node);
    }

    private void createDbMigrationVersionNode(Session session, DbMigrationVersionNode node) {
        String stmt = "CREATE (a:DbMigrationNode) SET a.pkey = $id SET a.dbMigrationVersions  = $versions RETURN a.id + ', from node ' + id(a)";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("id", "1");
        parameter.put("versions", node.getVersionJson());
        MyTransActionWork myTransActionWork = new MyTransActionWork(stmt, parameter);
        session.writeTransaction((TransactionWork)myTransActionWork);
    }

    public void saveDBMigrationVersionNode(DbMigrationVersionNode node) {
        Session session = this.getSessionSave();
        this.saveDBMigrationVersionNode(session, node);
    }

    private void saveDBMigrationVersionNode(Session session, DbMigrationVersionNode node) {
        String stmt = "Match (a:DbMigrationNode { pkey : $id } ) SET a.pkey = $id SET a.dbMigrationVersions  = $versions RETURN a.id + ', from node ' + id(a)";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("id", "1");
        parameter.put("versions", node.getVersionJson());
        MyTransActionWork myTransActionWork = new MyTransActionWork(stmt, parameter);
        session.writeTransaction((TransactionWork)myTransActionWork);
    }

    private static Map<String, Object> getLearningGroupParameterMap(LearningGroup learnGroup) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("name", learnGroup.getLearnGroupname());
        parameter.put("groupId", learnGroup.getGroupId());
        return parameter;
    }

    public List<Course> getCoursesForLearnGroup(String learningGroupId) {
        String cypher = "Match (a:LearningGroup) - [LearngroupToCourse] - (Course:Course) where a.groupId=$learningGroupNumber RETURN Course";
        if (logger.isDebugEnabled()) {
            logger.debug("cypher is \"{} \"", (Object)cypher);
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("learningGroupNumber", learningGroupId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.courseConverter.convertToCourse(result, "Course");
    }

    public List<Course> getCourseByTask(String taskId) {
        String cypher = "Optional MATCH (a:Task)-[*1..2]-(b:Course) where a.taskId=$taskId  RETURN b ";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("taskId", taskId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.courseConverter.convertToCourse(result, "b");
    }

    public List<Course> getCoursesPerTeacher(String teacherId) {
        String cypher = "Optional MATCH (a:Teacher)-[*1..2]-(b:Course) where a.teacherId=$teacherId  RETURN b ";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("teacherId", teacherId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.courseConverter.convertToCourse(result, "b");
    }

    public List<Course> getCoursesPerStudent(String studentId) {
        String cypher = "Optional MATCH (a:Student)-[*1..2]-(b:Course) where a.studentId= $studentId  and b.startedAt < $now AND b.endsAt > $now WITH DISTINCT b RETURN b ";
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("studentId", studentId);
        parameter.put("now", System.currentTimeMillis());
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.courseConverter.convertToCourse(result, "b");
    }

    public Course findCourseById(String courseId) {
        String cypher = "Optional MATCH (Course:Course) where  Course.courseId=$courseId  RETURN  Course";
        if (logger.isDebugEnabled()) {
            logger.debug("cypher is \" {} \"", (Object)cypher);
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("courseId", courseId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        List resultList = this.courseConverter.convertToCourse(result, "Course");
        if (resultList != null && resultList.size() == 1) {
            return (Course)resultList.get(0);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("get Course by Id nit exact one result id {} result {} return null", (Object)courseId, (Object)resultList);
        }
        return null;
    }

    public List<Task> getTasksPerStudentAndCourse(String studentId, String courseId) {
        String cypher = "Optional MATCH (a:Student)-[StudentHasTask] - (task:Task) -[CourseHasTask ] -(b:Course) where a.studentId=$studentId  and b.courseId=$courseId   RETURN  task";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("studentId", studentId);
        parameter.put("courseId", courseId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.taskConverter.convertToTask(result, "task");
    }

    public List<Task> getHeadlinesByCourse(String courseId) {
        String cypher = "Optional MATCH  (task:Task) -[CourseHasTask ] -(b:Course) where b.courseId=$courseId and task.type=$colType   RETURN  task";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("colType", "headline");
        parameter.put("courseId", courseId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.taskConverter.convertToTask(result, "task");
    }

    public void createCourse(Course course, String learningGroupId) throws Exception {
        MyTransActionWork myTransActionWork;
        HashMap<String, String> parameter;
        String stmt;
        boolean hasError = false;
        try (Session session = this.getSessionSave();){
            if (StringUtils.isEmpty((CharSequence)course.getCourseId())) {
                course.setCourseId(UUID.randomUUID().toString());
            }
            if (course.getStartsAt() == null) {
                course.setStartsAt(Long.valueOf(System.currentTimeMillis()));
            }
            if (course.getEndsAt() == null) {
                long endTime = System.currentTimeMillis() + 31536000000L;
                course.setEndsAt(Long.valueOf(endTime));
            }
            stmt = "CREATE (a:Course) SET a.name = $name SET a.comment  = $comment SET a.subject  = $subject SET a.subjectId  = $subjectId SET a.courseId  = $courseId SET a.startedAt  = $startedAt SET a.endsAt  = $endsAt RETURN a.courseId + ', from node ' + id(a)";
            parameter = new HashMap<String, String>();
            this.fillParameterMapCourse(course, parameter);
            myTransActionWork = new MyTransActionWork(stmt, parameter);
            Object o = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result {}", o);
            }
        }
        session = this.getSessionSave();
        try {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("create relation LearningGroup {} Course {} CoursseName {}  ", new Object[]{learningGroupId, course.getCourseId(), course.getName()});
                }
                stmt = "Match (a:LearningGroup),(b:Course) WHERE a.groupId = $lgId AND b.courseId = $courseId  CREATE (a)-[r:LearngroupToCourse]->(b)  RETURN type(r)";
                parameter = new HashMap();
                parameter.put("lgId", learningGroupId);
                parameter.put("courseId", course.getCourseId());
                myTransActionWork = new MyTransActionWork(stmt, parameter);
                Object result = session.writeTransaction((TransactionWork)myTransActionWork);
                if (logger.isDebugEnabled()) {
                    logger.debug("Result {}", result);
                }
            }
            catch (Exception e) {
                logger.error("cant create Relation LearningGroup - Course - Exception  {}", (Object)e.getMessage(), (Object)e);
                hasError = false;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        if (hasError) {
            logger.error("DELETE Course with ID {} ", (Object)course.getCourseId());
            throw new Exception("cant create course ");
        }
    }

    private void fillParameterMapCourse(Course course, Map<String, Object> parameter) {
        parameter.put("name", course.getName());
        parameter.put("comment", course.getComment());
        parameter.put("subject", course.getSubject());
        parameter.put("courseId", course.getCourseId());
        parameter.put("startedAt", course.getStartsAt());
        parameter.put("endsAt", course.getEndsAt());
        parameter.put("subjectId", course.getSubjectId());
    }

    public void updateCourse(Course course) throws Exception {
        try (Session session = this.getSessionSave();){
            if (StringUtils.isEmpty((CharSequence)course.getCourseId())) {
                course.setCourseId(UUID.randomUUID().toString());
            }
            if (course.getStartsAt() == null) {
                course.setStartsAt(Long.valueOf(System.currentTimeMillis()));
            }
            if (course.getEndsAt() == null) {
                long endTime = System.currentTimeMillis() + 31536000000L;
                course.setEndsAt(Long.valueOf(endTime));
            }
            String stmt = "MATCH (a:Course { courseId : $courseIdWhere } ) SET a.name = $name SET a.comment  = $comment SET a.subject  = $subject SET a.courseId  = $courseId SET a.startedAt  = $startedAt SET a.endsAt  = $endsAt SET a.subjectId  = $subjectId RETURN a.number + ', from node ' + id(a)";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("courseIdWhere", course.getCourseId());
            this.fillParameterMapCourse(course, parameter);
            if (logger.isDebugEnabled()) {
                logger.debug("Cypher is {} parameter {}", (Object)stmt, parameter);
            }
            MyTransActionWork myTransActionWork = new MyTransActionWork(stmt, parameter);
            Object o = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result {}", o);
            }
        }
    }

    public void createSubject(Subject subject, String schoolId) throws Exception {
        MyTransActionWork myTransActionWork;
        HashMap<String, String> parameter;
        String stmt;
        boolean hasError = false;
        try (Session session = this.getSessionSave();){
            if (StringUtils.isEmpty((CharSequence)subject.getSubjectId())) {
                subject.setSubjectId(UUID.randomUUID().toString());
            }
            stmt = "CREATE (a:Subject) SET a.subjectId  = $subjectId SET a.subjectName = $name SET a.description  = $description RETURN a.subjectId + ', from node ' + id(a)";
            parameter = new HashMap<String, String>();
            this.fillParameterMapSubject(subject, parameter);
            myTransActionWork = new MyTransActionWork(stmt, parameter);
            Object o = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result {}", o);
            }
        }
        session = this.getSessionSave();
        try {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("create relation School {} Subject{} subjectName {}  ", new Object[]{schoolId, subject.getSubjectId(), subject.getSubjectName()});
                }
                stmt = "Match (a:School),(b:Subject) WHERE a.schoolId = $schoolId AND b.subjectId = $subjectId  CREATE (a)-[r:SchoolHasSubject]->(b)  RETURN type(r)";
                parameter = new HashMap();
                parameter.put("schoolId", schoolId);
                parameter.put("subjectId", subject.getSubjectId());
                myTransActionWork = new MyTransActionWork(stmt, parameter);
                Object result = session.writeTransaction((TransactionWork)myTransActionWork);
                if (logger.isDebugEnabled()) {
                    logger.debug("Result {}", result);
                }
            }
            catch (Exception e) {
                logger.error("cant create Relation School - Subject - Exception  {}", (Object)e.getMessage(), (Object)e);
                hasError = false;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        if (hasError) {
            logger.error("DELETE Course with ID {} ", (Object)subject.getSubjectId(), (Object)subject.getSubjectName());
            throw new Exception("cant create course ");
        }
    }

    private void fillParameterMapSubject(Subject subject, Map<String, Object> parameter) {
        parameter.put("name", subject.getSubjectName());
        parameter.put("description", subject.getDescription());
        parameter.put("subjectId", subject.getSubjectId());
    }

    public void updateSubject(Subject subject) throws Exception {
        try (Session session = this.getSessionSave();){
            if (StringUtils.isEmpty((CharSequence)subject.getSubjectId())) {
                subject.setSubjectId(UUID.randomUUID().toString());
            }
            String stmt = "MATCH (a:Subject { subjectId : $subjectIdWhere } ) SET a.subjectName = $name SET a.description  = $description SET a.subjectId  = $subjectId RETURN a.number + ', from node ' + id(a)";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("subjectIdWhere", subject.getSubjectId());
            this.fillParameterMapSubject(subject, parameter);
            if (logger.isDebugEnabled()) {
                logger.debug("Cypher is {} parameter {}", (Object)stmt, parameter);
            }
            MyTransActionWork myTransActionWork = new MyTransActionWork(stmt, parameter);
            Object o = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result {}", o);
            }
        }
    }

    @Nullable
    public Subject getSubjectById(String subjectId) {
        logger.debug("search for subjectWithId  {} ", (Object)subjectId);
        String cypher = " MATCH (subject:Subject { subjectId:$subjectId } ) return subject";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("subjectId", subjectId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        List resultList = this.subjectConverter.convertToSubject(result, "subject");
        if (resultList.isEmpty()) {
            return null;
        }
        return (Subject)resultList.get(0);
    }

    public void deleteSubjectById(String subjectId) throws IllegalAccessException {
        String cypherCount = " MATCH (Course:Course { subjectId:$subjectId } ) return Course ";
        HashMap<String, String> parameterCount = new HashMap<String, String>();
        parameterCount.put("subjectId", subjectId);
        List resultCount = this.statementRunner.runCyperStatementPrepared(cypherCount, parameterCount);
        List existingCourses = new CourseConverter().convertToCourse(resultCount, "Course");
        if (existingCourses.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Course course : existingCourses) {
                sb.append("Course:").append(course.getName()).append("  Id:").append(course.getCourseId()).append("\n");
            }
            String msg = "still existing Courses, cant delete subject \n".concat(sb.toString());
            logger.warn(msg);
            throw new IllegalAccessException(msg);
        }
        String cypher = " MATCH (subject:Subject { subjectId:$subjectId } ) detach delete subject";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("subjectId", subjectId);
        this.logDebugCypher(cypher, parameter);
        Transaction tx = this.driverManager.getDriver().session().beginTransaction();
        try {
            List result = this.statementRunner.runCyperStatementPreparedWithTx(cypher, parameter, tx);
            tx.commit();
        }
        catch (Exception e) {
            logger.error("Exception while deleting Subject {} Exception {} ", new Object[]{subjectId, e.getMessage(), e});
            tx.rollback();
        }
    }

    public List<Subject> findSubjectsBySchoolId(String schoolId) {
        String cypher = "Match (a:School),(b:Subject) WHERE a.schoolId = $schoolId RETURN b";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("schoolId", schoolId);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.subjectConverter.convertToSubject(result, "b");
    }

    public List<Task> getTaskByToolId(String $toolId) {
        String cypher = "Match (task:Task) where task.toolId=$toolId RETURN task";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("toolId", $toolId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        List resultList = this.taskConverter.convertToTask(result, "task");
        return resultList;
    }

    public List<Task> getTasksForCourse(String courseId) {
        String cypher = "Match (a:Course) - [CourseHasTask] -> (task:Task) where a.courseId=$courseId   RETURN task order by task.structure";
        if (logger.isDebugEnabled()) {
            logger.debug("cypher is \"{} \"", (Object)cypher);
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("courseId", courseId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.taskConverter.convertToTask(result, "task");
    }

    public Task getTaskById(String taskId) {
        String cypher = "Match (task:Task { taskId: $taskId } ) RETURN task";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("taskId", taskId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        List resultList = this.taskConverter.convertToTask(result, "task");
        if (resultList != null && resultList.size() == 1) {
            return (Task)resultList.get(0);
        }
        logger.warn("no exaxt one Task found for Id '{}' result {} ", (Object)taskId, (Object)resultList);
        return null;
    }

    public List<Teacher> getTeacherForLearningGroup(String lgId) {
        String cypher = "Match ( a:LearningGroup) - [TeacherHasGroup] - (Teacher:Teacher) where a.groupId=$lgId  RETURN Teacher";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("lgId", lgId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.teacherConverter.convertToTeacher(result, "Teacher");
    }

    public List<Student> getStudentForCourseViaLearningGroup(String courseId) {
        String cypher = "Match (a:Course) - [LearngroupToCourse] - (learnGroup:LearningGroup) - [StudentInGroup] - (student:Student)  where a.courseId=$courseId  RETURN student";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("courseId", courseId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        if (logger.isDebugEnabled()) {
            logger.debug("found {} Students in course with id {} ", (Object)result.size(), (Object)courseId);
        }
        return this.studentConverter.convertToStudent(result, "student");
    }

    public List<TaskResult> getTaskResultsForTask(String taskId) {
        String cypher = "MATCH (t:Task {taskId: $taskId  }) -[r:StudentHasTask] -(s:Student)\n   return t,r,s";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("taskId", taskId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        if (logger.isDebugEnabled()) {
            logger.debug("found {} Students  with id TaskId{} ", (Object)result.size(), (Object)taskId);
        }
        return this.mergeTaskResults(result, "r", "s", "t");
    }

    public List<TaskResult> getTaskResultsForCourseForAllStudents(String courseId) {
        String cypher = "MATCH (n:Course {courseId: $courseId  }) -[rc:CourseHasTask] - (t:Task) -[r: StudentHasTask] -(s:Student)\n   return r,t,s";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("courseId", courseId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        if (logger.isDebugEnabled()) {
            logger.debug("found {} Students Results  with id CourseId {} ", (Object)result.size(), (Object)courseId);
        }
        return this.mergeTaskResults(result, "r", "s", "t");
    }

    public List<TaskResult> getTaskResultsForTaskInCourseForAllStudents(String courseId, String taskId) {
        String cypher = "MATCH (n:Course {courseId: $courseId }) -[rc:CourseHasTask] - (t:Task{taskId:$taskId  }) -[r: StudentHasTask] -(s:Student)\n   return r,t,s";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("courseId", courseId);
        parameter.put("taskId", taskId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        if (logger.isDebugEnabled()) {
            logger.debug("found {} Students Results  with id CourseId {} and TaskId {} ", new Object[]{result.size(), courseId, taskId});
        }
        return this.mergeTaskResults(result, "r", "s", "t");
    }

    public List<TaskResult> getAllTaskResultsForTask(String taskId) {
        String cypher = "MATCH  (t:Task{taskId:$taskId  }) -[r: StudentHasTask] -(s:Student)\n   return r,t,s";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("taskId", taskId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        if (logger.isDebugEnabled()) {
            logger.debug("found {} Students Results  with id CourseId {} and TaskId {} ", (Object)result.size(), (Object)taskId);
        }
        return this.mergeTaskResults(result, "r", "s", "t");
    }

    public void createTaskResult(Task task, String studentId, Lti13Score ltiScore) {
        try (Session session = this.getSessionSave();){
            String stmt = "MATCH (n:Task {taskId: $taskId }) -[r:StudentHasTask] -(s:Student   {studentId:$studentId})\n    set r.scoreGiven = $scoreGiven    set r.comment= $comment    set r.modified= $modified    set r.type= $type    return r";
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("taskId", task.getTaskId());
            parameter.put("type", task.getType());
            parameter.put("studentId", studentId);
            parameter.put("scoreGiven", ltiScore.getScoreGiven());
            parameter.put("comment", ltiScore.getComment());
            parameter.put("modified", System.currentTimeMillis());
            MyTransActionWork myTransActionWork = new MyTransActionWork(stmt, parameter);
            Object result = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result {} ", result);
            }
        }
        catch (Exception e) {
            logger.error("Exception creating taskResult   ", (Throwable)e);
            throw e;
        }
    }

    public List<TaskResult> getTaskResultsForCourseForOneStudent(String courseId, String userId) {
        String cypher = "MATCH (n:Course {courseId: $courseId }) -[rc:CourseHasTask] - (t:Task) -[r: StudentHasTask] -(s:Student {studentId: $userId })\n return r,t,s Order by t.structure asc ";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("courseId", courseId);
        parameter.put("userId", userId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        if (logger.isDebugEnabled()) {
            logger.debug("found {} Students Results  with id CourseId {} ", (Object)result.size(), (Object)courseId);
        }
        return this.mergeTaskResults(result, "r", "s", "t");
    }

    private List<TaskResult> mergeTaskResults(List<Record> result, String varTaskResult, String varStudent, String varTask) {
        List taskResultsList = this.taskResultConverter.convertToTaskResult(result, varTaskResult);
        List studentList = this.studentConverter.convertToStudent(result, varStudent);
        List taskList = new TaskConverter().convertToTask(result, varTask);
        TreeMap<String, Student> studentMap = new TreeMap<String, Student>();
        TreeMap<String, Task> taskMap = new TreeMap<String, Task>();
        for (Student student : studentList) {
            studentMap.put(student.getStudentId(), student);
        }
        for (Task task : taskList) {
            taskMap.put(task.getTaskId(), task);
        }
        String formatUserName = "%s %s";
        for (TaskResult taskResult : taskResultsList) {
            taskResult.setStudentName("-");
            if (studentMap.containsKey(taskResult.getUserId())) {
                Student student = (Student)studentMap.get(taskResult.getUserId());
                taskResult.setStudentName(String.format(formatUserName, student.getFirstName(), student.getLastName()));
                taskResult.setStudentFirstName(student.getFirstName());
                taskResult.setStudentLastName(student.getLastName());
            } else {
                logger.warn("No Student found for studentNumber {} ", (Object)taskResult.getUserId());
            }
            taskResult.setTaskName("-");
            if (taskMap.containsKey(taskResult.getTaskId())) {
                Task task = (Task)taskMap.get(taskResult.getTaskId());
                taskResult.setTaskName(task.getName());
                continue;
            }
            logger.warn("No Task found for TaskId {} ", (Object)taskResult.getTaskId());
        }
        return taskResultsList;
    }

    public List<Student> getStudentsPerTask(@PathVariable(value="taskId") String taskId) {
        String cypher = "Match (a:Task) - [StudentHasTask] - (Student:Student) where a.taskId=$taskId  RETURN Student";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("taskId", taskId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.studentConverter.convertToStudent(result, "Student");
    }

    public List<Task> getTasksPerLearningGroup(String learningGroupId) {
        String cypher = "Match (Task:Task) - [:CourseHasTask|LearngroupToCourse*2..2] - (LearningGroup:LearningGroup) where LearningGroup.groupId=$lgId  RETURN Task";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("lgId", learningGroupId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.taskConverter.convertToTask(result, "Task");
    }

    public void deleteTasksPerLearningGroupAndStudentSet(String learningGroupId, Set<String> studentIds) {
        Transaction tx = this.getSessionSave().beginTransaction();
        try {
            for (String studentId : studentIds) {
                String cypher = "Match (Student:Student) - [rsh:StudentHasTask] - (Task:Task) - [:CourseHasTask|LearngroupToCourse*2..2] - (LearningGroup:LearningGroup) where LearningGroup.groupId=$lgId and Student.studentId=$studentId delete rsh ";
                HashMap<String, String> parameter = new HashMap<String, String>();
                parameter.put("lgId", learningGroupId);
                parameter.put("studentId", studentId);
                this.logDebugCypher(cypher, parameter);
                List list = this.statementRunner.runCyperStatementPreparedWithTx(cypher, parameter, tx);
            }
            tx.commit();
        }
        catch (Exception e) {
            logger.error("Exception while deleting task to StudentIds {}" + e.getMessage(), (Throwable)e);
        }
    }

    public void deleteCourseAndTasks(String courseId) {
        try (Session session = this.getSessionSave();){
            String cypherDeleteStatement = "Optional Match (n:Task) -[f:CourseHasTask]-(c:Course) where c.courseId = \"" + courseId + "\"  detach delete n,c";
            if (logger.isDebugEnabled()) {
                logger.debug("Cypher is {}", (Object)cypherDeleteStatement);
            }
            this.statementRunner.runCypherWrite(cypherDeleteStatement);
            String cypher2 = " Optional Match (c:Course) where c.courseId = \"" + courseId + "\" detach delete c";
            if (logger.isDebugEnabled()) {
                logger.debug("cypher is {} ", (Object)cypher2);
            }
            this.statementRunner.runCypherWrite(cypher2);
        }
        catch (Exception e) {
            logger.error("Exception while deleting Tasks ", (Throwable)e);
            throw e;
        }
    }

    public void deleteTasks(String taskId) {
        try (Session session = this.getSessionSave();){
            String cypherDeleteStatement = "Optional Match (n:Task) where n.taskId = \"" + taskId + "\"  detach delete n";
            if (logger.isDebugEnabled()) {
                logger.debug("Cypher is {}", (Object)cypherDeleteStatement);
            }
            this.statementRunner.runCypherWrite(cypherDeleteStatement);
        }
        catch (Exception e) {
            logger.error("Exception while deleting Tasks ", (Throwable)e);
            throw e;
        }
    }

    public void deleteTeacher(String teacherId) {
        List teachersLearnGroups = this.getLearnGroupPerTeacher(teacherId);
        if (!teachersLearnGroups.isEmpty()) {
            throw new IllegalStateException("Lehrer hat noch lerngruppen ");
        }
        try (Session session = this.getSessionSave();){
            String cypherDeleteStatement = "Optional Match (n:Teacher) where n.teacherId = $teacherId  detach delete n";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("teacherId", teacherId);
            if (logger.isDebugEnabled()) {
                logger.debug("Cypher is {}", (Object)cypherDeleteStatement);
            }
            this.statementRunner.runCyperStatementPrepared(cypherDeleteStatement, parameter);
        }
        catch (Exception e) {
            logger.error("Exception while deleting Tasks ", (Throwable)e);
            throw e;
        }
    }

    private Map<String, Object> fillParameterMapTask(Task task) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("structure", task.getStructure());
        parameter.put("name", task.getName());
        parameter.put("description", task.getDescription());
        parameter.put("type", task.getType());
        parameter.put("url", task.getUrl());
        parameter.put("taskId", task.getTaskId());
        parameter.put("toolId", task.getToolId());
        parameter.put("ltiLiLineItemMaxPoints", task.getLtiLineItemMaxPoints());
        parameter.put("ltiLiLineItemTag", task.getLtiLiLineItemTag());
        parameter.put("ltiLiResourceId", task.getLtiLiResourceId());
        parameter.put("ltiResourceLinkId", task.getLtiResourceLinkId());
        parameter.put("ltiLtiLinkId", task.getLtiLtiLinkId());
        parameter.put("ltiCustomParams", task.getLtiCustomParams());
        parameter.put("ltiThumbnailUrl", task.getLtiThumbnailUrl());
        parameter.put("ltiIconUrl", task.getLtiIconUrl());
        return parameter;
    }

    public void createTaskAndRelation(Task task, String courseId) throws Exception {
        MyTransActionWork myTransActionWork;
        boolean hasError = false;
        try (Session session = this.getSessionSave();){
            if (StringUtils.isEmpty((CharSequence)task.getTaskId())) {
                String taskId = UUID.randomUUID().toString();
                if (logger.isDebugEnabled()) {
                    logger.debug("create taskId {} beacuse TaskId was empty ", (Object)taskId);
                }
                task.setTaskId(taskId);
            }
            String cypher = "CREATE (a:Task) SET a.taskId = $taskId SET a.name = $name SET a.description  = $description SET a.ltiLiLineItemMaxPoints = $ltiLiLineItemMaxPoints SET a.type  = $type SET a.url  = $url SET a.toolId = $toolId SET a.structure  = $structure SET a.ltiLiLineItemTag = $ltiLiLineItemTag SET a.ltiLiResourceId = $ltiLiResourceId SET a.ltiResourceLinkId = $ltiResourceLinkId SET a.ltiLtiLinkId = $ltiLtiLinkId SET a.ltiCustomParams = $ltiCustomParams SET a.ltiThumbnailUrl = $ltiThumbnailUrl SET a.ltiIconUrl = $ltiIconUrl RETURN a.taskId + ', from node ' + id(a)";
            Map parameter = this.fillParameterMapTask(task);
            this.logDebugCypher(cypher, parameter);
            myTransActionWork = new MyTransActionWork(cypher, parameter);
            Object result = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result {}", result);
            }
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        try (Session session = this.getSessionSave();){
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("create relation CourseId {} taskId {} TaskName {}  ", new Object[]{courseId, task.getTaskId(), task.getName()});
                }
                String stmt = "Match (a:Course),(b:Task) WHERE a.courseId = $courseId AND b.taskId = $taskId   CREATE (a)-[r:CourseHasTask]->(b)  RETURN type(r)";
                parameter.put("courseId", courseId);
                parameter.put("taskId", task.getTaskId());
                myTransActionWork = new MyTransActionWork(stmt, parameter);
                Object o = session.writeTransaction((TransactionWork)myTransActionWork);
                if (logger.isDebugEnabled()) {
                    logger.debug("Result" + o);
                }
            }
            catch (Exception e) {
                logger.error("cant create Relation Course - task - Exception taskId {} courseId {} ParameterMap {} Exception {}", new Object[]{courseId, task.getTaskId(), parameter, e.getMessage(), e});
                hasError = false;
            }
        }
        if (hasError) {
            logger.error("DELETE Course with ID {} ", (Object)task.getTaskId());
            throw new Exception("cant create course ");
        }
    }

    public void updateTask(Task task) throws Exception {
        try (Session session = this.getSessionSave();){
            if (StringUtils.isEmpty((CharSequence)task.getTaskId())) {
                task.setTaskId(UUID.randomUUID().toString());
            }
            String stmt = "MATCH (a:Task { taskId : $taskIdWhere } ) SET a.taskId = $taskId SET a.name = $name SET a.description  = $description SET a.ltiLiLineItemMaxPoints = $ltiLiLineItemMaxPoints SET a.type  = $type SET a.url  = $url SET a.toolId = $toolId SET a.structure  = $structure SET a.ltiLiLineItemTag = $ltiLiLineItemTag SET a.ltiLiResourceId = $ltiLiResourceId SET a.ltiResourceLinkId = $ltiResourceLinkId SET a.ltiLtiLinkId = $ltiLtiLinkId SET a.ltiCustomParams = $ltiCustomParams SET a.ltiThumbnailUrl = $ltiThumbnailUrl SET a.ltiIconUrl = $ltiIconUrl RETURN a.number + ', from node ' + id(a)";
            Map parameter = this.fillParameterMapTask(task);
            parameter.put("taskIdWhere", task.getTaskId());
            MyTransActionWork myTransActionWork = new MyTransActionWork(stmt, parameter);
            Object o = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result" + o);
            }
        }
    }

    private Map<String, Object> fillParameterMapTool(Tool tool) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("toolId", tool.getToolId());
        parameter.put("toolName", tool.getToolName());
        parameter.put("clientId", tool.getClientId());
        parameter.put("description", tool.getToolDescription());
        parameter.put("deeplinkUrl", tool.getDeeplinkUrl());
        parameter.put("loginInitUrl", tool.getLoginInitUrl());
        parameter.put("toolJwksUrl", tool.getToolJwksUrl());
        parameter.put("redirectUrls", tool.getRedirectUrls());
        parameter.put("keyId", tool.getKeyId());
        parameter.put("privateKeyAsPem", tool.getPrivateKeyAsPem());
        parameter.put("publicKeyAsPem", tool.getPublicKeyAsPem());
        parameter.put("useAgs", tool.getUseAgs());
        parameter.put("useNamesAndRoles", tool.getUseNamesAndRoles());
        parameter.put("deploymentId", tool.getDeploymentId());
        parameter.put("toolUrl", tool.getToolUrl());
        return parameter;
    }

    public void createToolAndRelation(Tool tool, String schoolId) throws Exception {
        Object o;
        MyTransActionWork myTransActionWork;
        boolean hasError = false;
        try (Session session = this.getSessionSave();){
            if (StringUtils.isEmpty((CharSequence)tool.getToolId())) {
                tool.setToolId(UUID.randomUUID().toString());
                if (logger.isDebugEnabled()) {
                    logger.debug("created toolId {} ", (Object)tool.getToolId());
                }
            }
            String stmt = "CREATE (a:Tool) SET a.toolId = $toolId SET a.toolName = $toolName SET a.clientId  = $clientId SET a.deploymentId  = $deploymentId SET a.toolDescription  = $description SET a.deeplinkUrl  = $deeplinkUrl SET a.loginInitUrl  = $loginInitUrl SET a.toolJwksUrl  = $toolJwksUrl SET a.redirectUrls  = $redirectUrls  SET a.keyId  = $keyId  SET a.privateKeyPem  = $privateKeyAsPem  SET a.publicKeyPem  = $publicKeyAsPem  SET a.useAgs  = $useAgs  SET a.useNamesAndRoles  = $useNamesAndRoles  SET a.toolUrl  = $toolUrl  RETURN a.toolId + ', from node ' + id(a)";
            if (logger.isDebugEnabled()) {
                logger.debug("Create cypher for tool is \n{}", (Object)stmt);
            }
            Map parameter = this.fillParameterMapTool(tool);
            if (logger.isDebugEnabled()) {
                logger.debug("Parameter Map for creating a tool {}", (Object)parameter);
            }
            myTransActionWork = new MyTransActionWork(stmt, parameter);
            o = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result {}", o);
            }
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        try (Session session = this.getSessionSave();){
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("create relation ToolId {} SchoolId {} ToolName {}  ", new Object[]{tool.getToolId(), schoolId, tool.getToolName()});
                }
                String stmt = "Match (a:School),(b:Tool)  WHERE a.schoolId = $schoolId AND b.toolId = $toolId   CREATE (a)-[r:SchoolHasTool]->(b)  RETURN type(r)";
                parameter.put("schoolId", schoolId);
                parameter.put("toolId", tool.getToolId());
                if (logger.isDebugEnabled()) {
                    logger.debug("Statement for parameter {} Relation Stmt {}", parameter, (Object)stmt);
                }
                myTransActionWork = new MyTransActionWork(stmt, parameter);
                o = session.writeTransaction((TransactionWork)myTransActionWork);
                if (logger.isDebugEnabled()) {
                    logger.debug("Result {}", o);
                }
            }
            catch (Exception e) {
                logger.error("cant create Relation Course - task - Exception ToolId {} SchoolId {} ParameterMap {} Exception {}", new Object[]{schoolId, tool.getToolId(), parameter, e.getMessage(), e});
                hasError = false;
            }
        }
        if (hasError) {
            logger.error("error creating Tool with ID {} ", (Object)tool.getToolId());
            throw new Exception("cant create Tool ");
        }
    }

    public void updateTool(Tool tool) throws Exception {
        try (Session session = this.getSessionSave();){
            if (StringUtils.isEmpty((CharSequence)tool.getToolId())) {
                tool.setToolId(UUID.randomUUID().toString());
            }
            String stmt = "MATCH (a:Tool { toolId : $toolIdWhere } ) SET a.toolId = $toolId SET a.toolName = $toolName SET a.clientId  = $clientId SET a.deploymentId  = $deploymentId SET a.toolDescription  = $description SET a.deeplinkUrl  = $deeplinkUrl SET a.loginInitUrl  = $loginInitUrl SET a.toolJwksUrl  = $toolJwksUrl SET a.redirectUrls  = $redirectUrls  SET a.keyId  = $keyId  SET a.privateKeyPem  = $privateKeyAsPem  SET a.publicKeyPem  = $publicKeyAsPem  SET a.useAgs  = $useAgs  SET a.useNamesAndRoles  = $useNamesAndRoles  SET a.toolUrl  = $toolUrl   RETURN a.toolId + ', from node ' + id(a)";
            Map parameter = this.fillParameterMapTool(tool);
            parameter.put("toolIdWhere", tool.getToolId());
            if (logger.isDebugEnabled()) {
                logger.debug("Parameter {} Cypher {} ", (Object)parameter, (Object)stmt);
            }
            MyTransActionWork myTransActionWork = new MyTransActionWork(stmt, parameter);
            Object o = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result {}", o);
            }
        }
    }

    public void deleteTool(String toolId) throws Exception {
        try (Session session = this.getSessionSave();){
            String stmt = "MATCH (a:Tool { toolId : $toolIdWhere } )  detach delete a";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("toolIdWhere", toolId);
            if (logger.isDebugEnabled()) {
                logger.debug("Parameter {} Cypher {} ", parameter, (Object)stmt);
            }
            MyTransActionWork myTransActionWork = new MyTransActionWork(stmt, parameter);
            Object o = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result {}", o);
            }
        }
    }

    private List<Tool> checkForRemoval(List<Tool> toolsToCheck) {
        ArrayList<Tool> result = new ArrayList<Tool>(toolsToCheck);
        if (this.removeBeckerAlexanderFromToolList) {
            for (Tool tool : toolsToCheck) {
                if (!tool.getToolUrl().contains("https://becker-alexander.de")) continue;
                result.remove(tool);
                logger.warn("removed tool {} from result", (Object)tool);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("no removal from https://becker-alexander.de");
        }
        return result;
    }

    public List<Tool> getToolsForSchool(String schoolId) {
        String cypher = "Match (a:School) - [r:SchoolHasTool] -> (tool:Tool) where a.schoolId= $schoolId  RETURN tool";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("schoolId", schoolId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        List toolList = this.toolConverter.convertToTool(result, "tool");
        toolList = this.checkForRemoval(toolList);
        return toolList;
    }

    public List<Tool> getToolsById(String toolId) {
        String cypher = "Match (tool:Tool)  where tool.toolId=$toolId  RETURN tool";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("toolId", toolId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        if (logger.isDebugEnabled()) {
            logger.debug("Result size {} \n Result{}", (Object)result.size(), (Object)result);
        }
        return this.toolConverter.convertToTool(result, "tool");
    }

    public List<LearningGroup> getLearnGroupPerTeacher(@PathVariable(value="teacherNumber") String teacherId) {
        String cypher = "Match (learnGroup:LearningGroup) <- [TeacherHasGroup] - (a:Teacher) where a.teacherId=$teacherId  RETURN learnGroup order by learnGroup.learngroupName";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("teacherId", teacherId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.learnGroupConverter.convertToLearningGroup(result, "learnGroup");
    }

    public List<LearningGroup> getLearnGroupPerSchool(@PathVariable(value="schoolNumber") String schoolNumber) {
        String cypher = "Optional MATCH (a:School)-[*1..2]-(b:LearningGroup) where a.schoolId=$schoolId  RETURN DISTINCT b order by b.learngroupName";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("schoolId", schoolNumber);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.learnGroupConverter.convertToLearningGroup(result, "b");
    }

    public List<LearningGroup> getLearnGroupForCourse(@PathVariable(value="courseId") String courseId) {
        String cypher = "Optional MATCH (a:Course)-[*1..2]-(b:LearningGroup) where a.courseId=$courseId  RETURN b ";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("courseId", courseId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.learnGroupConverter.convertToLearningGroup(result, "b");
    }

    public List<Student> getStudentsPerLearnGroup(@PathVariable(value="lgNumber") String lerngroupId) {
        String cypher = "Match (a:LearningGroup) - [StudentInGroup] - (student:Student) where a.groupId=$learngroupNumber RETURN student order by student.lastname,student.firstname";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("learngroupNumber", lerngroupId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.studentConverter.convertToStudent(result, "student");
    }

    public Student getStudentByEmail(Student student) {
        String cypher = "Match (student:Student) where student.email=$email RETURN student";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("email", student.getEmail());
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.convertNeo4JResultToStudent(result, student.getEmail(), "student");
    }

    private Student convertNeo4JResultToStudent(List<Record> result, String studentNumber, String resultVar) {
        List resultList = this.studentConverter.convertToStudent(result, resultVar);
        if (resultList != null && resultList.size() > 0) {
            return (Student)resultList.get(0);
        }
        logger.warn("studentById {} found {} returning null ", (Object)studentNumber, result);
        return null;
    }

    public List<Student> getStudentsPerSchool(String schoolId) {
        String cypher = "Match (a:School) - [StudentIn] - (student:Student) where a.schoolId=$schoolId  RETURN student order by student.lastname,student.firstname";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("schoolId", schoolId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.studentConverter.convertToStudent(result, "student");
    }

    public Student findStudentById(String studentId) {
        return this.findStudentByValue("studentId", studentId);
    }

    private Student findStudentByValue(String colName, String studentId) {
        String cypher = " MATCH (student:Student { " + colName + " : $studentId } ) return student";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("studentId", studentId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.convertNeo4JResultToStudent(result, studentId, "student");
    }

    public Student findStudentByLoginName(String loginName) {
        return this.findStudentByValue("loginName", loginName);
    }

    public List<School> getSchoolForStudentByLoginName(String loginName) {
        String cypher = "Match (a:Student) - [StudentIn] - (school:School) where a.loginName=$studentNumber  RETURN school";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("studentNumber", loginName);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.schoolConverter.convertToSchool(result, "school");
    }

    public void saveStudent(Student student) {
        String cypher = "match ( a:Student  { studentId: $studentId } ) set  a.firstname= $firstName ,a.lastname=$lastName ,a.comment1=$comment1 ,a.comment2=$comment2 ,a.comment3=$comment3 ,a.email=$email ,a.loginName=$loginName ,a.password=$password ,a.modified=timestamp() RETURN a";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("studentId", student.getStudentId());
        parameters.put("firstName", student.getFirstName());
        parameters.put("lastName", student.getLastName());
        parameters.put("comment1", student.getComment1());
        parameters.put("comment2", student.getComment2());
        parameters.put("comment3", student.getComment3());
        parameters.put("email", student.getEmail());
        parameters.put("loginName", student.getLoginName());
        parameters.put("password", student.getPassword());
        this.logDebugCypher(cypher, parameters);
        this.statementRunner.runCyperStatementPrepared(cypher, parameters);
    }

    public void bulkUpdateStudents(Set<String> studentIds, Student valuesToChange) {
        String cypher = " Unwind $ids as studentId Match ( a:Student  { studentId: studentId }) set   a.comment1=$comment1 ,a.comment2=$comment2 ,a.comment3=$comment3 ,a.modified=timestamp() RETURN *";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("ids", studentIds);
        parameters.put("comment1", valuesToChange.getComment1());
        parameters.put("comment2", valuesToChange.getComment2());
        parameters.put("comment3", valuesToChange.getComment3());
        this.logDebugCypher(cypher, parameters);
        this.statementRunner.runCyperStatementPrepared(cypher, parameters);
    }

    public void deleteStudent(String studentId) {
        String cypher = "MATCH (n:Student) where n.studentId=$studentId  detach delete n;";
        if (logger.isDebugEnabled()) {
            logger.debug("cypher is {}", (Object)cypher);
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("studentId", studentId);
        this.logDebugCypher(cypher, parameter);
        this.statementRunner.runCyperStatementPrepared(cypher, parameter);
    }

    public void deleteStudents(Set<Student> students) {
        ArrayList studentIds = new ArrayList();
        students.forEach(x -> studentIds.add(x.getStudentId()));
        String cypher = "Unwind $ids as myStudentId MATCH (n:Student {studentId: myStudentId})  detach delete n;";
        if (logger.isDebugEnabled()) {
            logger.debug("cypher is {}", (Object)cypher);
        }
        HashMap parameter = new HashMap();
        parameter.put("ids", studentIds);
        this.logDebugCypher(cypher, parameter);
        this.statementRunner.runCyperStatementPrepared(cypher, parameter);
    }

    public List<Teacher> getTeacherPerSchool(String schoolId) {
        String cypher = "Match (a:School) <- [TeacherIn] - (teacher:Teacher) where a.schoolId=$schoolId  RETURN teacher order by teacher.lastname,teacher.firstname";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("schoolId", schoolId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.teacherConverter.convertToTeacher(result, "teacher");
    }

    public List<School> getSchoolForTeacherByLoginName(String loginName) {
        String cypher = "Match (school:School) - [TeacherIn] - (teacher:Teacher) where teacher.loginName=$loginName RETURN school";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("loginName", loginName);
        if (logger.isDebugEnabled()) {
            logger.debug("cypher {} parameter {}", (Object)cypher, parameter);
        }
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        return this.schoolConverter.convertToSchool(result, "school");
    }

    public Teacher findTeacherById(String value) {
        return this.findTeacherById("teacherId", value);
    }

    public Teacher findTeacherByLoginName(String value) {
        return this.findTeacherById("loginName", value);
    }

    private Teacher findTeacherById(String COL_NAME, String teacherId) {
        String cypher = "Match (teacher:Teacher {" + COL_NAME + ":$teacherId })   RETURN teacher";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("teacherId", teacherId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        List teacherList = this.teacherConverter.convertToTeacher(result, "teacher");
        if (teacherList != null && teacherList.size() == 1) {
            return (Teacher)teacherList.get(0);
        }
        logger.warn("not exact one teacher found returning null");
        return null;
    }

    public LearningGroup findLearningGroupById(String lgId) {
        String cypher = "Match (lg:LearningGroup { groupId: $lgId })  return lg";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("lgId", lgId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        List LgList = this.learnGroupConverter.convertToLearningGroup(result, "lg");
        if (LgList != null && LgList.size() == 1) {
            return (LearningGroup)LgList.get(0);
        }
        logger.warn("not exact one teacher found returning null");
        return null;
    }

    public List<School> getAllSchools() {
        String cypher = "match ( a:School)   return a";
        List result = this.statementRunner.runCyperStatementPrepared(cypher, null);
        return this.schoolConverter.convertToSchool(result, "a");
    }

    public List<Teacher> getTeacher() {
        String cypher = "match ( a:Teacher)   return a";
        List result = this.statementRunner.runCyperStatementPrepared(cypher, null);
        return this.teacherConverter.convertToTeacher(result, "a");
    }

    public List<Student> getAllStudents() {
        String cypher = "match ( a:Student)   return a";
        List result = this.statementRunner.runCyperStatementPrepared(cypher, null);
        return this.studentConverter.convertToStudent(result, "a");
    }

    public List<Teacher> getAllTeacher() {
        String cypher = "match ( a:Teacher)   return a";
        List result = this.statementRunner.runCyperStatementPrepared(cypher, null);
        return this.teacherConverter.convertToTeacher(result, "a");
    }

    public List<LearningGroup> getAllLearningGroups() {
        String cypher = "match ( a:LearningGroup)   return a";
        List result = this.statementRunner.runCyperStatementPrepared(cypher, null);
        return this.learnGroupConverter.convertToLearningGroup(result, "a");
    }

    public List<Course> getAllCourses() {
        String cypher = "match ( a:Course)   return a";
        List result = this.statementRunner.runCyperStatementPrepared(cypher, null);
        return this.courseConverter.convertToCourse(result, "a");
    }

    public List<Task> getAllTask() {
        String cypher = "match ( a:Task)   return a";
        List result = this.statementRunner.runCyperStatementPrepared(cypher, null);
        return this.taskConverter.convertToTask(result, "a");
    }

    public List<Tool> getAllTools() {
        String cypher = "match ( a:Task)   return a";
        List result = this.statementRunner.runCyperStatementPrepared(cypher, null);
        return this.toolConverter.convertToTool(result, "a");
    }

    void createSchool(School school) {
        Long now = System.currentTimeMillis();
        school.setCreatedAt(now.longValue());
        school.setModifiedAt(now.longValue());
        this.createSchoolWithTx(school, null);
    }

    public void createSchoolWithTx(School school, Transaction tx) {
        try (Session session = this.getSessionSave();){
            String name = school.getName();
            String plz = school.getZip();
            String number = school.getSchoolId();
            String stmt = "CREATE (a:" + school.getNodeLabel() + ") " + this.setSchoolFields() + "RETURN a ";
            Map parameter = Neo4JBaseService.getSchoolParameterMap((School)school);
            if (logger.isDebugEnabled()) {
                logger.debug("cypher is {}  \nparameter {}", (Object)stmt, (Object)parameter);
            }
            boolean newTransAction = false;
            if (tx == null) {
                tx = session.beginTransaction();
                newTransAction = true;
            }
            this.statementRunner.runCyperStatementPreparedWithTx(stmt, parameter, tx);
            if (logger.isDebugEnabled()) {
                // empty if block
            }
            if (newTransAction) {
                tx.commit();
            }
        }
        catch (Exception e) {
            logger.error("Exception while create school", (Throwable)e);
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    private String setSchoolFields() {
        return "SET a.name = $name SET a.zip  = $zip SET a.schoolId  = $schoolId SET a.location  = $location SET a.street  = $street SET a.streetNumber  = $streetNumber SET a.country  = $country SET a.schoolId  = $schoolId SET a.createdAt= $created SET a.modifiedAt= $modified SET a.backgroundImage= $backgroundImage ";
    }

    public void saveSchoolWithTx(School school, @Nullable Transaction tx) {
        long now = System.currentTimeMillis();
        school.setCreatedAt(now);
        school.setModifiedAt(now);
        String stmt = "Match (a:" + school.getNodeLabel() + ") where a.schoolId = $schoolId " + this.setSchoolFields() + "RETURN a ";
        Map parameter = Neo4JBaseService.getSchoolParameterMap((School)school);
        if (logger.isDebugEnabled()) {
            logger.debug("cypher is {}  \nparameter {}", (Object)stmt, (Object)parameter);
        }
        this.statementRunner.runCyperStatementPrepared(stmt, parameter);
    }

    private static Map<String, Object> getSchoolParameterMap(School school) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("name", school.getName());
        parameter.put("zip", school.getZip());
        parameter.put("location", school.getLocation());
        parameter.put("street", school.getStreet());
        parameter.put("streetNumber", school.getStreetNumber());
        parameter.put("country", school.getCountry());
        parameter.put("schoolId", school.getSchoolId());
        parameter.put("created", school.getCreatedAt());
        parameter.put("modified", school.getModifiedAt());
        parameter.put("backgroundImage", school.getBackgroundImage());
        return parameter;
    }

    public void deleteSchool(String schoolId) {
        try {
            List allLearnGroups = this.getLearnGroupPerSchool(schoolId);
            for (Object learningGroup : allLearnGroups) {
                this.deleteLearningGroup(learningGroup.getGroupId());
            }
            List allStudents = this.getStudentsPerSchool(schoolId);
            for (Object student : allStudents) {
                this.deleteStudent(student.getStudentId());
            }
            List allTeacher = this.getTeacherPerSchool(schoolId);
            for (Teacher teacher : allTeacher) {
                this.deleteTeacher(teacher.getTeacherId());
            }
            List allTools = this.getToolsForSchool(schoolId);
            for (Tool tool : allTools) {
                this.deleteTool(tool.getToolId());
            }
            this.deleteSingeSchool(schoolId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteSingeSchool(String schoolId) {
        try (Session session = this.getSessionSave();){
            String stmt = "MATCH (a:School { schoolId : $schoolIdWhere } )  detach delete a";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("schoolIdWhere", schoolId);
            if (logger.isDebugEnabled()) {
                logger.debug("Parameter {} Cypher {} ", parameter, (Object)stmt);
            }
            MyTransActionWork myTransActionWork = new MyTransActionWork(stmt, parameter);
            Object o = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result {}", o);
            }
        }
    }

    public void saveTeacher(Teacher teacher) {
        this.saveTeacherWithTx(teacher, null);
    }

    public void saveTeacherWithTx(Teacher teacher, Transaction tx) {
        String cypher = "match ( a:Teacher  { teacherId: $teacherId } ) set  a.firstname= $firstName set a.lastname=  $lastName set a.loginName=  $loginName set a.isAdmin=  $isAdmin set a.password=  $password set a.modified=timestamp()  RETURN a";
        if (logger.isDebugEnabled()) {
            logger.debug("cypher is \"{}\"", (Object)cypher);
        }
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("teacherId", teacher.getTeacherId());
        parameter.put("firstName", teacher.getFirstName());
        parameter.put("lastName", teacher.getLastName());
        parameter.put("loginName", teacher.getLoginName());
        parameter.put("isAdmin", teacher.getAdmin());
        parameter.put("password", teacher.getPassword());
        this.logDebugCypher(cypher, parameter);
        boolean newTransAction = false;
        try (Session session = this.getSessionSave();){
            if (tx == null) {
                tx = session.beginTransaction();
                newTransAction = true;
            }
            this.statementRunner.runCyperStatementPreparedWithTx(cypher, parameter, tx);
            if (newTransAction) {
                tx.commit();
            }
        }
    }

    public void createTeacherAndSchool(School school, Teacher teacher) {
        Transaction tx = null;
        try (Session session = this.getSessionSave();){
            tx = session.beginTransaction();
            tx = null;
            this.createPerson((PersonIF)teacher);
            this.createSchoolWithTx(school, tx);
            this.createRelFromNode1ToNode2((NodeIf)school, (NodeIf)teacher, "TeacherIn");
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            logger.error("Exception while creating Teacher and School ", (Throwable)e);
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public void createPerson(PersonIF person) {
        try (Session session = this.getSessionSave();){
            String stmt = "CREATE (a:" + person.getNodeLabel() + ") SET a.firstname = $firstname SET a.lastname  = $lastname SET a.loginName  = $loginName SET a.password  = $password ";
            boolean isStudent = person instanceof Student;
            stmt = isStudent ? stmt + "SET a.comment1  = $comment1 SET a.comment2 = $comment2 SET a.comment3  = $comment3 " : stmt + "SET a.isAdmin  = $isAdmin ";
            stmt = stmt + "SET a." + person.getPrimaryKeyPropertyName() + "  = $id RETURN a";
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("firstname", person.getFirstName());
            parameter.put("lastname", person.getLastName());
            parameter.put("loginName", person.getLoginName());
            parameter.put("password", person.getPassword());
            if (isStudent) {
                Student student = (Student)person;
                parameter.put("comment1", student.getComment1());
                parameter.put("comment2", student.getComment2());
                parameter.put("comment3", student.getComment3());
            } else {
                Teacher teacher = (Teacher)person;
                parameter.put("isAdmin", teacher.getAdmin());
            }
            parameter.put("id", person.getPrimaryKey());
            if (logger.isDebugEnabled()) {
                logger.debug("cypher is {} \nparameter {} ", (Object)stmt, parameter);
            }
            MyTransActionWork myTransActionWork = new MyTransActionWork(stmt, parameter);
            Object o = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result {} ", o);
            }
        }
    }

    public void createRelFromNode1ToNode2(NodeIf node1, NodeIf node2, RelationIF relation) {
        this.createRelFromNode1ToNode2(node1, node2, relation.getRelationLabel());
    }

    public void createRelFromNode1ToNode2(NodeIf node1, NodeIf node2, String relationLabel) {
        try (Session session = this.getSessionSave();){
            String cypher = "Match (a:" + node1.getNodeLabel() + "),(b:" + node2.getNodeLabel() + ") WHERE a." + node1.getPrimaryKeyPropertyName() + "= $aNumber AND b." + node2.getPrimaryKeyPropertyName() + " = $bNumber  CREATE (a) <-[r:" + relationLabel + "]- (b)  RETURN type(r)";
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("aNumber", node1.getPrimaryKey());
            parameter.put("bNumber", node2.getPrimaryKey());
            if (logger.isDebugEnabled()) {
                logger.debug("Parameter Map is {}", parameter);
            }
            this.logDebugCypher(cypher, parameter);
            if (logger.isDebugEnabled()) {
                logger.debug("working for " + node1.getNodeLabel() + " {} and " + node2.getNodeLabel() + " {} ", node1.getPrimaryKey(), node2.getPrimaryKey());
            }
            MyTransActionWork myTransActionWork = new MyTransActionWork(cypher, parameter);
            try {
                Object o = session.writeTransaction((TransactionWork)myTransActionWork);
                if (logger.isDebugEnabled()) {
                    logger.debug("Result {}", o);
                }
            }
            catch (Exception e) {
                logger.warn("noting found for teacher {} and school {} ", new Object[]{node2.getPrimaryKey(), node1.getPrimaryKey(), e});
            }
        }
    }

    public void createStudent(Student person) {
        try (Session session = this.getSessionSave();){
            String stmt = "CREATE (a:" + person.getNodeLabel() + ") SET a.firstname = $firstname SET a.lastname  = $lastname SET a.comment1  = $comment1 SET a.comment2 = $comment2 SET a.comment3  = $comment3 SET a.email  = $email SET a.loginName  = $loginName SET a.password  = $password SET a.studentId  = $studentId RETURN a";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("firstname", person.getFirstName());
            parameter.put("lastname", person.getLastName());
            parameter.put("comment1", person.getComment1());
            parameter.put("comment2", person.getComment2());
            parameter.put("comment3", person.getComment3());
            parameter.put("studentId", person.getStudentId());
            parameter.put("email", person.getEmail());
            parameter.put("loginName", person.getLoginName());
            parameter.put("password", person.getPassword());
            if (logger.isDebugEnabled()) {
                logger.debug("cypher is {} \nparameter {} ", (Object)stmt, parameter);
            }
            MyTransActionWork myTransActionWork = new MyTransActionWork(stmt, parameter);
            Object o = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result {}", o);
            }
        }
    }

    public void createLearnGroup(LearningGroup learnGroup) {
        try (Session session = this.getSessionSave();){
            String cypher = "CREATE (a:LearningGroup) SET a.learngroupName = $name SET a.groupId  = $groupId RETURN a.groupId + ', from node ' + id(a)";
            Map parameter = Neo4JBaseService.getLearningGroupParameterMap((LearningGroup)learnGroup);
            this.logDebugCypher(cypher, parameter);
            MyTransActionWork myTransActionWork = new MyTransActionWork(cypher, parameter);
            Object o = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result", o);
            }
        }
    }

    public void updateLearnGroup(LearningGroup learnGroup) {
        try (Session session = this.getSessionSave();){
            String cypher = "MATCH (a:LearningGroup { groupId: $groupId } ) SET a.learngroupName= $name SET a.groupId  = $groupId RETURN a.groupId + ', from node ' + id(a)";
            Map parameter = Neo4JBaseService.getLearningGroupParameterMap((LearningGroup)learnGroup);
            this.logDebugCypher(cypher, parameter);
            MyTransActionWork myTransActionWork = new MyTransActionWork(cypher, parameter);
            Object o = session.writeTransaction((TransactionWork)myTransActionWork);
            if (logger.isDebugEnabled()) {
                logger.debug("Result {}", o);
            }
        }
    }

    public void createRelLearnGroupTeacher(String learnGroupId, String teacherId) {
        try (Session session = this.getSessionSave();){
            String cypher = "Match (a:Teacher),(b:LearningGroup) WHERE a.teacherId = $teacherId AND b.groupId = $groupId  CREATE (a)-[r:TeacherHasGroup]->(b)  RETURN type(r)";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("groupId", learnGroupId);
            parameter.put("teacherId", teacherId);
            this.logDebugCypher(cypher, parameter);
            MyTransActionWork myTransActionWork = new MyTransActionWork(cypher, parameter);
            Object o = session.writeTransaction((TransactionWork)myTransActionWork);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Result {}", o);
                }
            }
            catch (Exception e) {
                logger.warn("noting found for teacher {} and school {} ", (Object)this.learnGroupNumber, (Object)this.teacherNumber);
            }
        }
    }

    public void createRelLearnGroupStudent(String learnGroupId, String studentId) {
        try (Session session = this.getSessionSave();){
            String cypher = "Match (a:Student),(b:LearningGroup) WHERE a.studentId = $studentId AND b.groupId = $groupId  CREATE (a)-[r:StudentInGroup]->(b)  RETURN type(r)";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("groupId", learnGroupId);
            parameter.put("studentId", studentId);
            this.logDebugCypher(cypher, parameter);
            MyTransActionWork myTransActionWork = new MyTransActionWork(cypher, parameter);
            try {
                Object o = session.writeTransaction((TransactionWork)myTransActionWork);
                if (logger.isDebugEnabled()) {
                    logger.debug("Result {}", o);
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("noting found for leranGroup {} and Student {} ", (Object)learnGroupId, (Object)studentId);
                }
            }
        }
    }

    public void createRelPersonSchool(String schoolId, PersonIF person, String personLabel, String relationLabel) {
        try (Session session = this.getSessionSave();){
            String stmt = "Match (a:" + personLabel + "),(b:School) WHERE a." + person.getPrimaryKeyPropertyName() + " = $personId AND b.schoolId = $schoolId  CREATE (a)-[r:" + relationLabel + "]->(b)  RETURN type(r)";
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("schoolId", schoolId);
            parameter.put("personId", person.getPrimaryKey());
            if (logger.isDebugEnabled()) {
                logger.debug("working for person {} and school {} personLabel {} relationLabel {} ", new Object[]{person.getPrimaryKey(), schoolId, personLabel, relationLabel});
            }
            MyTransActionWork myTransActionWork = new MyTransActionWork(stmt, parameter);
            try {
                Object o = session.writeTransaction((TransactionWork)myTransActionWork);
                if (logger.isDebugEnabled()) {
                    logger.debug("Result {}", o);
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("noting found for teacher {} and school {} ", new Object[]{schoolId, person.getPrimaryKey(), e});
                }
            }
        }
    }

    public void deleteLearningGroup(String lgId) {
        try (Session neoSession = this.getSessionSave();){
            Transaction tx = neoSession.beginTransaction();
            try {
                List coursesForLearningGroup = this.getCoursesForLearnGroup(lgId);
                if (logger.isDebugEnabled()) {
                    logger.debug("found '{} ' courses for LearnngGroup {} ", (Object)coursesForLearningGroup.size(), (Object)lgId);
                }
                for (Course course : coursesForLearningGroup) {
                    this.deleteCourseAndTasks(course.getCourseId());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("delete course Id: {} Comment '{}' and tasks", (Object)course.getCourseId(), (Object)course.getComment());
                }
                this.deleteDetachLearningGroup(lgId);
                tx.commit();
            }
            catch (Exception e) {
                logger.error("Exception while deleteing LearningGroup " + lgId + " ", (Throwable)e);
                tx.rollback();
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    private void deleteDetachLearningGroup(String lgId) {
        String cypher = "MATCH (n:LearningGroup) where n.groupId= $lgId  detach delete n;";
        if (logger.isDebugEnabled()) {
            logger.debug("cypher is {}", (Object)cypher);
        }
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("lgId", lgId);
        this.logDebugCypher(cypher, parameter);
        this.statementRunner.runCyperStatementPrepared(cypher, parameter);
    }

    public List<Course> findCoursesBySchoolId(String schoolId) {
        String cypher = "Match (school:School) - [*1..4] - (Course:Course)  where school.schoolId=$schoolId RETURN  distinct(Course)";
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("schoolId", schoolId);
        this.logDebugCypher(cypher, parameter);
        List result = this.statementRunner.runCyperStatementPrepared(cypher, parameter);
        List resultList = this.courseConverter.convertToCourse(result, "Course");
        return resultList;
    }

    public synchronized void saveStudentsFromUploadAndCreateConnection(List<Student> studentsToSave, String schoolId) {
        for (Student student : studentsToSave) {
            String StudentId = UUID.randomUUID().toString();
            student.setStudentId(StudentId);
            this.createStudent(student);
            this.createRelPersonSchool(schoolId, (PersonIF)student, "Student", "StudentIn");
            if (!logger.isDebugEnabled()) continue;
            logger.debug("created in school {} student {} ", (Object)schoolId, (Object)student);
        }
    }

    public void runStatement(String statement) throws Exception {
        this.statementRunner.runCyperStatementPreparedWithException(statement, new HashMap());
    }

    @Value(value="${feature.suppress.beckeralexander}")
    public void setRemoveBeckerAlexanderFromToolList(boolean removeBeckerAlexanderFromToolList) {
        this.removeBeckerAlexanderFromToolList = removeBeckerAlexanderFromToolList;
    }

    public void afterPropertiesSet() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("properties Set neo4jBaseService");
        }
    }
}

