/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.neodb;

import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.Record;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatementRunner
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(StatementRunner.class);
    private Neo4JBaseService neo4JBaseService;

    public StatementRunner(@Autowired Neo4JBaseService neo4JBaseService) {
        this.neo4JBaseService = neo4JBaseService;
    }

    private List<Record> runCyperStatement(String cyperStatement) {
        try (Session session = this.neo4JBaseService.getSessionSave();){
            List result;
            List list = result = session.beginTransaction().run(cyperStatement).list();
            return list;
        }
    }

    public List<Record> runCyperStatementPreparedWithException(String cypherStatement, Map<String, Object> parameter) throws Exception {
        List result;
        logger.debug("cypher '{}' parameter '{}' ", (Object)cypherStatement, parameter);
        try (Session session = this.neo4JBaseService.getSessionSave();){
            Transaction tx = session.beginTransaction();
            result = tx.run(cypherStatement, parameter).list();
            tx.commit();
        }
        return result;
    }

    public List<Record> runCyperStatementPreparedWithExceptionWithTx(String cypherStatement, Map<String, Object> parameter, Transaction tx) throws Exception {
        logger.debug("cypher '{}' parameter '{}' ", (Object)cypherStatement, parameter);
        List result = tx.run(cypherStatement, parameter).list();
        return result;
    }

    public List<Record> runCyperStatementPrepared(String cypherStatement, Map<String, Object> parameter) {
        List list;
        block8: {
            Session session = this.neo4JBaseService.getSessionSave();
            try {
                list = this.runCyperStatementPreparedWithException(cypherStatement, parameter);
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("Exception while execute {} with Parameter {} ", new Object[]{cypherStatement, parameter, e});
                    return null;
                }
            }
            session.close();
        }
        return list;
    }

    public List<Record> runCyperStatementPreparedWithTx(String cypherStatement, Map<String, Object> parameter, Transaction tx) {
        List list;
        block8: {
            Session session = this.neo4JBaseService.getSessionSave();
            try {
                list = this.runCyperStatementPreparedWithExceptionWithTx(cypherStatement, parameter, tx);
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("Exception while execute {} with Parameter {} ", new Object[]{cypherStatement, parameter, e});
                    return null;
                }
            }
            session.close();
        }
        return list;
    }

    public void runCypherWrite(String cypher) {
        block8: {
            Transaction tx = null;
            try (Session session = this.neo4JBaseService.getSessionSave();){
                tx = session.beginTransaction();
                List result = tx.run(cypher).list();
                tx.commit();
            }
            catch (Exception e) {
                logger.error("Exception while writing cypher {} to neo4J", (Object)cypher, (Object)e);
                if (tx == null) break block8;
                tx.rollback();
            }
        }
    }
}

