/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.neodb.migration;

import de.mahlsdorf.groupservice.model.node.DbMigrationVersionNode;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.neodb.migration.DbMigrationResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class DBMigrator
implements InitializingBean {
    private static final Pattern VERSION_PATTERN = Pattern.compile("([\\d]+).*?\\.sql");
    private String dbmigrationFolder;
    private static final Logger logger = LoggerFactory.getLogger(DBMigrator.class);
    private Neo4JBaseService neo4JBaseService;
    @Autowired
    ConfigurableApplicationContext appContext;
    private boolean runMigration = false;

    public DBMigrator(@Autowired Neo4JBaseService neo4JBaseService, @Autowired ConfigurableApplicationContext appContext, @Value(value="${runMigration}") Boolean runMigration) {
        this.neo4JBaseService = neo4JBaseService;
        this.appContext = appContext;
        this.runMigration = runMigration;
    }

    public void afterPropertiesSet() throws Exception {
        logger.info("try to start migration");
        this.doMigration(new DbMigrationResourceResolver(this.dbmigrationFolder));
    }

    void doMigration(DbMigrationResourceResolver dbMigrationFileResolver) throws IOException {
        if (!this.runMigration) {
            logger.warn("running no migrations appicationProperty runMigration={}", (Object)this.runMigration);
            return;
        }
        Resource[] resources = dbMigrationFileResolver.getMigrationResources();
        logger.info("found {} migration resources in path {} ", (Object)resources.length, (Object)this.dbmigrationFolder);
        DbMigrationVersionNode node = this.neo4JBaseService.getDBMigrationVersionNode();
        logger.info("DBMigrationsVersionNode {}", (Object)node);
        TreeSet versionSet = node.getSortedVersionSet();
        logger.info("Version Set {}", (Object)node.getSortedVersionSet());
        HashSet newVersionSet = new HashSet();
        TreeMap<String, Resource> orderedMap = new TreeMap<String, Resource>();
        for (Resource res : resources) {
            orderedMap.put(res.getURI().toString(), res);
        }
        this.runMigrationStatements(this.neo4JBaseService, orderedMap, (Set)versionSet, newVersionSet);
        if (!newVersionSet.isEmpty()) {
            for (String s : newVersionSet) {
                node.addVersion(s);
            }
            this.neo4JBaseService.saveDBMigrationVersionNode(node);
        }
    }

    private void runMigrationStatements(Neo4JBaseService neo4JBaseService, TreeMap<String, Resource> orderedMap, Set<String> versionSet, Set<String> newVersionSet) throws IOException {
        for (Map.Entry<String, Resource> entry : orderedMap.entrySet()) {
            Resource resource = entry.getValue();
            logger.debug("resource.getUri() {}", (Object)resource.getURI());
            String path = resource.getURI().toString();
            if (path == null) continue;
            logger.debug("found Resource {}", (Object)path);
            int pos = path.lastIndexOf("/");
            String fileName = path.substring(pos + 1);
            logger.debug("fileName of migration file {}", (Object)fileName);
            Matcher m = VERSION_PATTERN.matcher(fileName);
            if (m.matches()) {
                String versionOfFile = m.group(1);
                if (versionSet.contains(versionOfFile)) {
                    logger.info("DB MIGRATION file '{} ' already migrated ", (Object)fileName);
                    continue;
                }
                try {
                    String content = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    logger.info("Content ----- \n{}\n-----", (Object)content);
                    this.createAndRunStatements(content, neo4JBaseService);
                    newVersionSet.add(versionOfFile);
                    continue;
                }
                catch (Exception e) {
                    logger.warn("Exception during migration ", (Throwable)e);
                    throw new RuntimeException(e.getMessage());
                }
            }
            logger.error("resource '{}' does not match pattern {}", (Object)resource.getURI(), (Object)VERSION_PATTERN.pattern());
        }
    }

    void createAndRunStatements(String fileContent, Neo4JBaseService neo4JBaseService) throws Exception {
        String[] lines = fileContent.split("\n");
        StringBuilder sb = new StringBuilder();
        ArrayList<String> statements = new ArrayList<String>();
        for (String line : lines) {
            int pos = line.indexOf(";");
            if (pos == -1) {
                sb.append(line);
            }
            while (pos > -1) {
                if (pos > -1) {
                    sb.append(line, 0, pos);
                    statements.add(sb.toString());
                    sb = new StringBuilder();
                    line = line.substring(pos + 1);
                } else {
                    sb.append(line);
                }
                pos = line.indexOf(";");
            }
        }
        if (!sb.isEmpty()) {
            statements.add(sb.toString());
        }
        logger.info("Statements for migration {}", statements);
        if (1 != statements.size()) {
            logger.error("More then 1 neo4j statement in migration file found , abort migration");
            throw new IllegalArgumentException("You should have only one Statement per migration file");
        }
        for (String statement : statements) {
            this.runStatementInNeo4J(statement, neo4JBaseService);
        }
    }

    private void runStatementInNeo4J(String statement, Neo4JBaseService neo4JBaseService) throws Exception {
        neo4JBaseService.runStatement(statement);
    }

    @Value(value="${neo4j-migration-folder}")
    public void setDbmigrationFolder(String dbmigrationFolder) {
        this.dbmigrationFolder = dbmigrationFolder;
    }
}

