/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.cache;

import java.util.ArrayList;
import java.util.List;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryListener;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import org.springframework.boot.autoconfigure.cache.JCacheManagerCustomizer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableCaching
public class CacheConfiguration
implements JCacheManagerCustomizer {
    public static final String CACHE_NAME_TASK_URL = "taskUrlCache";
    public static final String CACHE_NAME_REGISTRATION = "registrationCache";
    public static final String CACHE_NAME_OIDC_LTI13_LAUNCH = "ltiLauchCache";
    private final List<CacheEntryListener<String, Object>> cacheEntryListeners = new ArrayList();

    public void customize(CacheManager cacheManager) {
        if (cacheManager.getCache(CACHE_NAME_TASK_URL) == null) {
            cacheManager.createCache(CACHE_NAME_TASK_URL, (javax.cache.configuration.Configuration)this.getMutableConfig(Duration.ONE_MINUTE));
        }
        if (cacheManager.getCache(CACHE_NAME_TASK_URL) == null) {
            cacheManager.createCache(CACHE_NAME_TASK_URL, (javax.cache.configuration.Configuration)this.getMutableConfig(Duration.THIRTY_MINUTES));
        }
        if (cacheManager.getCache(CACHE_NAME_OIDC_LTI13_LAUNCH) == null) {
            cacheManager.createCache(CACHE_NAME_OIDC_LTI13_LAUNCH, (javax.cache.configuration.Configuration)this.getMutableConfig(Duration.ONE_MINUTE));
        }
    }

    private MutableConfiguration<String, Object> getMutableConfig(Duration expiryPolicyDuration) {
        MutableConfiguration configuration = new MutableConfiguration().setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)expiryPolicyDuration)).setStoreByValue(true).setStatisticsEnabled(true).setStatisticsEnabled(true);
        this.cacheEntryListeners.forEach(listener -> configuration.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)new MutableCacheEntryListenerConfiguration((Factory)new FactoryBuilder.SingletonFactory(listener), null, true, true)));
        return configuration;
    }
}

