/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.dynreg;

import de.mahlsdorf.lti13.advantage.helper.HtmlTagWriter;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class DynamicRegistrationService
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRegistrationService.class);
    private static final String URL_FORMAT = "%s?openid_configuration=%s&registration_token=%s";
    private static final String URL_FORMAT_OUR_URL_FOR_CONFIG = "%s%s%s?toolId=%s";
    private final String baseUrl;

    public DynamicRegistrationService(@Value(value="${platform.hosturi}") String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public ResponseEntity<String> initDynRegistration(String dynRegStartUrl, String toolId) {
        String ourConfigUrl = String.format(URL_FORMAT_OUR_URL_FOR_CONFIG, this.baseUrl, "platformapi/v1/lti13/", ".well-known/opendid-configuration", toolId);
        String url = String.format(URL_FORMAT, dynRegStartUrl, ourConfigUrl, toolId);
        RestTemplate restTemplate = new RestTemplate();
        StringBuilder sb1 = new StringBuilder("<Html>");
        String body = "<body onload=\"document.launchform.submit()\">";
        sb1.append("<!DOCTYPE html>").append(body);
        sb1.append("<form  action=\"" + dynRegStartUrl + "\" method=\"get\" name=\"launchform\" id=\"launchform\"> ");
        HtmlTagWriter.appendHiddenField((String)"openid_configuration", (String)ourConfigUrl, (StringBuilder)sb1);
        HtmlTagWriter.appendHiddenField((String)"toolId", (String)toolId, (StringBuilder)sb1);
        HtmlTagWriter.appendHiddenField((String)"registration_token", (String)toolId, (StringBuilder)sb1);
        sb1.append("</form>");
        sb1.append("<div style=\"align-content: center;background-color=\"light-grey\">Bitte warten Sie, Sie werden zur dynamischen Registrierung weitergeleitet</div>");
        LOG.info("result {}", (Object)sb1);
        return ResponseEntity.ok((Object)sb1.toString());
    }
}

