/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.groupservice;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.mahlsdorf.groupservice.service.neo4j.HttpGraphApiResultCleaner;
import de.mahlsdorf.lti13.exception.exception.VaadineoNeo4jException;
import jakarta.validation.constraints.NotNull;
import java.util.Base64;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DirectGraphControllerService {
    private static final Logger logger = LoggerFactory.getLogger(DirectGraphControllerService.class);
    public static final String JSON_KEY_TEACHER_ID = "teacherId";
    public static final String JSON_KEY_SCHOOL_ID = "schoolId";
    public static final String MSG_TEACHER_ID_AND_SCHOOL_ID_MUST_BE_NOT_EMPTY = "teacherId and schoolId must be not empty";
    private HttpGraphApiResultCleaner httpGraphApiResultCleaner;
    private static final String BASE_HEADER = "%s:%s";
    private String baseUrlNeo4J;
    private String neo4JUser;
    private String neo4JPassword;
    private static final String FORMAT_STATEMENT_JSON_FOR_NEO_4_J = "{ \"statements\" : [ {\n  \"statement\" : \"%s\",\n  \"resultDataContents\" : [  \"graph\" ]\n } ]\n}\n";

    public DirectGraphControllerService(HttpGraphApiResultCleaner httpGraphApiResultCleaner) {
        this.httpGraphApiResultCleaner = httpGraphApiResultCleaner;
    }

    private String getIdFromJson(String teacherIdJson, String fieldName) throws VaadineoNeo4jException {
        ObjectMapper ojbReader = new ObjectMapper();
        try {
            Map resultTeacher = (Map)ojbReader.readValue(teacherIdJson, Map.class);
            return (String)resultTeacher.get(fieldName);
        }
        catch (Exception e) {
            logger.error("cant get teacherId from GraphHtml Exception is {}", (Object)e.getMessage(), (Object)e);
            throw new VaadineoNeo4jException(e.getMessage(), "NEO4J.wrongRequest", HttpStatus.BAD_REQUEST);
        }
    }

    private String getTeacherId(String teacherIdJson) throws VaadineoNeo4jException {
        return this.getIdFromJson(teacherIdJson, "teacherId");
    }

    private String getSchoolId(String teacherIdJson) throws VaadineoNeo4jException {
        return this.getIdFromJson(teacherIdJson, "schoolId");
    }

    public ResponseEntity<String> createCypherAndSendToDB(String teacherIdJson, String cypherStatementBase) throws VaadineoNeo4jException {
        String teacherId = "";
        String schoolId = "";
        try {
            teacherId = this.getTeacherId(teacherIdJson);
            schoolId = this.getSchoolId(teacherIdJson);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
        }
        if (StringUtils.isEmpty((CharSequence)teacherId) || StringUtils.isEmpty((CharSequence)schoolId)) {
            logger.error("teacherId and schoolId must be not empty");
            throw new VaadineoNeo4jException("teacherId and schoolId must be not empty", "NEO4J.wrongResponse", HttpStatus.BAD_REQUEST);
        }
        String cypherStatement = DirectGraphControllerService.getCypherStatement((String)teacherId, (String)schoolId, (String)cypherStatementBase);
        String cypherStatementforNeo4J = String.format("{ \"statements\" : [ {\n  \"statement\" : \"%s\",\n  \"resultDataContents\" : [  \"graph\" ]\n } ]\n}\n", cypherStatement);
        if (logger.isDebugEnabled()) {
            logger.debug("Statement going to neo4j {}", (Object)cypherStatementforNeo4J);
        }
        String result = this.callNeo4JServerForGraphResult(cypherStatementforNeo4J);
        try {
            result = this.httpGraphApiResultCleaner.cleanupGraph(result);
        }
        catch (Exception e) {
            logger.error("Exception while reading result from neo4j {} ", (Object)e.getMessage(), (Object)e);
        }
        return ResponseEntity.ok((Object)result);
    }

    private static String getCypherStatement(String teacherId, String schoolId, String cypherStatementBase) {
        String cypherStatement;
        String whereClauseTeacher = " where t.teacherId='%s' ";
        String whereClauseSchool = " where n.schoolId='%s' ";
        String whereClause = "";
        if ("allTeacher".equals(teacherId)) {
            whereClause = String.format(whereClauseSchool, schoolId);
            cypherStatement = String.format(cypherStatementBase, whereClause);
        } else {
            whereClause = String.format(whereClauseTeacher, teacherId);
            cypherStatement = String.format(cypherStatementBase, whereClause);
        }
        return cypherStatement;
    }

    @NotNull
    private String callNeo4JServerForGraphResult(String cypherStatement) throws VaadineoNeo4jException {
        logger.debug("requestBody ist {}", (Object)cypherStatement);
        RestTemplate restTemplate = this.getRestTemplate();
        String graphUrl = this.baseUrlNeo4J.concat("/db/neo4j/tx/commit");
        HttpEntity request = new HttpEntity((Object)cypherStatement, (MultiValueMap)this.getHttpHeaders());
        long startTime = System.currentTimeMillis();
        try {
            String graphAsString = (String)restTemplate.postForObject(graphUrl, (Object)request, String.class, new Object[0]);
            if (logger.isDebugEnabled()) {
                logger.debug("returned Value \n{}", (Object)graphAsString);
            }
            logger.info("Call to neo4J {} for graph took {} msec", (Object)graphUrl, (Object)(System.currentTimeMillis() - startTime));
            return graphAsString;
        }
        catch (HttpClientErrorException ce) {
            logger.error("Exception {}", (Object)ce.getResponseBodyAsString());
            throw new VaadineoNeo4jException(ce.getMessage(), "NEO4J.wrongResponse", HttpStatus.valueOf((int)ce.getStatusCode().value()));
        }
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String headerValue = String.format("%s:%s", this.neo4JUser, this.neo4JPassword);
        headerValue = Base64.getEncoder().encodeToString(headerValue.getBytes());
        String auth = "Basic ".concat(headerValue);
        headers.set("Authorization", auth);
        return headers;
    }

    private RestTemplate getRestTemplate() {
        return new RestTemplate();
    }

    @Value(value="${baseUrlNeo4j}")
    public void setBaseUrlNeo4J(String baseUrlNeo4J) {
        this.baseUrlNeo4J = baseUrlNeo4J;
    }

    @Value(value="${neo4JUser}")
    public void setNeo4JUser(String neo4JUser) {
        this.neo4JUser = neo4JUser;
    }

    @Value(value="${neo4JPassword}")
    public void setNeo4JPassword(String neo4JPassword) {
        this.neo4JPassword = neo4JPassword;
    }

    public String getBaseUrlNeo4J() {
        return this.baseUrlNeo4J;
    }

    public String getNeo4JUser() {
        return this.neo4JUser;
    }

    public String getNeo4JPassword() {
        return this.neo4JPassword;
    }
}

