/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.groupservice;

import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GraphViewTemplateService {
    private static final Logger logger = LoggerFactory.getLogger(GraphViewTemplateService.class);
    private static final String MSG_KEY_VIEWNAME = "GraphViewTemplateService.";
    private Neo4JBaseService neo4JBaseService;

    private GraphViewTemplateService(@Autowired Neo4JBaseService neo4JBaseService) {
        this.neo4JBaseService = neo4JBaseService;
    }

    public String getTaskViewTemplate(String schoolId, String teacherId, Locale locale) {
        return this.getGraphTemplateAndAddTeacherList(schoolId, "/static/neoc/html/graphViewTaskTemplate.html", teacherId, locale);
    }

    public String getGroupViewTemplate(String schoolId, String teacherId, Locale locale) {
        return this.getGraphTemplateAndAddTeacherList(schoolId, "/static/neoc/html/graphViewLearningGroupTemplate.html", teacherId, locale);
    }

    private String getGraphTemplateAndAddTeacherList(String schoolId, String templateName, String userId, Locale locale) {
        I18nService i18nService = I18nService.getInstance();
        List teacherList = this.neo4JBaseService.getTeacherPerSchool(schoolId);
        logger.info("found Teacher {}", (Object)teacherList);
        Teacher loggedInTeacher = null;
        for (Teacher teacher : teacherList) {
            if (!userId.equals(teacher.getTeacherId())) continue;
            loggedInTeacher = teacher;
        }
        if (loggedInTeacher == null) {
            return "";
        }
        InputStream is = this.getClass().getResourceAsStream(templateName);
        try {
            String template = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
            StringBuilder sb = new StringBuilder();
            boolean isAdmin = loggedInTeacher.getAdmin();
            for (Teacher teacher : teacherList) {
                if (!isAdmin) {
                    if (!teacher.getTeacherId().equals(loggedInTeacher.getTeacherId())) continue;
                    this.generateTeacherOption(sb, teacher);
                    continue;
                }
                this.generateTeacherOption(sb, teacher);
            }
            if (isAdmin) {
                this.generateAllTeacherOption(locale, i18nService, sb);
            }
            template = template.replace("###teacherLabel###", i18nService.getTranslation("GraphViewTemplateService.label.selectTeacher", locale, new Object[0]));
            template = template.replace("###teacherList###", sb.toString());
            template = template.replace("###schoolId###", schoolId);
            return template;
        }
        catch (Exception e) {
            return "Exception while getting template " + e.getMessage();
        }
    }

    private void generateAllTeacherOption(Locale locale, I18nService i18nService, StringBuilder sb) {
        Teacher allTeacherOption = new Teacher();
        allTeacherOption.setTeacherId("allTeacher");
        allTeacherOption.setFirstName(i18nService.getTranslation("GraphViewTemplateService.label.allTeacher", locale, new Object[0]));
        allTeacherOption.setLastName("");
        this.generateTeacherOption(sb, allTeacherOption);
    }

    private void generateTeacherOption(StringBuilder sb, Teacher teacher) {
        sb.append("<option value=\"" + teacher.getTeacherId() + "\">" + teacher.getFirstName() + " " + teacher.getLastName() + "</option>\n");
    }
}

