/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.groupservice;

import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.School;
import de.mahlsdorf.groupservice.model.node.Subject;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.groupservice.MigrateSubjectHelper;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"migratesubjects"}, havingValue="true")
public class MigrateSubjectHelper
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(MigrateSubjectHelper.class);
    private Neo4JBaseService neo4JBaseService;
    private int sleepTime = 20000;

    public MigrateSubjectHelper(@Autowired Neo4JBaseService neo4JBaseService) {
        this.neo4JBaseService = neo4JBaseService;
    }

    public void migrateFreeTextSubject(String schoolId) throws Exception {
        List existingCoursePerSchool = this.neo4JBaseService.findCoursesBySchoolId(schoolId);
        logger.info("Existing Courses by schoolId {} courses {} ", (Object)schoolId, (Object)existingCoursePerSchool);
        List existingSubjects = this.neo4JBaseService.findSubjectsBySchoolId(schoolId);
        logger.info("Existing Subjects by schoolId {} courses {} ", (Object)schoolId, (Object)existingSubjects);
        HashMap<String, Subject> extSubjectMap = new HashMap<String, Subject>();
        for (Subject subject : existingSubjects) {
            extSubjectMap.put(subject.getSubjectName().toLowerCase(), subject);
        }
        logger.info("existing SubjectMap {}", extSubjectMap);
        for (Course course : existingCoursePerSchool) {
            logger.info("Migration of subject working on course {}", (Object)course);
            if (StringUtils.isEmpty((CharSequence)course.getSubject())) {
                logger.info("skip migration (subjectIsEmpty) of course {} ", (Object)course);
                continue;
            }
            String subjectToTest = course.getSubject().toLowerCase();
            if (extSubjectMap.containsKey(subjectToTest)) {
                logger.info("Subject already exists {} change only course", (Object)subjectToTest);
                this.setCourseWithSubjectIdAndUpdate(course, ((Subject)extSubjectMap.get(subjectToTest)).getSubjectId());
                continue;
            }
            Subject subjectToCreate = new Subject();
            subjectToCreate.setSubjectName(course.getSubject());
            subjectToCreate.setDescription("Description ".concat(course.getSubject()));
            String newUUID = UUID.randomUUID().toString();
            subjectToCreate.setSubjectId(newUUID);
            this.neo4JBaseService.createSubject(subjectToCreate, schoolId);
            extSubjectMap.put(subjectToCreate.getSubjectName().toLowerCase(), subjectToCreate);
            logger.info("Subject created {} ", (Object)subjectToCreate);
            this.setCourseWithSubjectIdAndUpdate(course, newUUID);
        }
    }

    private void setCourseWithSubjectIdAndUpdate(Course course, String extSubjectMap) throws Exception {
        course.setSubject(null);
        course.setSubjectId(extSubjectMap);
        this.neo4JBaseService.updateCourse(course);
        logger.info("course updated with new Course with subjectId   {} ", (Object)course);
    }

    void migrateAll() {
        List allSchools = this.neo4JBaseService.getAllSchools();
        String line = "#########################################################################################";
        logger.info(line);
        logger.info("migration of free subjects starts");
        logger.info(line);
        for (School school : allSchools) {
            logger.info("migrating freetext subject for school {} {} ", (Object)school.getSchoolId(), (Object)school.getName());
            try {
                this.migrateFreeTextSubject(school.getSchoolId());
            }
            catch (Exception e) {
                logger.error("Exception while migrating freetext subject for school {} {} {} ", new Object[]{school.getSchoolId(), school.getName(), e.getMessage(), e});
                logger.info(" take the next school");
            }
        }
        logger.info(line);
        logger.info("migration of free subjects has ended");
        logger.info(line);
    }

    public void afterPropertiesSet() throws Exception {
        1 r = new /* Unavailable Anonymous Inner Class!! */;
        Thread t = new Thread((Runnable)r);
        t.setName("MIGRATION");
        t.start();
    }
}

