/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.groupservice;

import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.server.VaadinService;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.model.ui.ComboShort;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RememberTeacherService
implements Serializable {
    private static final String SESSION_TEACHER_ATTR_VALUE = "teacher";
    private static RememberTeacherService INSTANCE;
    Logger logger = LoggerFactory.getLogger(RememberTeacherService.class);

    private RememberTeacherService() {
    }

    public static RememberTeacherService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RememberTeacherService();
        }
        return INSTANCE;
    }

    public void storeTeacherInSession(Teacher teacher) {
        VaadinService.getCurrentRequest().getWrappedSession().setAttribute(SESSION_TEACHER_ATTR_VALUE, (Object)teacher);
    }

    public Teacher getTeacher() {
        Object teacher = VaadinService.getCurrentRequest().getWrappedSession().getAttribute(SESSION_TEACHER_ATTR_VALUE);
        this.logger.info("found Teacher {} ", teacher);
        return (Teacher)teacher;
    }

    public ComboShort<Teacher> getTeacherComboShort() {
        Teacher teacher = this.getTeacher();
        if (teacher != null) {
            return new ComboShort((Object)teacher, teacher.getFirstName() + " " + teacher.getLastName());
        }
        return null;
    }

    public void setTeacherInComboBox(ComboBox<ComboShort<Teacher>> teacherInComboBox) {
        Teacher teacher = this.getTeacher();
        if (teacher != null) {
            ComboShort cs = new ComboShort((Object)teacher, teacher.getFirstName() + " " + teacher.getLastName());
            teacherInComboBox.setValue((Object)cs);
        }
    }
}

