/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.groupservice;

import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.validator.EmailValidator;
import com.vaadin.flow.data.validator.RegexpValidator;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StudentUploadService
implements Serializable {
    public static final String NL = "\n";
    private static final Logger logger = LoggerFactory.getLogger(StudentUploadService.class);
    private static final String MSG_KEY_SERVICENAME = "StudentUploadService.";
    private final Neo4JBaseService neo4JBaseService;
    private final I18nService i18nService;

    public StudentUploadService(@Autowired Neo4JBaseService neo4JBaseService) {
        this.neo4JBaseService = neo4JBaseService;
        this.i18nService = I18nService.getInstance();
    }

    public List<Student> convertUploadFile(InputStream inputStream, StringBuilder errorSb, Locale locale) {
        ArrayList<Student> result = new ArrayList<Student>();
        try {
            List allStudentsInSchool = this.neo4JBaseService.getAllStudents();
            TreeSet<String> existingEmails = new TreeSet<String>();
            TreeSet<String> existingLoginNames = new TreeSet<String>();
            for (Student student : allStudentsInSchool) {
                existingEmails.add(student.getEmail());
                existingLoginNames.add(student.getLoginName());
            }
            String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            content = content.replace("\r", "");
            String[] lines = content.split(NL);
            for (int i1 = 0; i1 < lines.length; ++i1) {
                lines[i1] = lines[i1].trim();
                if (this.checkForComment(lines[i1])) continue;
                this.extractAndValidateStudent(i1, locale, lines[i1], result, existingEmails, existingLoginNames, errorSb);
            }
        }
        catch (Exception e1) {
            logger.error("Exception while reading input file", (Throwable)e1);
        }
        return result;
    }

    private void extractAndValidateStudent(int i1, Locale locale, String line, List<Student> result, Set<String> existingEmails, Set<String> existingLoginNames, StringBuilder errorSb) {
        Student student = new Student();
        int lineNumber = i1 + 1;
        String[] studentArray = line.split(";");
        if (logger.isDebugEnabled()) {
            List<String> lineList = Arrays.asList(studentArray);
            logger.debug("working on StudentArray {}", lineList);
        }
        try {
            if (studentArray.length > 6) {
                String studentId = UUID.randomUUID().toString();
                student.setStudentId(studentId);
                student.setFirstName(studentArray[0].trim());
                student.setLastName(studentArray[1].trim());
                student.setComment1(studentArray[2].trim());
                student.setComment2(studentArray[3].trim());
                student.setComment3(studentArray[4].trim());
                student.setEmail(studentArray[5].trim());
                student.setLoginName(studentArray[6].trim());
                boolean hasError = this.validateStudent(existingEmails, existingLoginNames, student, errorSb, locale, lineNumber, line);
                if (!hasError) {
                    result.add(student);
                    existingEmails.add(student.getEmail());
                    existingLoginNames.add(student.getLoginName());
                }
            } else {
                logger.warn("Ignore Line '{}'", (Object)line);
                String msg = this.i18nService.getTranslation("StudentUploadService.msg.ignoreLine", locale, new Object[]{line, lineNumber});
                errorSb.append(msg + NL);
            }
        }
        catch (Exception e) {
            logger.error("Exception while work on '{}' ", (Object)line, (Object)e);
            String msg = this.i18nService.getTranslation("StudentUploadService.msg.exceptionWorkOn", locale, new Object[]{lineNumber, line, e.getMessage()});
            errorSb.append(msg + NL);
        }
    }

    private boolean checkForComment(String line) {
        if ((line = line.trim()).startsWith("#")) {
            if (logger.isDebugEnabled()) {
                logger.debug("ignore comment {}", (Object)line);
            }
            return true;
        }
        return false;
    }

    private boolean validateStudent(Set<String> existingEmails, Set<String> existingLoginNames, Student student, StringBuilder errorSb, Locale locale, int lineNumber, String line) {
        RegexpValidator regexpValidator1;
        EmailValidator emailValidator;
        ValidationResult vResult;
        String msg;
        boolean hasError = false;
        if (existingEmails.contains(student.getEmail())) {
            msg = this.i18nService.getTranslation("StudentUploadService.msg.emailExists", locale, new Object[]{student.getEmail(), lineNumber});
            errorSb.append(msg + NL);
            hasError = true;
        } else {
            existingEmails.add(student.getEmail());
        }
        if (existingLoginNames.contains(student.getLoginName())) {
            msg = this.i18nService.getTranslation("StudentUploadService.msg.loginNameExists", locale, new Object[]{student.getLoginName(), lineNumber});
            errorSb.append(msg + NL);
            hasError = true;
        } else {
            existingLoginNames.add(student.getLoginName());
        }
        if (!hasError && (vResult = (emailValidator = new EmailValidator(this.i18nService.getTranslation("StudentUploadService.msg.mustBeAEmail", locale, new Object[]{student.getEmail(), lineNumber, line}))).apply(student.getEmail(), null)).isError()) {
            errorSb.append(vResult.getErrorMessage() + NL);
            hasError = true;
        }
        if (!hasError && (vResult = (regexpValidator1 = new RegexpValidator(this.i18nService.getTranslation("StudentUploadService.msg.mustBeAEmail", locale, new Object[]{student.getEmail(), lineNumber, line}), "[\\w\\.\\d]{1,}[@]{1}[\\w\\.\\d]{1,}")).apply(student.getEmail(), null)).isError()) {
            errorSb.append(vResult.getErrorMessage() + NL);
            hasError = true;
        }
        hasError = hasError || this.validateField2Chars(student.getFirstName(), errorSb, locale, lineNumber, line, hasError);
        hasError = hasError || this.validateField2Chars(student.getLastName(), errorSb, locale, lineNumber, line, hasError);
        hasError = hasError || this.validateField2Chars(student.getLoginName(), errorSb, locale, lineNumber, line, hasError);
        return hasError;
    }

    private boolean validateField2Chars(String valueToCheck, StringBuilder errorSb, Locale locale, int lineNumber, String line, boolean hasError) {
        RegexpValidator regexpValidator = new RegexpValidator(this.i18nService.getTranslation("StudentUploadService.msg.min2Chars", locale, new Object[]{valueToCheck, lineNumber, line}), "[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc]{1,}[\\w\\\u00e4\\\u00f6\\\u00fc\\\u00c4\\\u00d6\\\u00dc\\s.]{1,}");
        ValidationResult vResult = regexpValidator.apply(valueToCheck, null);
        if (vResult.isError()) {
            errorSb.append(vResult.getErrorMessage() + NL);
            hasError = true;
        }
        return hasError;
    }

    public void saveTheStudentsFromUploadAndCreateConnection(List<Student> studentsToSave, String schoolId) {
        this.neo4JBaseService.saveStudentsFromUploadAndCreateConnection(studentsToSave, schoolId);
    }
}

