/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.groupservice;

import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Task2ToolAssignerService {
    private final Neo4JBaseService neo4JBaseService;
    Logger logger = LoggerFactory.getLogger(Task2ToolAssignerService.class);
    private static final String MSG_KEY_SERVICENAME = "Task2ToolAssignerService.";
    private final I18nService i18nService;

    public Task2ToolAssignerService(@Autowired Neo4JBaseService neo4JBaseService) {
        this.neo4JBaseService = neo4JBaseService;
        this.i18nService = I18nService.getInstance();
    }

    public void assignTasksToToolId(List<Task> tasks, String schoolId, StringBuilder errorSb, Locale locale) {
        List toolsPerSchoolList = this.neo4JBaseService.getToolsForSchool(schoolId);
        TreeMap<String, String> toolUrlToToolIdMap = new TreeMap<String, String>();
        for (Tool tool : toolsPerSchoolList) {
            toolUrlToToolIdMap.put(tool.getToolUrl(), tool.getToolId());
        }
        TreeMap<Integer, String> assignMap = new TreeMap<Integer, String>();
        for (Task task : tasks) {
            if ("headline".equals(task.getType())) continue;
            String launchUrl = task.getUrl();
            for (Map.Entry toolEntry : toolUrlToToolIdMap.entrySet()) {
                String toolUrl = (String)toolEntry.getKey();
                String toolId = (String)toolEntry.getValue();
                if (!launchUrl.startsWith(toolUrl)) continue;
                assignMap.put(((String)toolEntry.getKey()).length(), toolId);
            }
            if (assignMap.isEmpty()) {
                String message = this.i18nService.getTranslation("Task2ToolAssignerService.msg.toolNotFound", locale, new Object[]{task.getName(), launchUrl}) + "\n";
                errorSb.append(message);
                continue;
            }
            String toolId = "";
            for (Map.Entry entry : assignMap.entrySet()) {
                toolId = (String)entry.getValue();
            }
            task.setToolId(toolId);
            this.logger.info("found ToolId {} for Task {} ", (Object)toolId, (Object)task);
            assignMap.clear();
        }
    }
}

