/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.groupservice;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class TaskIconUrlChecker {
    private final Logger LOG = LoggerFactory.getLogger(TaskIconUrlChecker.class);

    @Cacheable(value={"taskUrlCache"}, key="#url")
    public String getTaskUrl(String url) {
        RestTemplate restTemplate = new RestTemplate();
        if (url.startsWith("/neoc/")) {
            return url;
        }
        try {
            restTemplate.headForHeaders(url, new Object[0]);
            return url;
        }
        catch (Exception e) {
            this.LOG.info("Check TaskUrl Exception {}", (Object)e.getMessage());
            return "/neoc/images/URL_LTI.png";
        }
    }
}

