/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.lti13;

import com.google.gson.Gson;
import de.mahlsdorf.groupservice.model.CreateDeleteCounter;
import de.mahlsdorf.groupservice.model.lti13.oidclogin.OidcLaunchCacheDataDTO;
import de.mahlsdorf.groupservice.model.lti13.oidclogin.OidcLaunchTypeEnum;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.lti13.Lti13OidcHelper;
import de.mahlsdorf.groupservice.service.neo4j.Neo4JStudentToTaskService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.lti13.advantage.helper.HtmlTagWriter;
import de.mahlsdorf.lti13.advantage.internalmodel.launch.CourseInfo;
import de.mahlsdorf.lti13.advantage.internalmodel.launch.LaunchInfo;
import de.mahlsdorf.lti13.advantage.service.JwtEncoderDecoder;
import de.mahlsdorf.lti13.advantage.service.ltirequest.LtiLaunchService;
import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import de.mahlsdorf.lti13.lti13models.model.Lti13JwtModel;
import de.mahlsdorf.lti13.lti13models.model.lti.deeplink.Lti13DeepLinkResponse;
import de.mahlsdorf.lti13.lti13models.model.lti.deeplink.contentitems.Lti13DeepLinkRessourceLinkContentItem;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LaunchDeepLinkService
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(LaunchDeepLinkService.class);
    public static final String MSG_KEY_SERVICE_NAME = "LaunchDeepLinkService.";
    private final Neo4JBaseService neo4JBaseService;
    private LtiLaunchService ltiLaunchService;
    private String platformBaseUrl;
    private Neo4JStudentToTaskService neo4JStudentToTaskService;
    private JwtEncoderDecoder jwtEncoderDecoder;
    private final I18nService i18nService;
    private final CacheManager cacheManager;
    private final Lti13OidcHelper lti13OidcHelper;
    private static final String NL = "\n";

    public LaunchDeepLinkService(@Autowired CacheManager cacheManager, @Autowired Lti13OidcHelper lti13OidcHelper, @Autowired Neo4JBaseService neo4JBaseService, @Autowired Neo4JStudentToTaskService neo4JStudentToTaskService) {
        this.neo4JBaseService = neo4JBaseService;
        this.i18nService = I18nService.getInstance();
        this.cacheManager = cacheManager;
        this.lti13OidcHelper = lti13OidcHelper;
        this.neo4JStudentToTaskService = neo4JStudentToTaskService;
    }

    private Locale getLocale(Lti13DeepLinkResponse deeplinkingResponse) {
        if (!StringUtils.isEmpty((CharSequence)deeplinkingResponse.getLocale())) {
            try {
                return new Locale(deeplinkingResponse.getLocale());
            }
            catch (Exception e) {
                logger.warn("Exception while getting locale from deeplinking Response, take system default locale", (Throwable)e);
            }
        }
        return Locale.getDefault();
    }

    public String insertDeepLinkingResponse(MultiValueMap<String, String> formData, String toolId, String courseId) {
        Gson gson = new Gson();
        try {
            String jwt = (String)formData.getFirst((Object)"JWT");
            if (StringUtils.isEmpty((CharSequence)jwt)) {
                throw new ApiLti13Exception("parameter jwt mut be not null or empty ", "dd", HttpStatus.BAD_REQUEST);
            }
            logger.info("deeplinkResposeJWT is \n{}", (Object)jwt);
            Tool tool = (Tool)this.neo4JBaseService.getToolsById(toolId).get(0);
            Course course = this.neo4JBaseService.findCourseById(courseId);
            Lti13JwtModel model = this.jwtEncoderDecoder.decodeLTILauchLink(jwt, tool.getToolId());
            logger.info("model {}", (Object)model);
            logger.info("get ContentItems from DeeplinkResponse ");
            String[] parts = jwt.split("\\.");
            String json = new String(Base64.getUrlDecoder().decode(parts[1].getBytes(StandardCharsets.UTF_8)));
            Lti13DeepLinkResponse deepLinkResponse = (Lti13DeepLinkResponse)gson.fromJson(json, Lti13DeepLinkResponse.class);
            List contentItems = deepLinkResponse.getLtiContentItems();
            this.getLocale(deepLinkResponse);
            return this.insertContentsItemIntoCourse(contentItems, course, toolId, Locale.ENGLISH);
        }
        catch (Exception e) {
            logger.error("Exception while decode DeeplinkResponse ", (Throwable)e);
            return "Exception :" + e.getMessage();
        }
    }

    private String insertContentsItemIntoCourse(List<Lti13DeepLinkRessourceLinkContentItem> contentItems, Course course, String toolId, Locale locale) {
        int count = 9000;
        StringBuilder sb = new StringBuilder();
        HtmlTagWriter.createHeadWithBootstrap((StringBuilder)sb);
        sb.append(" <div class=\"card\" style=\"width: 80%; text-align: center;\">\n  <div class=\"card-body\">\n");
        sb.append("<pre>");
        List studentInCourseList = this.neo4JBaseService.getStudentForCourseViaLearningGroup(course.getCourseId());
        for (Lti13DeepLinkRessourceLinkContentItem item : contentItems) {
            Task task = new Task();
            try {
                task.setType("LTI-1.3");
                task.setUrl(item.getUrl());
                task.setName(item.getTitle());
                task.setStructure(String.format("%04d", count));
                task.setToolId(toolId);
                task.setDescription(item.getTitle() + " from LTI ");
                LaunchDeepLinkService.setLineItemIfExists((Lti13DeepLinkRessourceLinkContentItem)item, (Task)task);
                logger.error(" ?resourceLinkId LtiLinkId ");
                task.setLtiResourceLinkId(item.getLineItem().getResourceId());
                task.setLtiLtiLinkId(item.getLineItem().getResourceId());
                Gson gson = new Gson();
                task.setLtiCustomParams(gson.toJson(item.getCustom() == null ? new HashMap() : item.getCustom()));
                LaunchDeepLinkService.setImagesIfExisting((Lti13DeepLinkRessourceLinkContentItem)item, (Task)task);
                this.neo4JBaseService.createTaskAndRelation(task, course.getCourseId());
                ++count;
                if (logger.isInfoEnabled()) {
                    logger.info("Deeplinkresponse Task {} inserted  in course {} ", (Object)task.getName(), (Object)course.getName());
                    logger.info("assign all Students begins");
                }
                long startTime = System.currentTimeMillis();
                HashSet studentSet = new HashSet(studentInCourseList);
                CreateDeleteCounter counter = this.neo4JStudentToTaskService.updateTaskToStudentConnections(task, studentSet, new CreateDeleteCounter());
                String message = this.i18nService.getTranslation("LaunchDeepLinkService.msg.studentsAssigned", locale, new Object[]{task.getName(), counter.getCreated()});
                sb.append(message).append("\n");
                logger.info("Einf\u00fcgen Task / Assign Task (LTI Deeplink) took {} msec", (Object)(System.currentTimeMillis() - startTime));
                logger.info("assign all Students end");
            }
            catch (Exception e) {
                logger.error("exception while inserting Task from DeeplinkResponse ContentItem {} ", (Object)item, (Object)e);
                String message = this.i18nService.getTranslation("LaunchDeepLinkService.msg.exceptionStudentsAssigned", locale, new Object[]{task.getName(), e.getMessage()});
                sb.append(message);
            }
        }
        sb.append("</pre>");
        String buttonText = I18nService.getInstance().getTranslation("LaunchDeepLinkService.button.back", locale, new Object[0]);
        HtmlTagWriter.appendReturnButtonAsPrimary((String)buttonText, (String)buttonText, (StringBuilder)sb);
        sb.append("  </div> <!-- card-body -->\n</div><!-- card -->\n");
        HtmlTagWriter.createCloseBody((StringBuilder)sb);
        return sb.toString();
    }

    private static void setImagesIfExisting(Lti13DeepLinkRessourceLinkContentItem item, Task task) {
        String image = "/neoc/images/test.png";
        if (item.getThumbnail() != null) {
            task.setLtiThumbnailUrl(item.getThumbnail().getUrl() == null ? image : item.getThumbnail().getUrl());
        } else {
            task.setLtiThumbnailUrl(image);
        }
        if (item.getIcon() != null) {
            task.setLtiIconUrl(item.getIcon().getUrl() == null ? image : item.getIcon().getUrl());
        } else {
            task.setLtiIconUrl(image);
        }
    }

    private static void setLineItemIfExists(Lti13DeepLinkRessourceLinkContentItem item, Task task) {
        if (item.getLineItem() != null) {
            task.setLtiLineItemMaxPoints(item.getLineItem().getScoreMaximum());
            task.setLtiLiLineItemTag(item.getLineItem().getTag() == null ? "-" : item.getLineItem().getTag());
            task.setLtiLiResourceId(item.getLineItem().getResourceId() == null ? "-" : item.getLineItem().getResourceId());
        } else {
            logger.info("no line item transmitted ");
            task.setLtiLineItemMaxPoints(Double.valueOf(0.0));
            task.setLtiLiLineItemTag("");
            task.setLtiLiResourceId("");
        }
    }

    public String launchDeeplinking(String toolId, String teacherId, String courseId, HttpServletRequest request, HttpServletResponse response, Locale locale, boolean isOidcStart) {
        if (StringUtils.isEmpty((CharSequence)toolId)) {
            return I18nService.getInstance().getTranslation("LaunchDeepLinkService.msg.selectTool", locale, new Object[0]);
        }
        Tool tool = (Tool)this.neo4JBaseService.getToolsById(toolId).get(0);
        logger.info("get Tool {}", (Object)tool);
        Teacher teacher = this.neo4JBaseService.findTeacherById(teacherId);
        Course course = this.neo4JBaseService.findCourseById(courseId);
        return this.launchDeeplinking(tool, teacher, course, request, response, locale, isOidcStart);
    }

    public String launchDeeplinking(Tool tool, Teacher teacher, Course course, HttpServletRequest request, HttpServletResponse response, Locale locale, boolean isOidcStart) {
        String oidcState = request.getParameter("state");
        String nonce = request.getParameter("nonce");
        String aud = request.getParameter("client_id");
        if (!StringUtils.isEmpty((CharSequence)tool.getLoginInitUrl()) && isOidcStart) {
            return this.startOidcLogin(tool, teacher, course);
        }
        StringBuilder sb = new StringBuilder();
        LaunchInfo launchInfo = new LaunchInfo();
        launchInfo.setTool(tool);
        String redirectUrl = request.getParameter("redirect_uri");
        launchInfo.setLaunchUri(redirectUrl);
        launchInfo.setUserId(teacher.getTeacherId());
        String returnUrl = this.getDeeplinkReturnUrl(tool, course);
        launchInfo.setReturnUrl(returnUrl);
        launchInfo.setTargetLinkUri(tool.getDeeplinkUrl());
        CourseInfo courseInfo = new CourseInfo();
        courseInfo.setId(course.getCourseId());
        courseInfo.setLongName(course.getName());
        launchInfo.setCourseInfo(courseInfo);
        launchInfo.setOidcState(oidcState);
        launchInfo.setNonce(nonce);
        launchInfo.setAud(aud);
        try {
            ResponseEntity content = this.ltiLaunchService.createDeepLinkingLaunchRequest(launchInfo, locale);
            String locationHeader = response.getHeader("Location");
            if (StringUtils.isEmpty((CharSequence)locationHeader)) {
                return (String)content.getBody();
            }
            logger.error("");
        }
        catch (Exception e) {
            logger.error("Exception while creating Lti LaunchRequest ", (Throwable)e);
            sb = new StringBuilder();
            sb.append("Exception:");
            sb.append(e.getMessage());
        }
        return sb.toString();
    }

    public String getDeeplinkReturnUrl(Tool tool, Course course) {
        return this.platformBaseUrl + "platformapi/v1/lti13/deepLinkingResponse/" + tool.getToolId() + "/" + course.getCourseId() + "/";
    }

    private void writeDataToCache(Tool tool, Teacher teacher, Course course, String loginMessageHint) {
        OidcLaunchCacheDataDTO oidcLaunchCacheDataDTO = this.lti13OidcHelper.getValueFromCache(loginMessageHint);
        oidcLaunchCacheDataDTO.setTool(tool);
        oidcLaunchCacheDataDTO.setTeacher(teacher);
        oidcLaunchCacheDataDTO.setCourse(course);
        oidcLaunchCacheDataDTO.setLauchType(OidcLaunchTypeEnum.LTI_DEEP_LINK_LAUNCH);
        this.cacheManager.getCache("ltiLauchCache").put((Object)loginMessageHint, (Object)oidcLaunchCacheDataDTO);
        if (logger.isDebugEnabled()) {
            logger.debug("OIDC Login write lauchData from Lti_message_hint {} to cache ", (Object)loginMessageHint);
        }
    }

    private String startOidcLogin(Tool tool, Teacher teacher, Course course) {
        OidcLaunchCacheDataDTO oidcLaunchCacheDataDTO = new OidcLaunchCacheDataDTO();
        oidcLaunchCacheDataDTO.setTool(tool);
        oidcLaunchCacheDataDTO.setTeacher(teacher);
        oidcLaunchCacheDataDTO.setCourse(course);
        oidcLaunchCacheDataDTO.setLauchType(OidcLaunchTypeEnum.LTI_DEEP_LINK_LAUNCH);
        oidcLaunchCacheDataDTO.setTargetLinkUri(tool.getDeeplinkUrl());
        return this.lti13OidcHelper.startOidcLogin(oidcLaunchCacheDataDTO);
    }

    public String returnHtml() {
        String meta = " <script type=\"text/javascript\">\n window.close()\n</script>";
        return "<html><head>" + meta + "</head><body></body></html>";
    }

    @Autowired
    public void setLtiLaunchService(LtiLaunchService ltiLaunchService) {
        this.ltiLaunchService = ltiLaunchService;
    }

    @Autowired
    public void setJwtEncoderDecoder(JwtEncoderDecoder jwtEncoderDecoder) {
        this.jwtEncoderDecoder = jwtEncoderDecoder;
    }

    @Value(value="${platform.hosturi}")
    public void setPlatformBaseUrl(String platformBaseUrl) {
        this.platformBaseUrl = platformBaseUrl;
    }
}

