/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.lti13;

import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.lti13.oidclogin.OidcLaunchCacheDataDTO;
import de.mahlsdorf.groupservice.model.lti13.oidclogin.OidcLaunchTypeEnum;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.lti13.Lti13OidcHelper;
import de.mahlsdorf.lti13.advantage.internalmodel.launch.CourseInfo;
import de.mahlsdorf.lti13.advantage.internalmodel.launch.LaunchInfo;
import de.mahlsdorf.lti13.advantage.service.ltirequest.LtiLaunchService;
import de.mahlsdorf.lti13.lti13models.model.lti.grades.Lti13Score;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LaunchService
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(LaunchService.class);
    private final Neo4JBaseService neo4JBaseService;
    private LtiLaunchService ltiLaunchService;
    private final Lti13OidcHelper lti13OidcHelper;

    public LaunchService(@Autowired Neo4JBaseService neo4JBaseService, @Autowired Lti13OidcHelper lti13OidcHelper) {
        this.neo4JBaseService = neo4JBaseService;
        this.lti13OidcHelper = lti13OidcHelper;
    }

    public static LaunchInfo getLaunchInfo(String userId, boolean isTeacher, Task task, Tool tool, Course course, HttpServletRequest request) {
        LaunchInfo launchInfo = new LaunchInfo();
        launchInfo.setLaunchUri(task.getUrl());
        launchInfo.setTask(task);
        launchInfo.setUserId(userId);
        launchInfo.getRoles().add("Learner");
        launchInfo.setTool(tool);
        CourseInfo courseInfo = new CourseInfo();
        courseInfo.setId(course.getCourseId());
        courseInfo.setLongName(course.getName());
        launchInfo.setCourseInfo(courseInfo);
        launchInfo.setTeacher(isTeacher);
        launchInfo.setNonce(request.getParameter("nonce"));
        launchInfo.setAud(tool.getClientId());
        launchInfo.setOidcState(request.getParameter("state"));
        return launchInfo;
    }

    public String launch(String taskId, String userId, boolean isTeacher, boolean oidcDone, HttpServletRequest request) {
        Task task = this.neo4JBaseService.getTaskById(taskId);
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head>");
        if (!"url".equalsIgnoreCase(task.getType())) {
            if ("LTI-1.3".equalsIgnoreCase(task.getType())) {
                Tool tool = (Tool)this.neo4JBaseService.getToolsById(task.getToolId()).get(0);
                logger.info("try to start LTI Launch for Task Name  {}  id {} ", (Object)task.getName(), (Object)task.getTaskId());
                Course course = (Course)this.neo4JBaseService.getCourseByTask(taskId).get(0);
                if (!StringUtils.isEmpty((CharSequence)tool.getLoginInitUrl()) && !oidcDone) {
                    OidcLaunchCacheDataDTO oidcLaunchCacheDataDTO = new OidcLaunchCacheDataDTO();
                    oidcLaunchCacheDataDTO.setUserId(userId);
                    oidcLaunchCacheDataDTO.setTeacher(isTeacher);
                    oidcLaunchCacheDataDTO.setTask(task);
                    oidcLaunchCacheDataDTO.setTool(tool);
                    oidcLaunchCacheDataDTO.setCourse(course);
                    oidcLaunchCacheDataDTO.setLauchType(OidcLaunchTypeEnum.LTI_LAUNCH);
                    String targetLinkUri = task.getUrl();
                    oidcLaunchCacheDataDTO.setTargetLinkUri(targetLinkUri);
                    return this.lti13OidcHelper.startOidcLogin(oidcLaunchCacheDataDTO);
                }
                return this.createLti13Launch(userId, isTeacher, task, tool, course, request);
            }
            return "unkown TaskType '" + task.getType() + "'";
        }
        String meta = "<script type=\"text/javascript\">\n    window.location.href = \"" + task.getUrl() + "\";\n</script>\n";
        sb.append(meta);
        sb.append("</head><body>");
        sb.append("</body></html>");
        Lti13Score ltiScore = new Lti13Score();
        ltiScore.setScoreGiven(Float.valueOf(0.0f));
        ltiScore.setComment("called");
        ltiScore.setTimestamp(ConstantsNeoc.INTERNET_TIME_FORMAT.format(new Date()));
        this.neo4JBaseService.createTaskResult(task, userId, ltiScore);
        return sb.toString();
    }

    public String createLti13Launch(String userId, boolean isTeacher, Task task, Tool tool, Course course, HttpServletRequest request) {
        LaunchInfo launchInfo = LaunchService.getLaunchInfo((String)userId, (boolean)isTeacher, (Task)task, (Tool)tool, (Course)course, (HttpServletRequest)request);
        try {
            ResponseEntity content = this.ltiLaunchService.createLtiLaunchRequest(launchInfo, request);
            if (content.getStatusCode().is2xxSuccessful()) {
                return (String)content.getBody();
            }
            return "Not Successful StatusCode " + content.getStatusCode() + "<br/> " + (String)content.getBody();
        }
        catch (Exception e) {
            logger.error("Exception while creating Lti LaunchRequest ", (Throwable)e);
            return "Exception ";
        }
    }

    public String returnHtml() {
        String meta = "<script type=\"text/javascript\">\n        window.close()\n       </script>\n";
        return "<html><head>".concat(meta).concat("</head><body></body></html>");
    }

    @Autowired
    public void setLtiLaunchService(LtiLaunchService ltiLaunchService) {
        this.ltiLaunchService = ltiLaunchService;
    }
}

