/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.lti13;

import de.mahlsdorf.groupservice.model.lti13.oidclogin.OIDCInitLoginDTO;
import de.mahlsdorf.groupservice.model.lti13.oidclogin.OidcLaunchCacheDataDTO;
import de.mahlsdorf.lti13.advantage.helper.HtmlTagWriter;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.stereotype.Service;

@Service
public class Lti13OidcHelper {
    public static final String PARAMETER_USERID = "userId";
    public static final String PARAMETER_IS_TEACHER = "isTeacher";
    public static final String PARAMETER_TASK = "task";
    public static final String PARAMETER_TOOL = "tool";
    public static final String PARAMETER_COURSE = "course";
    public static final String PARAMETER_LOGIN_MESSAGE_HINT = "login_message_hint";
    private static final Logger logger = LoggerFactory.getLogger(Lti13OidcHelper.class);
    private final CacheManager cacheManager;
    private final String baseUrl;

    public Lti13OidcHelper(@Autowired CacheManager cacheManager, @Value(value="${platform.hosturi}") String baseUrl) {
        this.cacheManager = cacheManager;
        this.baseUrl = baseUrl;
    }

    public OidcLaunchCacheDataDTO getValueFromCache(String loginMessageHint) {
        SimpleValueWrapper wrapper = (SimpleValueWrapper)this.cacheManager.getCache("ltiLauchCache").get((Object)loginMessageHint);
        if (wrapper == null) {
            OidcLaunchCacheDataDTO result = new OidcLaunchCacheDataDTO();
            this.cacheManager.getCache("ltiLauchCache").put((Object)loginMessageHint, (Object)result);
            return result;
        }
        return (OidcLaunchCacheDataDTO)wrapper.get();
    }

    public String startOidcLogin(OidcLaunchCacheDataDTO oidcLaunchCacheDataDTO) {
        OIDCInitLoginDTO oidcInitLoginDTO = new OIDCInitLoginDTO();
        oidcInitLoginDTO.setIss(this.baseUrl);
        oidcInitLoginDTO.setLoginHint("loginHint" + UUID.randomUUID());
        oidcInitLoginDTO.setTargetLinkUri(oidcLaunchCacheDataDTO.getTargetLinkUri());
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head>");
        String meta = "<script type=\"text/javascript\">\n    </script>\n";
        sb.append(meta);
        sb.append("</head><body onload=\"document.launchform.submit()\">");
        sb.append("<form action=").append(oidcLaunchCacheDataDTO.getTool().getLoginInitUrl()).append(" method=\"post\" name=\"launchform\">");
        HtmlTagWriter.appendHiddenField((String)"iss", (String)oidcInitLoginDTO.getIss(), (StringBuilder)sb);
        HtmlTagWriter.appendHiddenField((String)"login_hint", (String)oidcInitLoginDTO.getLoginHint(), (StringBuilder)sb);
        HtmlTagWriter.appendHiddenField((String)"target_link_uri", (String)oidcInitLoginDTO.getTargetLinkUri(), (StringBuilder)sb);
        HtmlTagWriter.appendHiddenField((String)"lti_message_hint", (String)oidcInitLoginDTO.getLoginHint(), (StringBuilder)sb);
        HtmlTagWriter.appendPrimarySubmitButton((String)"button", (String)"value", (StringBuilder)sb);
        sb.append("</form>");
        sb.append("<div>goto OIDC Login</div>");
        sb.append("</body></html>");
        this.writeDataToCache(oidcLaunchCacheDataDTO, oidcInitLoginDTO.getLoginHint());
        if (logger.isDebugEnabled()) {
            logger.debug("result {}", (Object)sb);
        }
        return sb.toString();
    }

    private void writeDataToCache(OidcLaunchCacheDataDTO oidcLaunchCacheDataDTO, String loginMessageHint) {
        this.cacheManager.getCache("ltiLauchCache").put((Object)loginMessageHint, (Object)oidcLaunchCacheDataDTO);
        if (logger.isDebugEnabled()) {
            logger.debug("OIDC Login write lauchData from Lti_message_hint {} to cache ", (Object)loginMessageHint);
        }
    }
}

