/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.lti13;

import de.mahlsdorf.groupservice.model.CreateDeleteCounter;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.neo4j.Neo4JStudentToTaskService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TccConverterService {
    private static final Logger logger = LoggerFactory.getLogger(TccConverterService.class);
    private static final String MSG_KEY_SERVICENAME = "TccConverterService.";
    public static final String ITEM_TAG = "item";
    public static final String TITLE_TAG = "title";
    public static final String RESOURCE_TAG = "resource";
    public static final String FILE_TAG = "file";
    public static final String ATTR_IDENTIFIERREF = "identifierref";
    public static final String ATTR_IDENTIFIER = "identifier";
    public static final String IMS_MANIFEST_NAME = "imsmanifest.xml";
    private static final String JAVA_TMP_DIR = "java.io.tmpdir";
    private static final String TAG_LINK_TITLE = "title";
    private static final String TAG_LINK_DESCRIPTION = "description";
    private static final String TAG_LINK_SECURE_ITEM = "secure_icon";
    private static final String TAG_LINK_SECURE_LAUNCH_URL = "secure_launch_url";
    private final I18nService i18nService = I18nService.getInstance();
    private Neo4JBaseService neo4JBaseService;
    private Neo4JStudentToTaskService neo4JStudentToTaskService;

    private static boolean hasCharacters(XMLEvent nextEvent) {
        try {
            nextEvent.asCharacters();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public TccConverterService(@Autowired Neo4JBaseService neo4JBaseService, @Autowired Neo4JStudentToTaskService neo4JStudentToTaskService) {
        this.neo4JBaseService = neo4JBaseService;
        this.neo4JStudentToTaskService = neo4JStudentToTaskService;
    }

    public List<Task> readTccAndExtractTask(InputStream inputStream) throws IOException {
        Long startTime = System.currentTimeMillis();
        String dirName = FilenameUtils.concat((String)System.getProperty("java.io.tmpdir"), (String)"LTI");
        dirName = FilenameUtils.concat((String)dirName, (String)startTime.toString());
        try {
            this.writeZipArchiveToTempDir(inputStream, dirName);
            List list = this.parseImsManifest(dirName);
            return list;
        }
        catch (Exception e) {
            logger.error("Error while Reading TCC File", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        finally {
            try {
                FileUtils.forceDelete((File)new File(dirName));
                logger.info("Success deleting Temp Directory {}", (Object)dirName);
            }
            catch (IOException e) {
                logger.error("Exception while deleting Temp Directory ", (Throwable)e);
                throw new IOException(e.getMessage());
            }
        }
    }

    private List<Task> parseImsManifest(String dirName) throws IOException {
        String fileNameManifest = FilenameUtils.concat((String)dirName, (String)"imsmanifest.xml");
        File manifest = new File(fileNameManifest);
        if (!manifest.exists() || !manifest.canRead()) {
            throw new IOException("cant read imsmanifest " + manifest.getCanonicalPath());
        }
        try {
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            XMLEventReader reader = xmlInputFactory.createXMLEventReader(new FileInputStream(fileNameManifest));
            return this.readManifest(reader, dirName);
        }
        catch (Exception e) {
            logger.error("Exception while Parse imsmanifest ", (Throwable)e);
            throw new IOException("Exceeption while parse imsmanifest.xml " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Task> readManifest(XMLEventReader reader, String dirName) throws Exception {
        Task task = null;
        LinkedHashMap<String, Task> taskMap = new LinkedHashMap<String, Task>();
        Attribute fileIdentifier = null;
        int counter = 0;
        int headlineCounter = 0;
        try {
            while (reader.hasNext()) {
                EndElement endElement;
                XMLEvent nextEvent = reader.nextEvent();
                logger.trace("" + nextEvent);
                if (nextEvent.isStartElement()) {
                    StartElement startElement = nextEvent.asStartElement();
                    String tag = startElement.getName().getLocalPart();
                    logger.debug("Working on Tag {}", (Object)tag);
                    switch (tag) {
                        case "item": {
                            Attribute ident = startElement.getAttributeByName(new QName("identifier"));
                            Attribute taskIdentRef = startElement.getAttributeByName(new QName("identifierref"));
                            if (taskIdentRef == null) {
                                task = new Task();
                                task.setTaskId(UUID.randomUUID().toString());
                                task.setType("headline");
                                taskMap.put(String.format("%05d", headlineCounter), task);
                                ++headlineCounter;
                                break;
                            }
                            task = new Task();
                            String uuid = UUID.randomUUID().toString();
                            task.setType("LTI-1.3");
                            logger.trace("found identRef {}", (Object)taskIdentRef);
                            task.setIdentifierRef(taskIdentRef.getValue());
                            task.setTaskId(taskIdentRef.getValue());
                            task.setLtiLineItemMaxPoints(Double.valueOf(100.0));
                            task.setTaskId(uuid);
                            task.setLtiLiResourceId(uuid);
                            task.setLtiLiLineItemTag(uuid);
                            task.setLtiLtiLinkId(uuid);
                            taskMap.put(taskIdentRef.getValue(), task);
                            break;
                        }
                        case "title": {
                            nextEvent = reader.nextEvent();
                            if (!TccConverterService.hasCharacters((XMLEvent)nextEvent) || task == null) break;
                            task.setName(nextEvent.asCharacters().getData());
                            logger.trace("found Task Title {} ", (Object)task.getName());
                            break;
                        }
                        case "resource": {
                            fileIdentifier = startElement.getAttributeByName(new QName("identifier"));
                            if (fileIdentifier == null) break;
                            logger.trace("found FileIdentifier {}", (Object)fileIdentifier.getValue());
                            break;
                        }
                        case "file": {
                            if (fileIdentifier != null) {
                                Task taskToWorkOn = (Task)taskMap.get(fileIdentifier.getValue());
                                Attribute fileAttr = startElement.getAttributeByName(new QName("href"));
                                if (fileAttr != null) {
                                    this.getLinkData(taskToWorkOn, dirName, fileAttr.getValue(), counter += 100);
                                }
                            }
                        }
                        default: {
                            logger.trace("StartElement {}", (Object)startElement.getName().getLocalPart());
                        }
                    }
                }
                if (nextEvent.isEndElement() && !(endElement = nextEvent.asEndElement()).getName().getLocalPart().equals("item")) continue;
            }
        }
        finally {
            reader.close();
            logger.debug("XML Reader imsmanifest closed");
        }
        ArrayList<Task> resultList = new ArrayList<Task>(taskMap.values());
        int count = 0;
        for (Task task1 : resultList) {
            task1.setStructure(String.format("%05d", count));
            ++count;
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLinkData(@NotNull Task task, @NotEmpty String dirName, @NotEmpty String href, int counter) throws Exception {
        String fileName = FilenameUtils.concat((String)dirName, (String)href);
        logger.debug("Task {} with href {} and fileName {} ", new Object[]{task.getDescription(), href, fileName});
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader reader = xmlInputFactory.createXMLEventReader(new FileInputStream(fileName));
        try {
            while (reader.hasNext()) {
                XMLEvent nextEvent = reader.nextEvent();
                if (logger.isDebugEnabled()) {
                    logger.debug("" + nextEvent);
                }
                if (nextEvent.isStartElement()) {
                    String tag;
                    StartElement startElement = nextEvent.asStartElement();
                    if (logger.isTraceEnabled()) {
                        logger.trace("Working on Tag {}", (Object)startElement.getName().getLocalPart());
                    }
                    switch (tag = startElement.getName().getLocalPart()) {
                        case "title": {
                            nextEvent = reader.nextEvent();
                            if (!TccConverterService.hasCharacters((XMLEvent)nextEvent)) break;
                            task.setName(this.getTagValueAsString(tag, nextEvent));
                            break;
                        }
                        case "description": {
                            nextEvent = reader.nextEvent();
                            if (!TccConverterService.hasCharacters((XMLEvent)nextEvent)) break;
                            task.setDescription(this.getTagValueAsString(tag, nextEvent));
                            break;
                        }
                        case "secure_launch_url": {
                            nextEvent = reader.nextEvent();
                            if (!TccConverterService.hasCharacters((XMLEvent)nextEvent)) break;
                            String url = this.getTagValueAsString(tag, nextEvent);
                            url = url.replaceAll("\n", "");
                            url = url.trim();
                            task.setUrl(url);
                            break;
                        }
                        case "secure_icon": {
                            nextEvent = reader.nextEvent();
                            if (!TccConverterService.hasCharacters((XMLEvent)nextEvent)) break;
                            String iconUrl = this.getTagValueAsString(tag, nextEvent);
                            task.setLtiIconUrl(iconUrl);
                            task.setLtiThumbnailUrl(iconUrl);
                            break;
                        }
                        default: {
                            if (!logger.isTraceEnabled()) break;
                            logger.trace("StartElement {}", (Object)startElement.getName().getLocalPart());
                        }
                    }
                }
                if (!nextEvent.isEndElement() || !logger.isTraceEnabled()) continue;
                logger.trace("endTag {}", (Object)nextEvent.asEndElement().getName().getLocalPart());
            }
        }
        catch (Throwable throwable) {
            reader.close();
            task.setStructure(String.format("%06d", counter));
            if (logger.isDebugEnabled()) {
                logger.debug("XML Reader LTI Link closed");
            }
            throw throwable;
        }
        reader.close();
        task.setStructure(String.format("%06d", counter));
        if (logger.isDebugEnabled()) {
            logger.debug("XML Reader LTI Link closed");
        }
    }

    private String getTagValueAsString(String tag, XMLEvent nextEvent) {
        String value = nextEvent.asCharacters().getData();
        if (logger.isDebugEnabled()) {
            logger.info("found for tag {} characters  {} ", (Object)tag, (Object)value);
        }
        return value;
    }

    private void writeZipArchiveToTempDir(InputStream inputStream, String dirName) throws IOException, IllegalAccessException {
        File tempDir = new File(dirName);
        tempDir.mkdirs();
        ZipArchiveInputStream giz = new ZipArchiveInputStream(inputStream);
        boolean hasMoreEntries = true;
        while (hasMoreEntries) {
            ZipArchiveEntry zipEntry = giz.getNextZipEntry();
            if (zipEntry != null) {
                File entryDestination;
                if (logger.isTraceEnabled()) {
                    logger.trace("Entry " + zipEntry.getName());
                }
                if (!(entryDestination = new File(dirName, zipEntry.getName())).getCanonicalPath().startsWith(tempDir.getCanonicalPath() + File.separator)) {
                    throw new IllegalAccessException("Entry is outside of the target dir: " + zipEntry.getName());
                }
                if (zipEntry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(entryDestination);
                try {
                    IOUtils.copy((InputStream)giz, (OutputStream)out);
                    continue;
                }
                finally {
                    ((OutputStream)out).close();
                    continue;
                }
            }
            hasMoreEntries = false;
        }
    }

    public String insertTaskListIntoTheCourse(List<Task> taskList, Course course, Locale locale) throws Exception {
        List studentInCourseList = this.neo4JBaseService.getStudentForCourseViaLearningGroup(course.getCourseId());
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Task task : taskList) {
            this.neo4JBaseService.createTaskAndRelation(task, course.getCourseId());
            if ("headline".equals(task.getType())) continue;
            ++count;
            logger.info("TCC Task {} inserted  in course ", (Object)task.getName(), (Object)course.getName());
            logger.info("assign all Students begin");
            long startTime = System.currentTimeMillis();
            HashSet studentSet = new HashSet(studentInCourseList);
            CreateDeleteCounter counter = this.neo4JStudentToTaskService.updateTaskToStudentConnections(task, studentSet, new CreateDeleteCounter());
            String message = this.i18nService.getTranslation("TccConverterService.msg.studentsAssigned", locale, new Object[]{task.getName(), counter.getCreated()}) + "\n";
            sb.append(message);
            logger.info("insert Task / Assign Task (LTI Deeplink) took {} msec", (Object)(System.currentTimeMillis() - startTime));
        }
        logger.info("assign all Students end");
        return sb.toString();
    }
}

