/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.neo4j;

import de.mahlsdorf.groupservice.neodb.DriverManager;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.neodb.StatementRunner;
import de.mahlsdorf.groupservice.service.security.CryptDecryptHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursorTest
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CursorTest.class);
    ArrayList<Integer> failedIdsStudents = new ArrayList();
    ArrayList<Integer> failedIdsTeacher = new ArrayList();
    ArrayList<Integer> failedIdsLearningGroups = new ArrayList();
    ArrayList<Integer> failedIdsSchools = new ArrayList();
    private StatementRunner statementRunner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Driver driver = GraphDatabase.driver((String)"bolt://localhost:7687", (AuthToken)AuthTokens.basic((String)"neo4j", (String)"AWsedr##1"));
        DriverManager driverManager = new DriverManager();
        driverManager.setNeo4JUri("bolt://localhost:7687");
        driverManager.setNeo4UserName("neo4J");
        driverManager.setNeo4Password("XXsedr##1");
        Neo4JBaseService neo4JBaseService = new Neo4JBaseService(driverManager);
        this.statementRunner = new StatementRunner(neo4JBaseService);
        try (Session session = driver.session();){
            this.transformStudent(session);
            this.transformTeacher(session);
            this.transformSchool(session);
            this.transformLearningGroup(session);
            logger.info("failed ids Students {}", (Object)this.failedIdsStudents);
            logger.info("failed ids Teacher {}", (Object)this.failedIdsTeacher);
            logger.info("failed ids LearningGroups {}", (Object)this.failedIdsLearningGroups);
            logger.info("failed ids Schools {}", (Object)this.failedIdsSchools);
        }
        catch (Exception e) {
            logger.error("Exception while transform ", (Throwable)e);
        }
        finally {
            driver.close();
        }
    }

    private void transformStudent(Session session) throws Exception {
        Result cursor = session.run("match (s:Student) return s.number,s.firstname order by s.number");
        int count = 0;
        String password = CryptDecryptHelper.cryptString((String)"12345");
        while (cursor.hasNext()) {
            Record myRecord = cursor.next();
            Integer number = myRecord.get((String)cursor.keys().get(0)).asInt();
            logger.info("Name {} lastName ", (Object)number);
            String firstName = myRecord.get((String)cursor.keys().get(1)).asString();
            String cypher = "Match (s:Student {studentId:$number}) SET s.loginName=$loginName SET s.password=$password SET s.studentId=$studentId SET s.firstname=$firstname  return s ";
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("number", number);
            parameter.put("password", password);
            parameter.put("loginName", "" + number);
            parameter.put("studentId", UUID.randomUUID().toString());
            parameter.put("firstname", firstName);
            try {
                this.statementRunner.runCyperStatementPreparedWithException(cypher, parameter);
            }
            catch (Exception e) {
                logger.error("Exception while update student", (Throwable)e);
                this.failedIdsStudents.add(number);
            }
            ++count;
        }
        logger.info("got {} students ", (Object)count);
        logger.info("failed ids {}", (Object)this.failedIdsStudents);
    }

    private void transformTeacher(Session session) throws Exception {
        int count = 0;
        Result cursor = session.run("match (t:Teacher) return t.number,t.firstname");
        String password = CryptDecryptHelper.cryptString((String)"12345");
        while (cursor.hasNext()) {
            Record myRecord = cursor.next();
            Integer number = myRecord.get((String)cursor.keys().get(0)).asInt();
            String firstName = myRecord.get((String)cursor.keys().get(1)).asString();
            logger.info("Name {} lastName ", (Object)number);
            String cypher = "Match (t:Teacher {teacherId:$number}) SET t.loginName=$loginName SET t.password=$password SET t.teacherId=$teacherId SET t.isAdmin=$isAdmin SET t.firstname=$firstname  return t ";
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("number", number);
            parameter.put("password", password);
            parameter.put("loginName", "" + number);
            parameter.put("teacherId", UUID.randomUUID().toString());
            parameter.put("firstname", firstName);
            parameter.put("isAdmin", true);
            try {
                this.statementRunner.runCyperStatementPreparedWithException(cypher, parameter);
            }
            catch (Exception e) {
                this.failedIdsTeacher.add(number);
            }
            ++count;
        }
        logger.info("got {} teacher ", (Object)count);
        logger.info("failed ids Teacher {}", (Object)this.failedIdsTeacher);
    }

    private void transformSchool(Session session) throws Exception {
        int count = 0;
        Result cursor = session.run("match (s:School) return s.number");
        while (cursor.hasNext()) {
            Record myRecord = cursor.next();
            Integer number = myRecord.get((String)cursor.keys().get(0)).asInt();
            logger.info("Name {} number ", (Object)number);
            String cypher = "Match (s:School {schoolId:$number}) SET s.schoolId=$schoolId  return s ";
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("number", number);
            parameter.put("schoolId", UUID.randomUUID().toString());
            try {
                this.statementRunner.runCyperStatementPreparedWithException(cypher, parameter);
            }
            catch (Exception e) {
                logger.error("Exception while transform school ", (Throwable)e);
                this.failedIdsSchools.add(number);
            }
            ++count;
        }
        logger.info("got {} schools ", (Object)count);
        logger.info("failed ids Schools {}", (Object)this.failedIdsSchools);
    }

    private void transformLearningGroup(Session session) throws Exception {
        int count = 0;
        Result cursor = session.run("match (l:LearningGroup) return l.number");
        while (cursor.hasNext()) {
            Record myRecord = cursor.next();
            Integer number = myRecord.get((String)cursor.keys().get(0)).asInt();
            logger.info("Name {} number ", (Object)number);
            String cypher = "Match (l:LearningGroup {schoolId:$number}) SET l.groupId=$lgId SET l.learngroupName=$lgName  return l ";
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("number", number);
            parameter.put("lgId", UUID.randomUUID().toString());
            parameter.put("lgName", "LG " + number);
            try {
                this.statementRunner.runCyperStatementPreparedWithException(cypher, parameter);
            }
            catch (Exception e) {
                logger.error("Exception while transform school ", (Throwable)e);
                this.failedIdsLearningGroups.add(number);
            }
            ++count;
        }
        logger.info("got {} schools ", (Object)count);
        logger.info("failed ids {}", (Object)this.failedIdsLearningGroups);
    }
}

