/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.neo4j;

import com.google.gson.Gson;
import de.mahlsdorf.AbstractVaadineoException;
import de.mahlsdorf.groupservice.model.neo4j.HttpApiGraphResult;
import de.mahlsdorf.lti13.exception.exception.VaadineoNeo4jException;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class HttpGraphApiResultCleaner {
    private static final Logger logger = LoggerFactory.getLogger(HttpGraphApiResultCleaner.class);
    private static final String FIRST_NAME = "firstname";
    private static final String LAST_NAME = "lastname";
    private static final String NAME = "name";
    private final Map<String, List<String>> propertyRemainingMap;
    private static final Map<String, List<String>> PROPERTY_MAP = new TreeMap();

    public HttpGraphApiResultCleaner() {
        List<String> personProperties = List.of("firstname", "lastname");
        List<String> nameProperties = List.of("name");
        PROPERTY_MAP.put("School", nameProperties);
        PROPERTY_MAP.put("Student", personProperties);
        PROPERTY_MAP.put("Teacher", personProperties);
        PROPERTY_MAP.put("LearningGroup", List.of("learngroupName"));
        PROPERTY_MAP.put("Course", nameProperties);
        PROPERTY_MAP.put("Task", List.of("name", "type"));
        PROPERTY_MAP.put("StudentHasTask", List.of("type"));
        this.propertyRemainingMap = Collections.unmodifiableMap(PROPERTY_MAP);
    }

    public String cleanupGraph(@NotNull String resultToClean) throws AbstractVaadineoException {
        try {
            Gson gson = new Gson();
            HttpApiGraphResult graphResult = (HttpApiGraphResult)gson.fromJson(resultToClean, HttpApiGraphResult.class);
            HttpApiGraphResult graphResultReturn = this.cleanupInternal(graphResult);
            return gson.toJson((Object)graphResultReturn);
        }
        catch (Exception e) {
            logger.error("Exception while convert neo4j Response to internal Object response from neo4j >'{}'< ", (Object)resultToClean, (Object)e);
            throw new VaadineoNeo4jException(e.getMessage(), "NEO4J.wrongResponse", HttpStatus.BAD_REQUEST);
        }
    }

    private HttpApiGraphResult cleanupInternal(@NotNull HttpApiGraphResult httpGraph) {
        for (HttpApiGraphResult.Results result : httpGraph.getResult()) {
            for (HttpApiGraphResult.Data data : result.getData()) {
                HttpApiGraphResult.Graph graph = data.getGraph();
                for (HttpApiGraphResult.Node node : graph.getNodes()) {
                    Set remainingPropertySet = this.getRemainingPropertiesForNode(node);
                    HttpGraphApiResultCleaner.cleanUpNodeProperties((HttpApiGraphResult.Node)node, (Set)remainingPropertySet, (String)node.getLabels().toString());
                }
                for (HttpApiGraphResult.Relationship rel : graph.getRelationships()) {
                    this.cleanupRelationShip(rel);
                }
            }
        }
        return httpGraph;
    }

    private void cleanupRelationShip(HttpApiGraphResult.Relationship rel) {
        rel.getProperties().clear();
    }

    private Set<String> getRemainingPropertiesForNode(@NotNull HttpApiGraphResult.Node node) {
        HashSet<String> remainingProperties = new HashSet<String>();
        for (String label : node.getLabels()) {
            if (!this.propertyRemainingMap.containsKey(label)) continue;
            remainingProperties.addAll((Collection)this.propertyRemainingMap.get(label));
        }
        return remainingProperties;
    }

    private static void cleanUpNodeProperties(@NotNull HttpApiGraphResult.Node node, @NotNull Set<String> remainingProperties, String labels) {
        HashMap cleanedProperties = new HashMap();
        cleanedProperties.putAll(node.getProperties());
        for (Map.Entry entry : node.getProperties().entrySet()) {
            if (remainingProperties.contains(entry.getKey())) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Labels to work on {} Property {} exists in {}", new Object[]{labels, entry.getKey(), remainingProperties});
                continue;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Labels to work on {} Property {} exists N O T !  in {}", new Object[]{labels, entry.getKey(), remainingProperties});
            }
            cleanedProperties.remove(entry.getKey());
        }
        node.getProperties().clear();
        node.getProperties().putAll(cleanedProperties);
    }
}

