/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.neo4j;

import com.google.gson.Gson;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.CreateDeleteCounter;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.neodb.StatementRunner;
import de.mahlsdorf.groupservice.service.neo4j.Neo4JStudentToTaskService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Neo4JStudentToLearningGroupService {
    private static Neo4JStudentToLearningGroupService instance;
    private static final String NL = "\n";
    Logger logger = LoggerFactory.getLogger(Neo4JStudentToLearningGroupService.class);
    private Neo4JBaseService neo4JBaseService;
    private Neo4JStudentToTaskService neo4JStudentToTaskService;
    private StatementRunner statementRunner;

    public Neo4JStudentToLearningGroupService(@Autowired Neo4JBaseService neo4JBaseService, @Autowired Neo4JStudentToTaskService neo4JStudentToTaskService, @Autowired StatementRunner statementRunner) {
        this.neo4JBaseService = neo4JBaseService;
        this.neo4JStudentToTaskService = neo4JStudentToTaskService;
        this.statementRunner = statementRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateDeleteCounter updateLearningGroup(String learningGroupNumber, Set<Student> studentsFromGrid, boolean assignTasks) {
        List existingStudentsInLearnGroup = this.neo4JBaseService.getStudentsPerLearnGroup(learningGroupNumber);
        CreateDeleteCounter createDeleteCounter = new CreateDeleteCounter();
        try (Session neoSession = this.neo4JBaseService.getSessionSave();){
            HashSet<Student> studentToAddSet = new HashSet<Student>();
            for (Student studentFromGrid : studentsFromGrid) {
                if (existingStudentsInLearnGroup.contains(studentFromGrid)) {
                    existingStudentsInLearnGroup.remove(studentFromGrid);
                    continue;
                }
                studentToAddSet.add(studentFromGrid);
            }
            this.logger.info("students to remove size {} ", (Object)existingStudentsInLearnGroup.size());
            this.logger.info("students to add    size {}", (Object)studentToAddSet.size());
            Transaction tx = neoSession.beginTransaction();
            Long startTime = System.currentTimeMillis();
            try {
                HashSet studentIdsToAddSet = new HashSet();
                studentToAddSet.forEach(x -> studentIdsToAddSet.add(x.getStudentId()));
                createDeleteCounter = this.createStudentLearningGroupConnectionNew(tx, learningGroupNumber, studentIdsToAddSet, createDeleteCounter);
                if (assignTasks) {
                    List tasksForLearningGroup = this.neo4JBaseService.getTasksPerLearningGroup(learningGroupNumber);
                    HashSet taskIds = new HashSet();
                    tasksForLearningGroup.forEach(x -> taskIds.add(x.getTaskId()));
                    this.neo4JStudentToTaskService.assignStudentsToTasks(tx, new HashSet(tasksForLearningGroup), studentIdsToAddSet, new CreateDeleteCounter());
                }
                HashSet studentIdsToDeleteSet = new HashSet();
                existingStudentsInLearnGroup.forEach(x -> studentIdsToDeleteSet.add(x.getStudentId()));
                createDeleteCounter = this.deleteStudentLearningGroupConnectionNew(tx, learningGroupNumber, studentIdsToDeleteSet, createDeleteCounter);
                this.neo4JBaseService.deleteTasksPerLearningGroupAndStudentSet(learningGroupNumber, studentIdsToDeleteSet);
                tx.commit();
                tx.close();
            }
            catch (Exception e) {
                this.logger.error("Exception during create/delete relation ships Exception {} ", (Object)e.getMessage());
                tx.rollback();
            }
            finally {
                this.logger.info("create/delete relations took {} msec ", (Object)(System.currentTimeMillis() - startTime));
                neoSession.close();
            }
        }
        return createDeleteCounter;
    }

    private Map<String, Object> createParamMap(Set<String> studentIdSet, String learningGroupNumber) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList batchList = new ArrayList();
        HashMap<String, Object> innerParamMap = new HashMap<String, Object>();
        innerParamMap.put("from", studentIdSet);
        innerParamMap.put("to", learningGroupNumber);
        innerParamMap.put("created", ConstantsNeoc.INTERNET_TIME_FORMAT.format(new Date()));
        batchList.add(innerParamMap);
        paramMap.put("batch", batchList);
        Gson gson = new Gson();
        String paramMapAsJson = gson.toJson(paramMap);
        this.logger.info("ParameterMap {} ", (Object)paramMapAsJson);
        return paramMap;
    }

    private CreateDeleteCounter createStudentLearningGroupConnectionNew(Transaction tx, String learningGroupNumber, Set<String> studentNumberSet, CreateDeleteCounter createDeleteCounter) {
        String created = ConstantsNeoc.INTERNET_TIME_FORMAT.format(new Date());
        for (String studentId : studentNumberSet) {
            String cypherStatement = "  MATCH (from:Student),   (to:LearningGroup) WHERE to.groupId = $lgId \n and from.studentId = $studentId \n  CREATE (from)-[r:StudentInGroup]->(to) \n  SET r.created = $created  return type(r)\n";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("studentId", studentId);
            parameter.put("lgId", learningGroupNumber);
            parameter.put("created", created);
            this.logger.info("CyperStatement Create Relations {} parameter {}", (Object)cypherStatement, parameter);
            List res = this.statementRunner.runCyperStatementPreparedWithTx(cypherStatement, parameter, tx);
            this.logger.info("res {}", (Object)res);
        }
        createDeleteCounter.addCreated(studentNumberSet.size());
        return createDeleteCounter;
    }

    private CreateDeleteCounter deleteStudentLearningGroupConnectionNew(Transaction tx, String learningGroupId, Set<String> studentNumberIdSet, CreateDeleteCounter createDeleteCounter) {
        for (String studentId : studentNumberIdSet) {
            String cypherStatement = "  Match (a:Student) - [r:StudentInGroup] -> (lgroup:LearningGroup)   WHERE a.studentId = $studentId AND lgroup.groupId = $lgId \n  DELETE r";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("studentId", studentId);
            parameter.put("lgId", learningGroupId);
            this.logger.info("Cyperstatement Delete Relations {} parameter {} ", (Object)cypherStatement, parameter);
            this.statementRunner.runCyperStatementPreparedWithTx(cypherStatement, parameter, tx);
        }
        createDeleteCounter.addDeleted(studentNumberIdSet.size());
        return createDeleteCounter;
    }
}

