/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.neo4j;

import com.google.gson.Gson;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.CreateDeleteCounter;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.model.node.Task;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.neodb.StatementRunner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Neo4JStudentToTaskService
implements Serializable {
    private static final String NL = "\n";
    private static final String VAR_TASK = "task";
    public static final String QUERY_PARAMETER_STUDENT_ID = "studentId";
    public static final String QUERY_PARAMETER_TASK_ID = "taskId";
    public static final String QUERY_PARAMETER_CREATED = "created";
    public static final String QUERY_PARAMETER_TYPE = "type";
    private static Neo4JStudentToTaskService instance;
    private Neo4JBaseService neo4JBaseService;
    private StatementRunner statementRunner;
    private static final Logger logger;

    public Neo4JStudentToTaskService(@Autowired Neo4JBaseService neo4JBaseService, @Autowired StatementRunner statementRunner) {
        this.neo4JBaseService = neo4JBaseService;
        this.statementRunner = statementRunner;
    }

    public CreateDeleteCounter updateTaskToStudentConnectionsBulk(Set<Task> tasks, Set<Student> studentsFromGrid) {
        CreateDeleteCounter createDeleteCounter = new CreateDeleteCounter();
        for (Task task : tasks) {
            createDeleteCounter = this.updateTaskToStudentConnections(task, studentsFromGrid, createDeleteCounter);
        }
        return createDeleteCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateDeleteCounter updateTaskToStudentConnections(Task task, Set<Student> studentsFromGrid, CreateDeleteCounter createDeleteCounter) {
        String taskId = task.getTaskId();
        if ("headline".equals(task.getType()) && logger.isDebugEnabled()) {
            logger.debug("Task {} we do not assign Headlines rturning", (Object)task);
            return createDeleteCounter;
        }
        List existingStudentsHavingTask = this.neo4JBaseService.getStudentsPerTask(taskId);
        logger.info("Existing Students for this task {}", (Object)existingStudentsHavingTask);
        try (Session neoSession = this.neo4JBaseService.getSessionSave();){
            HashSet<Student> studentToAddSet = new HashSet<Student>();
            for (Student studentFromGrid : studentsFromGrid) {
                if (existingStudentsHavingTask.contains(studentFromGrid)) {
                    existingStudentsHavingTask.remove(studentFromGrid);
                    continue;
                }
                studentToAddSet.add(studentFromGrid);
            }
            logger.info("students to remove size {} ", (Object)existingStudentsHavingTask.size());
            logger.info("students to add    size {}", (Object)studentToAddSet.size());
            Transaction tx = neoSession.beginTransaction();
            Long startTime = System.currentTimeMillis();
            try {
                HashSet studentIdsToAddSet = new HashSet();
                studentToAddSet.forEach(x -> studentIdsToAddSet.add(x.getStudentId()));
                createDeleteCounter = this.createStudentTaskAsssignment(tx, task, studentIdsToAddSet, createDeleteCounter);
                HashSet studentIdsToDeleteSet = new HashSet();
                existingStudentsHavingTask.forEach(x -> studentIdsToDeleteSet.add(x.getStudentId()));
                createDeleteCounter = this.deleteStudentTaskAssignment(tx, taskId, studentIdsToDeleteSet, createDeleteCounter);
                tx.commit();
                tx.close();
            }
            catch (Exception e) {
                logger.error("Exception during create/delete relation ships Exception {} ", (Object)e.getMessage());
                tx.rollback();
            }
            finally {
                logger.info("create/delete relations took {} msec ", (Object)(System.currentTimeMillis() - startTime));
            }
        }
        return createDeleteCounter;
    }

    private Map<String, Object> createParamMap(Set<String> studentIdSet, Task task) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("studentIds", new ArrayList<String>(studentIdSet));
        paramMap.put(QUERY_PARAMETER_STUDENT_ID, new ArrayList<String>(studentIdSet).get(0));
        paramMap.put(QUERY_PARAMETER_TASK_ID, task.getTaskId());
        paramMap.put(QUERY_PARAMETER_CREATED, ConstantsNeoc.INTERNET_TIME_FORMAT.format(new Date()));
        paramMap.put(QUERY_PARAMETER_TYPE, task.getType());
        Gson gson = new Gson();
        String paramMapAsJson = gson.toJson(paramMap);
        logger.info("ParameterMap {} ", (Object)paramMapAsJson);
        return paramMap;
    }

    private CreateDeleteCounter createStudentTaskAsssignment(Transaction tx, Task task, Set<String> studentNumberSet, CreateDeleteCounter createDeleteCounter) {
        String created = ConstantsNeoc.INTERNET_TIME_FORMAT.format(new Date());
        for (String studentId : studentNumberSet) {
            String cypherStatement = "  MATCH ( student:Student { studentId : '" + studentId + "' } )   ,(task:Task { taskId : '" + task.getTaskId() + "' } )   MERGE (student)-[r:StudentHasTask]->(task)   SET r.created = $created  SET r.scoreGiven = 0    SET r.comment = \"nicht ausgef\u00fchrt\"   SET r.taskId = $taskId   SET r.studentNumber = $studentId   SET r.type = $type   SET r.maxScore = $maxScore  Return type(r) \n";
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put(QUERY_PARAMETER_STUDENT_ID, studentId);
            parameter.put(QUERY_PARAMETER_TASK_ID, task.getTaskId());
            parameter.put(QUERY_PARAMETER_CREATED, created);
            parameter.put(QUERY_PARAMETER_TYPE, task.getType());
            parameter.put("maxScore", task.getLtiLineItemMaxPoints());
            logger.info("cypher {} ### parameter {} ", (Object)cypherStatement, parameter);
            List res = this.statementRunner.runCyperStatementPreparedWithTx(cypherStatement, parameter, tx);
            logger.info("res {}", (Object)res);
        }
        createDeleteCounter.addCreated(studentNumberSet.size());
        return createDeleteCounter;
    }

    public CreateDeleteCounter assignStudentsToTasks(Transaction tx, Set<Task> tasks, Set<String> studentIds, CreateDeleteCounter createDeleteCounter) {
        for (Task task : tasks) {
            this.createStudentTaskAsssignment(tx, task, studentIds, createDeleteCounter);
        }
        return createDeleteCounter;
    }

    private CreateDeleteCounter deleteStudentTaskAssignment(Transaction tx, String taskId, Set<String> studentNumberIdSet, CreateDeleteCounter createDeleteCounter) {
        for (String studentId : studentNumberIdSet) {
            String cypherStatement = "  Match (a:Student) - [r:StudentHasTask] -> (task:Task)   WHERE a.studentId = $studentId and task.taskId = $taskId \n  DELETE r";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put(QUERY_PARAMETER_STUDENT_ID, studentId);
            parameter.put(QUERY_PARAMETER_TASK_ID, taskId);
            logger.info("Delete Relations cypher {} parameter {}", (Object)cypherStatement, parameter);
            List res = tx.run(cypherStatement, parameter).list();
            logger.info("Result {} ", (Object)res);
        }
        createDeleteCounter.addDeleted(studentNumberIdSet.size());
        return createDeleteCounter;
    }

    static {
        logger = LoggerFactory.getLogger(Neo4JStudentToTaskService.class);
    }
}

