/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.neo4j;

import com.google.gson.Gson;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.CreateDeleteCounter;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.neodb.StatementRunner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Neo4JTeacherToLearningGroupService
implements Serializable {
    private static final String NL = "\n";
    private static Neo4JTeacherToLearningGroupService instance;
    private Neo4JBaseService neo4JBaseService;
    private StatementRunner statementRunner;
    Logger logger = LoggerFactory.getLogger(Neo4JTeacherToLearningGroupService.class);

    public Neo4JTeacherToLearningGroupService(@Autowired Neo4JBaseService neo4JBaseService, @Autowired StatementRunner statementRunner) {
        this.neo4JBaseService = neo4JBaseService;
        this.statementRunner = statementRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateDeleteCounter updateTeacherToLearningGroupConnections(String teacherId, Set<Teacher> teachersAssignedFromGrid) {
        List assignedTeacherToGroup = this.neo4JBaseService.getTeacherForLearningGroup(teacherId);
        Transaction tx = null;
        Long startTime = System.currentTimeMillis();
        CreateDeleteCounter createDeleteCounter = new CreateDeleteCounter();
        try (Session neoSession = this.neo4JBaseService.getSessionSave();){
            HashSet<Teacher> teacherToAddSet = new HashSet<Teacher>();
            for (Teacher studentFromGrid : teachersAssignedFromGrid) {
                if (assignedTeacherToGroup.contains(studentFromGrid)) {
                    assignedTeacherToGroup.remove(studentFromGrid);
                    continue;
                }
                teacherToAddSet.add(studentFromGrid);
            }
            this.logger.info("Teacher to remove size {} ", (Object)assignedTeacherToGroup.size());
            this.logger.info("Teacher to add    size {}", (Object)teacherToAddSet.size());
            tx = neoSession.beginTransaction();
            HashSet teacherIdsIdsToAddSet = new HashSet();
            teacherToAddSet.forEach(x -> teacherIdsIdsToAddSet.add(x.getTeacherId()));
            createDeleteCounter = this.createStudentLearningGroupConnectionNew(tx, teacherId, teacherIdsIdsToAddSet, createDeleteCounter);
            HashSet teacherIdsToDeleteSet = new HashSet();
            assignedTeacherToGroup.forEach(x -> teacherIdsToDeleteSet.add(x.getTeacherId()));
            createDeleteCounter = this.deleteStudentLearningGroupConnectionNew(tx, teacherId, teacherIdsToDeleteSet, createDeleteCounter);
            tx.commit();
            tx.close();
        }
        catch (Exception e) {
            this.logger.error("Exception during create/delete relation ships Exception {} ", (Object)e.getMessage());
            if (tx != null) {
                tx.rollback();
            }
        }
        finally {
            this.logger.info("create/delete relations took {} msec ", (Object)(System.currentTimeMillis() - startTime));
        }
        return createDeleteCounter;
    }

    private Map<String, Object> createParamMap(Set<String> studentIdSet, String lgNumber) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList batchList = new ArrayList();
        HashMap<String, Object> innerParamMap = new HashMap<String, Object>();
        innerParamMap.put("from", studentIdSet);
        innerParamMap.put("to", lgNumber);
        innerParamMap.put("created", ConstantsNeoc.INTERNET_TIME_FORMAT.format(new Date()));
        batchList.add(innerParamMap);
        paramMap.put("batch", batchList);
        Gson gson = new Gson();
        String paramMapAsJson = gson.toJson(paramMap);
        this.logger.info("ParameterMap {} ", (Object)paramMapAsJson);
        return paramMap;
    }

    private CreateDeleteCounter createStudentLearningGroupConnectionNew(Transaction tx, String LgNumber, Set<String> studentNumberSet, CreateDeleteCounter createDeleteCounter) {
        for (String teacherId : studentNumberSet) {
            String cypherStatement = "  MATCH (from:Teacher) \n , (to:LearningGroup) WHERE to.groupId = $lgId \n   and  from.teacherId = $teacherId \n  CREATE (from)-[r:TeacherHasGroup]->(to) \n  SET r.created = $created\n";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("teacherId", teacherId);
            parameter.put("lgId", LgNumber);
            parameter.put("created", ConstantsNeoc.INTERNET_TIME_FORMAT.format(new Date()));
            this.logger.info("CyperStatement Create Relations {} parameter ", (Object)cypherStatement, parameter);
            List list = this.statementRunner.runCyperStatementPrepared(cypherStatement, parameter);
        }
        createDeleteCounter.addCreated(studentNumberSet.size());
        return createDeleteCounter;
    }

    private CreateDeleteCounter deleteStudentLearningGroupConnectionNew(Transaction tx, String groupId, Set<String> teacherIdsToDelete, CreateDeleteCounter createDeleteCounter) {
        for (String teacherId : teacherIdsToDelete) {
            String cypherStatement = "  Match (a:Teacher) - [r:TeacherHasGroup] -> (lgroup:LearningGroup)   WHERE a.teacherId=$teacherId AND lgroup.groupId = $lgId \n  DELETE r";
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("teacherId", teacherId);
            parameter.put("lgId", groupId);
            this.logger.info("Cyperstatement Delete Relations {} parameter {} ", (Object)cypherStatement, parameter);
            this.statementRunner.runCyperStatementPrepared(cypherStatement, parameter);
        }
        createDeleteCounter.addDeleted(teacherIdsToDelete.size());
        return createDeleteCounter;
    }
}

