/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.security;

import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.service.groupservice.GraphViewTemplateService;
import de.mahlsdorf.groupservice.service.neo4j.Neo4JStudentToLearningGroupService;
import de.mahlsdorf.lti13.advantage.service.jwks.RSAUtils;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyPairGenerator {
    private static final Logger logger = LoggerFactory.getLogger(GraphViewTemplateService.class);
    private static KeyPairGenerator INSTANCE;
    private final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMdd-HHmmssSSS");

    private KeyPairGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyPairGenerator getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<Neo4JStudentToLearningGroupService> clazz = Neo4JStudentToLearningGroupService.class;
        synchronized (Neo4JStudentToLearningGroupService.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new KeyPairGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Tool createNewKeyPair(Tool tool) {
        String platformId = tool.getToolId();
        logger.info("generate new Keypair for Platform {} ", (Object)platformId);
        try {
            KeyPair keyPair = this.generateKeyPair();
            String publicKeyAsPem = RSAUtils.getPEMFromPublicKey((PublicKey)keyPair.getPublic());
            String privateKeyAsPem = RSAUtils.getPEMFromPrivateKey((PrivateKey)keyPair.getPrivate());
            tool.setPrivateKeyAsPem(privateKeyAsPem);
            tool.setKeyId(platformId + "-" + this.SDF.format(new Date()));
            tool.setPublicKeyAsPem(publicKeyAsPem);
        }
        catch (Exception e) {
            logger.error("Exception while generate Keypair for Platform Definition ", (Throwable)e);
        }
        return tool;
    }

    private KeyPair generateKeyPair() throws Exception {
        java.security.KeyPairGenerator generator = java.security.KeyPairGenerator.getInstance("RSA");
        generator.initialize(2048, new SecureRandom());
        KeyPair pair = generator.generateKeyPair();
        logger.info("Key generated with Algorithm {}", (Object)pair.getPrivate().getAlgorithm());
        return pair;
    }
}

