/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.service.ui;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.vaadin.flow.i18n.I18NProvider;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class I18nService
implements I18NProvider {
    private static final Logger logger = LoggerFactory.getLogger(I18nService.class);
    private static I18nService Instance;
    private static final String NEOC_MESSAGES = "neoc_messages";
    private static final LoadingCache<Locale, ResourceBundle> bundleCache;

    public static I18nService getInstance() {
        if (Instance == null) {
            Instance = new I18nService();
        }
        return Instance;
    }

    private static ResourceBundle initializeBundle(Locale locale) {
        return I18nService.readProperties((Locale)locale);
    }

    protected static ResourceBundle readProperties(Locale locale) {
        ClassLoader cl = I18nService.class.getClassLoader();
        ResourceBundle propertiesBundle = null;
        try {
            propertiesBundle = ResourceBundle.getBundle("neoc_messages", locale, cl);
        }
        catch (MissingResourceException e) {
            logger.error("Missing resource", (Throwable)e);
        }
        return propertiesBundle;
    }

    public List<Locale> getProvidedLocales() {
        return Arrays.asList(Locale.ROOT, Locale.GERMAN);
    }

    public String getTranslation(String key, Locale locale, Object ... params) {
        String value;
        if (key == null) {
            logger.warn("Got lang request for key with null value!");
            return "";
        }
        ResourceBundle bundle = (ResourceBundle)bundleCache.getUnchecked((Object)locale);
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            logger.warn("Missing resource", (Throwable)e);
            return "!" + locale.getLanguage() + ": " + key;
        }
        if (params.length > 0) {
            value = MessageFormat.format(value, params);
        }
        return value;
    }

    static {
        bundleCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    }
}

