/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.accordion.Accordion;
import com.vaadin.flow.component.accordion.AccordionPanel;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.applayout.DrawerToggle;
import com.vaadin.flow.component.avatar.Avatar;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLink;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.spring.annotation.UIScope;
import de.mahlsdorf.groupservice.model.node.PersonIF;
import de.mahlsdorf.groupservice.model.node.School;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.service.dynreg.DynamicRegistrationService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import de.mahlsdorf.groupservice.ui.layout.dialogs.ConfirmDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.LoginDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.PasswordChangeDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.StudentDialog;
import de.mahlsdorf.groupservice.ui.layout.dialogs.TeacherDialog;
import de.mahlsdorf.groupservice.ui.layout.utils.FindById;
import de.mahlsdorf.groupservice.ui.layout.views.school.CreateSchoolView;
import de.mahlsdorf.groupservice.ui.layout.views.school.EditSchoolView;
import de.mahlsdorf.groupservice.ui.layout.views.students.StudentCourseView;
import de.mahlsdorf.groupservice.ui.layout.views.students.StudentGradesView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.AllStudentView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.AssignStudentToLearningGroupView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.CourseView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.GraphHtmlLearningGroupTemplateControllerView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.GraphHtmlTaskTemplateControllerView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.HomeView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.LearningGroupNamesView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.SubjectView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.TaskView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.TaskViewWithGradeAsSubView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.TeacherView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.ToolView;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.info.BuildProperties;
import org.springframework.stereotype.Component;

@Component
@UIScope
@CssImport(value="./styles/shared-styles.css")
@Route
public class MainAppLayout
extends AppLayout {
    private static final Logger LOG = LoggerFactory.getLogger(MainAppLayout.class);
    public static final String MSG_KEY_VIEWNAME = "MainAppLayout.";
    public static final String MSG_KEY_VIEWNAME_TEACHER = "MainAppLayout.teacher.";
    public static final String MSG_KEY_VIEWNAME_STUDENT = "MainAppLayout.student.";
    public static final String MSG_KEY_VIEWNAME_LOGIN = "MainAppLayout.login.";
    public static final String LOGOUT = "logout";
    private School school = null;
    private Teacher loggedInTeacher = null;
    private Student loggedInStudent = null;
    private PersonIF loggedInPerson;
    private LayoutType layoutType;
    private boolean isLoginShown = false;
    private String courseId;
    private boolean featureLti13Enabled = false;
    private final DynamicRegistrationService dynamicRegistrationService;
    private final I18nService i18nService;
    private final String hostUri;
    private VerticalLayout loginLayout = new VerticalLayout();
    private VerticalLayout teacherLayout = new VerticalLayout();
    private VerticalLayout studentLayout = new VerticalLayout();
    private boolean drawerAdded = false;
    private final HorizontalLayout navigationHorizontalLayout = new HorizontalLayout();
    private String softwareVersion;

    public MainAppLayout(I18nService i18nService, @Value(value="${platform.hosturi}") String hostUri, @Autowired DynamicRegistrationService dynamicRegistrationService, @Autowired BuildProperties buildProperties) {
        this.i18nService = i18nService;
        this.hostUri = hostUri;
        UI.getCurrent().getSession().setAttribute("loginData", (Object)this);
        this.dynamicRegistrationService = dynamicRegistrationService;
        this.softwareVersion = buildProperties.getVersion();
        this.setId("mainAppLayout");
        this.createLoginLayout();
    }

    private HorizontalLayout getRouterLayout(Icon icon, RouterLink routerLink) {
        icon.setColor("#245cf9");
        return new HorizontalLayout(new com.vaadin.flow.component.Component[]{icon, routerLink});
    }

    public void createLoginLayout() {
        Button loginButton = new Button(this.i18nService.getTranslation("MainAppLayout.login.label.login", this.getLocale(), new Object[0]));
        loginButton.setId("loginLink");
        loginButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.showLogin());
        loginButton.setWidth("100%");
        RouterLink schoolCreateLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.login.label.createSchool", this.getLocale(), new Object[0]), CreateSchoolView.class);
        schoolCreateLink.setId("schoolLink");
        RouterLink homeLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.login.label.info", this.getLocale(), new Object[0]), HomeView.class);
        homeLink.setId("homeLink");
        this.loginLayout = new VerticalLayout(new com.vaadin.flow.component.Component[]{loginButton, schoolCreateLink, homeLink});
        this.remove(new com.vaadin.flow.component.Component[]{this.studentLayout});
        this.remove(new com.vaadin.flow.component.Component[]{this.teacherLayout});
        this.addToDrawer(new com.vaadin.flow.component.Component[]{this.loginLayout});
        this.navigationHorizontalLayout.removeAll();
        this.navigationHorizontalLayout.setWidth("100%");
        if (!this.drawerAdded) {
            this.addToNavbar(new com.vaadin.flow.component.Component[]{new DrawerToggle(), this.navigationHorizontalLayout});
            this.drawerAdded = true;
        }
    }

    public void createTeacherLayout() {
        Button logOutButton = new Button(this.i18nService.getTranslation("MainAppLayout.student.label.logout", this.getLocale(), new Object[0]));
        logOutButton.addClickListener((ComponentEventListener & Serializable)event -> this.doLogout());
        logOutButton.setWidth("100%");
        logOutButton.setId("logoutId");
        Accordion accordion = new Accordion();
        AccordionPanel userMgmtPanel = new AccordionPanel(this.i18nService.getTranslation("MainAppLayout.teacher.label.usermenue", this.getLocale(), new Object[0]));
        userMgmtPanel.setId("userMgmtId");
        RouterLink allUserLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.teacher.label.alluser", this.getLocale(), new Object[0]), AllStudentView.class);
        allUserLink.setId("linkUserMgmt");
        RouterLink allTeacherLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.teacher.label.allteacher", this.getLocale(), new Object[0]), TeacherView.class);
        allTeacherLink.setId("linkTeacherMgmt");
        RouterLink allLearningGroupLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.teacher.label.learninggroups", this.getLocale(), new Object[0]), LearningGroupNamesView.class);
        allLearningGroupLink.setId("linkLearnGroupMgmt");
        RouterLink studentLearnGroupLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.teacher.label.student2learninggroup", this.getLocale(), new Object[0]), AssignStudentToLearningGroupView.class);
        studentLearnGroupLink.setId("linkLearnGroupAssignMgmt");
        userMgmtPanel.add(new com.vaadin.flow.component.Component[]{this.getRouterLayout(VaadinIcon.USER_CARD.create(), allUserLink), this.getRouterLayout(VaadinIcon.SPECIALIST.create(), allTeacherLink), this.getRouterLayout(VaadinIcon.GROUP.create(), allLearningGroupLink), this.getRouterLayout(VaadinIcon.SPLIT.create(), studentLearnGroupLink)});
        accordion.add(userMgmtPanel);
        AccordionPanel taskAndCoursePanel = new AccordionPanel(this.i18nService.getTranslation("MainAppLayout.teacher.label.taskmenue", this.getLocale(), new Object[0]));
        taskAndCoursePanel.setId("courseMgmtId");
        RouterLink courseMgmtLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.teacher.label.managecourses", this.getLocale(), new Object[0]), CourseView.class);
        courseMgmtLink.setId("linkCourseMgmt");
        RouterLink taskMgmtLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.teacher.label.managetasks", this.getLocale(), new Object[0]), TaskView.class);
        taskMgmtLink.setId("linkTaskMgmt");
        taskAndCoursePanel.add(new com.vaadin.flow.component.Component[]{this.getRouterLayout(VaadinIcon.SPLIT_H.create(), courseMgmtLink), this.getRouterLayout(VaadinIcon.LIST.create(), taskMgmtLink)});
        accordion.add(taskAndCoursePanel);
        AccordionPanel gradesPanel = new AccordionPanel(this.i18nService.getTranslation("MainAppLayout.teacher.label.gradesmenue", this.getLocale(), new Object[0]));
        gradesPanel.setId("resultMgmtId");
        RouterLink gradesLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.teacher.label.gradesSub", this.getLocale(), new Object[0]), TaskViewWithGradeAsSubView.class);
        gradesLink.setId("linkGradesMgmt");
        gradesPanel.add(new com.vaadin.flow.component.Component[]{this.getRouterLayout(VaadinIcon.USER_CHECK.create(), gradesLink)});
        accordion.add(gradesPanel);
        AccordionPanel visualGraphPanel = new AccordionPanel(this.i18nService.getTranslation("MainAppLayout.teacher.label.visualmenue", this.getLocale(), new Object[0]));
        visualGraphPanel.setId("graphId");
        RouterLink lgGraphLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.teacher.label.visuallearninggroups", this.getLocale(), new Object[0]), GraphHtmlLearningGroupTemplateControllerView.class);
        RouterLink taskGraphLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.teacher.label.visualtasks", this.getLocale(), new Object[0]), GraphHtmlTaskTemplateControllerView.class);
        visualGraphPanel.add(new com.vaadin.flow.component.Component[]{this.getRouterLayout(VaadinIcon.PAPERCLIP.create(), lgGraphLink)});
        visualGraphPanel.add(new com.vaadin.flow.component.Component[]{this.getRouterLayout(VaadinIcon.ABACUS.create(), taskGraphLink)});
        accordion.add(visualGraphPanel);
        AccordionPanel toolPanel = new AccordionPanel(this.i18nService.getTranslation("MainAppLayout.teacher.label.toolsmenue", this.getLocale(), new Object[0]));
        toolPanel.setId("toolId");
        RouterLink toolLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.teacher.label.tools", this.getLocale(), new Object[0]), ToolView.class);
        toolLink.setId("linkToolMgmt");
        toolPanel.add(new com.vaadin.flow.component.Component[]{this.getRouterLayout(VaadinIcon.SCREWDRIVER.create(), toolLink)});
        this.teacherLayout = new VerticalLayout(new com.vaadin.flow.component.Component[]{logOutButton, accordion});
        accordion.add(toolPanel);
        AccordionPanel schoolPanel = new AccordionPanel(this.i18nService.getTranslation("MainAppLayout.teacher.label.schoolMgmt", this.getLocale(), new Object[0]));
        schoolPanel.setId("schoolMgmtId");
        RouterLink editSchoolLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.teacher.label.schoolEdit", this.getLocale(), new Object[0]), EditSchoolView.class);
        editSchoolLink.setId("linkSchoolMgmt");
        schoolPanel.add(new com.vaadin.flow.component.Component[]{this.getRouterLayout(VaadinIcon.BELL.create(), editSchoolLink)});
        RouterLink editSubjectLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.teacher.label.subjectEdit", this.getLocale(), new Object[0]), SubjectView.class);
        editSubjectLink.setId("linkSchoolSubjectMgmt");
        schoolPanel.add(new com.vaadin.flow.component.Component[]{this.getRouterLayout(VaadinIcon.ARCHIVES.create(), editSubjectLink)});
        accordion.add(schoolPanel);
        this.navigationHorizontalLayout.removeAll();
        this.navigationHorizontalLayout.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout("")});
        this.remove(new com.vaadin.flow.component.Component[]{this.loginLayout});
        this.addToDrawer(new com.vaadin.flow.component.Component[]{this.teacherLayout});
        this.navigationHorizontalLayout.setMargin(false);
        this.navigationHorizontalLayout.setPadding(false);
        Object o = UI.getCurrent().getSession().getAttribute("loginUrl");
        if (o != null) {
            URL url = (URL)o;
            UI.getCurrent().navigate(url.toString());
        } else {
            this.getUI().ifPresent(ui -> ui.navigate(AllStudentView.class));
        }
        VaadinSession.getCurrent().setAttribute("MAIN_APP_LAYOUT", (Object)this);
        LOG.info("stored Main AppLayout to the Session ");
        this.setBackgroundImage((com.vaadin.flow.component.Component)this.navigationHorizontalLayout);
    }

    public void createStudentLayout() {
        this.studentLayout = new VerticalLayout();
        Button logOutButton = new Button(this.i18nService.getTranslation("MainAppLayout.student.label.logout", this.getLocale(), new Object[0]));
        logOutButton.addClickListener((ComponentEventListener & Serializable)event -> this.doLogout());
        logOutButton.setWidth("100%");
        logOutButton.setId("logoutId");
        RouterLink courseLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.student.label.courses", this.getLocale(), new Object[0]), StudentCourseView.class);
        courseLink.setId("linkCourseId");
        RouterLink gradesLink = new RouterLink(this.i18nService.getTranslation("MainAppLayout.student.label.grades", this.getLocale(), new Object[0]), StudentGradesView.class);
        gradesLink.setId("linkTaskId");
        this.studentLayout = new VerticalLayout(new com.vaadin.flow.component.Component[]{logOutButton, courseLink, gradesLink});
        this.remove(new com.vaadin.flow.component.Component[]{this.loginLayout});
        this.addToDrawer(new com.vaadin.flow.component.Component[]{this.studentLayout});
        this.navigationHorizontalLayout.removeAll();
        this.navigationHorizontalLayout.add(new com.vaadin.flow.component.Component[]{this.getLoggedInInfoLayout("")});
        this.navigationHorizontalLayout.setId("NAVI");
        this.getUI().ifPresent(ui -> ui.navigate(StudentCourseView.class));
        this.setBackgroundImage((com.vaadin.flow.component.Component)this.navigationHorizontalLayout);
    }

    private void setBackgroundImage(com.vaadin.flow.component.Component component) {
        com.vaadin.flow.component.Component component1 = FindById.findComponentById((com.vaadin.flow.component.Component)this, (String)"navbarTop", (String)">");
        if (!StringUtils.isEmpty((CharSequence)this.getSchool().getBackgroundImage())) {
            if (component1 != null) {
                component = component1;
            }
            component.getStyle().set("background-image", "url(\"" + this.getSchool().getBackgroundImage() + "\")");
        }
    }

    public void doLogout() {
        try {
            BaseView.getActualUrl((com.vaadin.flow.component.Component)this);
            UI.getCurrent().getSession().setAttribute("loginData", null);
            this.setLayoutType(LayoutType.LOGIN_LAYOUT);
            LOG.info("user logged out");
            this.getUI().ifPresent(ui -> ui.navigate(HomeView.class));
        }
        catch (Exception e) {
            LOG.warn("Exception while logout ", (Throwable)e);
        }
    }

    public void showLogin() {
        if (!this.isLoginShown) {
            this.isLoginShown = true;
            LoginDialog loginWindow = new LoginDialog(this);
            this.getUI().ifPresent(ui -> ui.navigate(HomeView.class));
            loginWindow.open();
        }
    }

    public HorizontalLayout getLoggedInInfoLayout(String message) {
        com.vaadin.flow.component.Component menuBar;
        HorizontalLayout hlayout = new HorizontalLayout();
        StringBuilder sb = new StringBuilder();
        if (this.getLayoutType().equals((Object)LayoutType.TEACHER_LAYOUT)) {
            sb.append("<span class=\"background-header\" style=\"padding:10px;\" ><b>Name: </b>").append(this.loggedInTeacher.getFirstName()).append(" ").append(this.loggedInTeacher.getLastName()).append("<b> Schule: </b>").append(this.school.getName());
            menuBar = this.createProfileMenubar(this.loggedInTeacher.getFirstName(), this.loggedInTeacher.getLastName());
        } else {
            sb.append("<span class=\"background-header\"><b>Sch\u00fcler: </b>").append(this.loggedInStudent.getFirstName()).append(" ").append(this.loggedInStudent.getLastName()).append("<b> Schule: </b>").append(this.school.getName());
            menuBar = this.createProfileMenubar(this.loggedInStudent.getFirstName(), this.loggedInStudent.getLastName());
        }
        sb.append(message).append("</span>");
        HorizontalLayout hLayoutAll = new HorizontalLayout();
        HorizontalLayout hLayoutMbar = new HorizontalLayout();
        Html html = new Html(sb.toString());
        hLayoutMbar.add(new com.vaadin.flow.component.Component[]{html, menuBar});
        FlexComponent.JustifyContentMode mode = FlexComponent.JustifyContentMode.END;
        hLayoutMbar.setJustifyContentMode(mode);
        hLayoutMbar.setWidth("100%");
        hLayoutAll.add(new com.vaadin.flow.component.Component[]{hLayoutMbar});
        hlayout.setWidthFull();
        hLayoutAll.setWidthFull();
        hLayoutMbar.setWidthFull();
        menuBar.setVisible(true);
        hLayoutAll.setSpacing(false);
        hLayoutAll.setAlignSelf(FlexComponent.Alignment.END, new HasElement[0]);
        return hLayoutAll;
    }

    private com.vaadin.flow.component.Component createProfileMenubar(String firstName, String lastName) {
        MenuBar menuBar = new MenuBar();
        menuBar.addThemeVariants((ThemeVariant[])new MenuBarVariant[]{MenuBarVariant.LUMO_LARGE});
        menuBar.addThemeVariants((ThemeVariant[])new MenuBarVariant[]{MenuBarVariant.LUMO_TERTIARY});
        ComponentEventListener & Serializable changePasswordListener = (ComponentEventListener & Serializable)e -> {
            if (this.getLayoutType().equals((Object)LayoutType.TEACHER_LAYOUT)) {
                this.showPasswordDialog((PersonIF)this.loggedInTeacher);
            }
            if (this.getLayoutType().equals((Object)LayoutType.STUDENT_LAYOUT)) {
                this.showPasswordDialog((PersonIF)this.loggedInStudent);
            }
        };
        ComponentEventListener & Serializable changeProfileListener = (ComponentEventListener & Serializable)e -> {
            if (this.getLayoutType().equals((Object)LayoutType.TEACHER_LAYOUT)) {
                this.showProfileDialog((PersonIF)this.loggedInTeacher);
            }
            if (this.getLayoutType().equals((Object)LayoutType.STUDENT_LAYOUT)) {
                this.showProfileDialog((PersonIF)this.loggedInStudent);
            }
        };
        ComponentEventListener & Serializable versionListener = (ComponentEventListener & Serializable)e -> {
            Div infoDiv = new Div();
            infoDiv.setText(this.i18nService.getTranslation("MainAppLayout.menue.version", this.getLocale(), new Object[0]).concat(" : ").concat(this.softwareVersion));
            List<Div> comps = List.of(infoDiv);
            ConfirmDialog confirmDialog = new ConfirmDialog(comps, List.of());
            confirmDialog.open();
        };
        ComponentEventListener & Serializable logoutListener = (ComponentEventListener & Serializable)e -> this.doLogout();
        ComponentEventListener & Serializable noopListener = (ComponentEventListener & Serializable)e -> {};
        Avatar avatar = new Avatar();
        avatar.setName(firstName + " " + lastName);
        avatar.setColorIndex(Integer.valueOf(Integer.parseInt("" + Math.round(Math.random() * 5.0))));
        MenuItem profile = menuBar.addItem((com.vaadin.flow.component.Component)avatar);
        SubMenu profileSubMenu = (SubMenu)profile.getSubMenu();
        profileSubMenu.addItem(this.i18nService.getTranslation("MainAppLayout.menue.username", this.getLocale(), new Object[]{firstName, lastName}), (ComponentEventListener)noopListener);
        profileSubMenu.addItem(this.i18nService.getTranslation("MainAppLayout.menue.changepassword", this.getLocale(), new Object[0]), (ComponentEventListener)changePasswordListener);
        profileSubMenu.addItem(this.i18nService.getTranslation("MainAppLayout.menue.changeprofile", this.getLocale(), new Object[0]), (ComponentEventListener)changeProfileListener);
        profileSubMenu.addItem(this.i18nService.getTranslation("MainAppLayout.menue.version", this.getLocale(), new Object[0]), (ComponentEventListener)versionListener);
        profileSubMenu.addItem(this.i18nService.getTranslation("MainAppLayout.menue.logout", this.getLocale(), new Object[0]), (ComponentEventListener)logoutListener);
        return menuBar;
    }

    private void showProfileDialog(PersonIF person) {
        if (person instanceof Teacher) {
            TeacherDialog teacherDialog = new TeacherDialog(this, this.school.getSchoolId(), this.getLoggedInTeacher(), null, this.loggedInTeacher);
            teacherDialog.open();
        }
        if (person instanceof Student) {
            Set<Student> studentSet = Set.of(this.getLoggedInStudent());
            StudentDialog studentDialog = new StudentDialog(this, this.school.getSchoolId(), studentSet, null, false);
            studentDialog.open();
        }
    }

    private void showPasswordDialog(PersonIF person) {
        PasswordChangeDialog passwordChangeDialog = new PasswordChangeDialog(this, person);
        passwordChangeDialog.open();
    }

    public void setLoginShown(boolean loginShown) {
        this.isLoginShown = loginShown;
    }

    public String getSchoolId() {
        return this.school != null ? this.school.getSchoolId() : null;
    }

    public School getSchool() {
        return this.school;
    }

    public void setSchool(School school) {
        this.school = school;
    }

    public Teacher getLoggedInTeacher() {
        return this.loggedInTeacher;
    }

    public void setLoggedInTeacher(@NotNull Teacher loggedInTeacher) {
        this.loggedInTeacher = loggedInTeacher;
        this.loggedInPerson = loggedInTeacher;
    }

    public PersonIF getLoggedInPerson() {
        return this.loggedInPerson;
    }

    public Student getLoggedInStudent() {
        return this.loggedInStudent;
    }

    public void setLoggedInStudent(Student loggedInStudent) {
        this.loggedInStudent = loggedInStudent;
        this.loggedInPerson = loggedInStudent;
    }

    public String getLoggedInStudentNumber() {
        return this.loggedInStudent.getStudentId();
    }

    public LayoutType getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(LayoutType layoutType) {
        this.layoutType = layoutType;
        switch (1.$SwitchMap$de$mahlsdorf$groupservice$ui$layout$MainAppLayout$LayoutType[layoutType.ordinal()]) {
            case 1: {
                this.createTeacherLayout();
                break;
            }
            case 2: {
                this.createStudentLayout();
                break;
            }
            case 3: {
                this.createLoginLayout();
                break;
            }
            default: {
                this.createLoginLayout();
            }
        }
    }

    public String getCourseId() {
        return this.courseId;
    }

    public void setCourseId(String courseId) {
        this.courseId = courseId;
    }

    public boolean isFeatureLti13Enabled() {
        return this.featureLti13Enabled;
    }

    @Value(value="${feature.lti13.enabled:false}")
    public void setFeatureLti13Enabled(boolean featureLti13Enabled) {
        this.featureLti13Enabled = featureLti13Enabled;
    }

    public I18nService getI18nService() {
        return this.i18nService;
    }

    public String getHostUri() {
        return this.hostUri;
    }

    public DynamicRegistrationService getDynamicRegistrationService() {
        return this.dynamicRegistrationService;
    }
}

