/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.baseui;

import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.provider.ListDataProvider;
import de.mahlsdorf.groupservice.ui.layout.baseui.FilterUiUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseDialog
extends Dialog {
    private final FilterUiUtils filterUiUtils;
    protected List<TextField> filterFields;

    public BaseDialog() {
        this.setModal(true);
        this.setDraggable(false);
        this.setCloseOnEsc(false);
        this.setCloseOnOutsideClick(false);
        this.filterUiUtils = new FilterUiUtils();
    }

    protected void showNotificationMiddle(String message, int durartionIdSec) {
        Notification.show((String)message, (int)(durartionIdSec * 1000), (Notification.Position)Notification.Position.MIDDLE);
    }

    protected TextField getColumnFilterField() {
        return this.filterUiUtils.getColumnFilterField();
    }

    protected void clearFilterFields(TextField source, String eventValue, List<TextField> filterFields, ListDataProvider dataprovider) {
        this.filterUiUtils.clearFilterFields(source, eventValue, filterFields, dataprovider);
    }

    protected void checkAllFilterFieldsEmpty(String eventValue, List<TextField> filterFields, ListDataProvider dataprovider) {
        this.filterUiUtils.checkAllFilterFieldsEmpty(eventValue, filterFields, dataprovider);
    }

    protected boolean compareGridValues(String filterValue, String gridValue) {
        return this.filterUiUtils.compareGridValues(filterValue, gridValue);
    }

    protected void clearOtherFilterFields(TextField source, List<TextField> filterFields) {
        this.filterUiUtils.clearOtherFilterFields(source, filterFields);
    }

    protected void clearDataProviderFiltersIfNeeded(String eventValue, List<TextField> filterFields, ListDataProvider dataprovider) {
        this.filterUiUtils.clearDataProviderFiltersIfNeeded(eventValue, filterFields, dataprovider);
    }

    protected void reuseExistingFilter(List<TextField> filterFields) {
        this.filterUiUtils.reuseExistingFilter(filterFields);
    }

    public <T> List<String> convertValidatorErrors(Binder<T> binder) {
        ArrayList<String> binderErrors = new ArrayList<String>();
        for (ValidationResult result : binder.validate().getValidationErrors()) {
            binderErrors.add(result.getErrorMessage());
        }
        return binderErrors;
    }
}

