/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.baseui;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.LearningGroup;
import de.mahlsdorf.groupservice.model.node.School;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.model.ui.ComboShort;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.FilterUiUtils;
import de.mahlsdorf.groupservice.ui.layout.utils.CookieUtil;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.HomeView;
import java.awt.Dimension;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.spinkit.Spinner;
import org.vaadin.spinkit.SpinnerType;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BaseView
extends HorizontalLayout
implements BeforeEnterObserver {
    private static final Logger logger = LoggerFactory.getLogger(BaseView.class);
    private static final String MSG_KEY_VIEWNAME = "BaseView.";
    protected String schoolId;
    protected Teacher loggedInTeacher;
    protected Student loggedInStudent;
    protected School school;
    protected MainAppLayout mainLayoutUI;
    private final I18nService i18nService;
    protected ArrayList<TextField> filterFields;
    private final FilterUiUtils filterUiUtils;
    protected SerializableBiConsumer<Div, Course> startCourseConsumerRenderer = (SerializableBiConsumer & Serializable)(div, course) -> div.setText(new SimpleDateFormat(this.datePattern()).format(new Date(course.getStartsAt())));
    protected SerializableBiConsumer<Div, Course> endCourseConsumerRenderer = (SerializableBiConsumer & Serializable)(div, course) -> div.setText(new SimpleDateFormat(this.datePattern()).format(new Date(course.getEndsAt())));

    public void beforeEnter(BeforeEnterEvent var1) {
        logger.info("enter Layout is also implemented in child Classes ");
    }

    protected BaseView() {
        this.filterUiUtils = new FilterUiUtils();
        this.i18nService = I18nService.getInstance();
        this.addClassNames(new String[]{"no-padding", "no-margin"});
    }

    public boolean isUserLoggedInOrNavigateToHome() {
        UI ui = UI.getCurrent();
        MainAppLayout mainUi = (MainAppLayout)ui.getSession().getAttribute("loginData");
        if (mainUi == null) {
            logger.info("user not logged in");
            this.getUI().ifPresent(myUi -> myUi.navigate(HomeView.class));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)mainUi.getSchoolId())) {
            return false;
        }
        this.school = mainUi.getSchool();
        this.schoolId = mainUi.getSchoolId();
        this.loggedInTeacher = mainUi.getLoggedInTeacher();
        this.loggedInStudent = mainUi.getLoggedInStudent();
        this.mainLayoutUI = mainUi;
        return true;
    }

    public static void getActualUrl(Component component) {
        SerializableConsumer & Serializable urlConsumer = (SerializableConsumer & Serializable)url -> {
            try {
                UI.getCurrent().getSession().setAttribute("loginUrl", url);
            }
            catch (Exception e) {
                logger.error("Exception while getting loginUrl {} ", (Object)e.getMessage(), (Object)e);
                UI.getCurrent().getSession().setAttribute("loginUrl", null);
            }
        };
        component.getUI().ifPresent(myUi -> myUi.getPage().fetchCurrentURL(urlConsumer));
        URL url2 = (URL)UI.getCurrent().getSession().getAttribute("loginUrl");
        if (url2 != null) {
            CookieUtil.setCookie((String)"vaadineo-URL", (String)url2.toString());
        }
    }

    public void showNotificationMiddle(String message, int durationInSec) {
        if (!StringUtils.isEmpty((CharSequence)message)) {
            Notification.show((String)message, (int)(durationInSec * 1000), (Notification.Position)Notification.Position.MIDDLE);
        }
    }

    public String getSchoolId() {
        return this.schoolId;
    }

    public void setSchoolId(String schoolId) {
        this.schoolId = schoolId;
    }

    public Teacher getLoggedInTeacher() {
        return this.loggedInTeacher;
    }

    public void setLoggedInTeacher(Teacher loggedInTeacher) {
        this.loggedInTeacher = loggedInTeacher;
    }

    public Student getLoggedInStudent() {
        return this.loggedInStudent;
    }

    public String getLoggedInStudentNumber() {
        return this.loggedInStudent.getStudentId();
    }

    public void setLoggedInStudent(Student loggedInStudent) {
        this.loggedInStudent = loggedInStudent;
    }

    protected String getEditTableText() {
        return this.i18nService.getTranslation("BaseView.msg.editableText", this.getLocale(), new Object[0]);
    }

    private static void getBrowserDimension(Dimension dimension) {
        UI.getCurrent().getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)evt -> {
            int height = evt.getWindowInnerHeight();
            int width = evt.getWindowInnerWidth();
            if (logger.isDebugEnabled()) {
                logger.debug("Inside retriever: Height: {}  Width: {}", (Object)height, (Object)width);
            }
            dimension.height = height;
            dimension.width = width;
        });
    }

    protected Dimension getBrowserDimension() {
        Dimension dimension = new Dimension();
        BaseView.getBrowserDimension((Dimension)dimension);
        if (dimension.height < 1) {
            BaseView.getBrowserDimension((Dimension)dimension);
        }
        logger.info("Inside getBrowserDimension height: {} Width: {}", (Object)dimension.getHeight(), (Object)dimension.getWidth());
        if (dimension.height == 0) {
            dimension.height = 600;
        }
        return dimension;
    }

    public HorizontalLayout getLoggedInInfoLayout() {
        HorizontalLayout hlayout = new HorizontalLayout();
        hlayout.setHeight("0px");
        hlayout.setMargin(false);
        hlayout.setPadding(false);
        return hlayout;
    }

    public static HorizontalLayout generateButtonLayout(List<? extends Component> buttonList) {
        HorizontalLayout hLayoutButton = new HorizontalLayout();
        for (Component component : buttonList) {
            hLayoutButton.add(new Component[]{component});
        }
        hLayoutButton.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        hLayoutButton.setAlignItems(FlexComponent.Alignment.CENTER);
        hLayoutButton.setWidthFull();
        return hLayoutButton;
    }

    public VerticalLayout createConfirmDialogLayout(String question, List<Button> dialogButtons) {
        VerticalLayout dialogLayout = new VerticalLayout();
        Span infoLabel = new Span(question);
        HorizontalLayout hLayoutButtons = BaseView.generateButtonLayout(dialogButtons);
        dialogLayout.add(new Component[]{infoLabel, hLayoutButtons});
        return dialogLayout;
    }

    public List<ComboShort<Teacher>> createTeacherComboShortList(List<Teacher> list) {
        ArrayList<ComboShort<Teacher>> teacherList = new ArrayList<ComboShort<Teacher>>();
        for (Teacher teacher : list) {
            teacherList.add((ComboShort<Teacher>)new ComboShort((Object)teacher, teacher.getFirstName() + " " + teacher.getLastName()));
        }
        return teacherList;
    }

    public List<ComboShort<LearningGroup>> createLearnGroupComboShortList(List<LearningGroup> list) {
        ArrayList<ComboShort<LearningGroup>> teacherList = new ArrayList<ComboShort<LearningGroup>>();
        BeanComparator bc = new BeanComparator("learnGroupname");
        Collections.sort(list, bc);
        for (LearningGroup learningGroup : list) {
            teacherList.add((ComboShort<LearningGroup>)new ComboShort((Object)learningGroup, learningGroup.getLearnGroupname()));
        }
        return teacherList;
    }

    public List<ComboShort<Course>> createCourseComboShortList(List<Course> list) {
        ArrayList<ComboShort<Course>> courseList = new ArrayList<ComboShort<Course>>();
        for (Course course : list) {
            courseList.add((ComboShort<Course>)new ComboShort((Object)course, course.getName()));
        }
        return courseList;
    }

    protected String datePattern() {
        if (this.getLocale().equals(Locale.GERMAN)) {
            return "dd.MM.yyyy";
        }
        return "yyyy/MM/dd";
    }

    public static final Dialog createSpinnerDialog(Locale locale) {
        HorizontalLayout hLayout = BaseView.getHorizontalLayoutForSpinner((Locale)locale);
        Dialog dialog = new Dialog(new Component[]{hLayout});
        dialog.setCloseOnEsc(false);
        dialog.setCloseOnOutsideClick(false);
        dialog.open();
        return dialog;
    }

    private static HorizontalLayout getHorizontalLayoutForSpinner(Locale locale) {
        I18nService i18nServiceInternal = I18nService.getInstance();
        Spinner spinner = new Spinner(SpinnerType.SWING).small().withDisplayBlock();
        spinner.setColor("#0699fc");
        HorizontalLayout hLayout = new HorizontalLayout(new Component[]{spinner});
        String msg = i18nServiceInternal.getTranslation("BaseView.msg.wait", locale, new Object[0]);
        Div msgDiv = new Div(msg);
        hLayout.add(new Component[]{msgDiv});
        hLayout.setMargin(false);
        hLayout.setPadding(false);
        return hLayout;
    }

    public static final Div createSpinnerDiv(Locale locale) {
        HorizontalLayout horizontalLayout = BaseView.getHorizontalLayoutForSpinner((Locale)locale);
        Div div = new Div();
        div.add(new Component[]{horizontalLayout});
        return div;
    }

    protected TextField getColumnFilterField() {
        return this.filterUiUtils.getColumnFilterField();
    }

    protected void clearFilterFields(TextField source, String eventValue, List<TextField> filterFields, ListDataProvider dataprovider) {
        this.filterUiUtils.clearFilterFields(source, eventValue, filterFields, dataprovider);
    }

    protected void checkAllFilterFieldsEmpty(String eventValue, List<TextField> filterFields, ListDataProvider dataprovider) {
        this.filterUiUtils.checkAllFilterFieldsEmpty(eventValue, filterFields, dataprovider);
    }

    protected boolean compareGridValues(String filterValue, String gridValue) {
        return this.filterUiUtils.compareGridValues(filterValue, gridValue);
    }

    protected void clearOtherFilterFields(TextField source, List<TextField> filterFields) {
        this.filterUiUtils.clearOtherFilterFields(source, filterFields);
    }

    protected void clearDataProviderFiltersIfNeeded(String eventValue, List<TextField> filterFields, ListDataProvider dataprovider) {
        this.filterUiUtils.clearDataProviderFiltersIfNeeded(eventValue, filterFields, dataprovider);
    }

    protected void reuseExistingFilter(List<TextField> filterFields) {
        this.filterUiUtils.reuseExistingFilter(filterFields);
    }

    public static final void disableButtons(List<Button> buttons) {
        for (Button button : buttons) {
            button.setEnabled(false);
        }
    }
}

