/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.baseui;

import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.provider.ListDataProvider;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterUiUtils
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(FilterUiUtils.class);

    TextField getColumnFilterField() {
        TextField filter = new TextField();
        filter.setPlaceholder("Filter");
        return filter;
    }

    void clearFilterFields(TextField source, String eventValue, List<TextField> filterFields, ListDataProvider dataprovider) {
        boolean allEmpty = true;
        for (TextField field : filterFields) {
            if (source.equals(field)) continue;
            field.setValue("");
        }
        if (StringUtils.isEmpty((CharSequence)eventValue)) {
            dataprovider.clearFilters();
        }
    }

    void checkAllFilterFieldsEmpty(String eventValue, List<TextField> filterFields, ListDataProvider dataprovider) {
        boolean allEmpty = true;
        logger.debug("event value '{}'", (Object)eventValue);
        for (TextField field : filterFields) {
            logger.debug("filterfield Value {}", (Object)field.getValue());
            if (StringUtils.isEmpty((CharSequence)field.getValue())) continue;
            allEmpty = false;
        }
        if (allEmpty || StringUtils.isEmpty((CharSequence)eventValue)) {
            dataprovider.clearFilters();
        }
    }

    boolean compareGridValues(String filterValue, String gridValue) {
        if (gridValue == null) {
            return false;
        }
        if (filterValue == null) {
            filterValue = "";
        }
        String editorLower = gridValue.toLowerCase(Locale.ENGLISH);
        String filterLower = filterValue.toLowerCase(Locale.ENGLISH);
        return editorLower.contains(filterLower);
    }

    void clearOtherFilterFields(TextField source, List<TextField> filterFields) {
        for (TextField field : filterFields) {
            if (source.equals(field)) continue;
            field.setValue("");
        }
    }

    void clearDataProviderFiltersIfNeeded(String eventValue, List<TextField> filterFields, ListDataProvider dataprovider) {
        boolean allEmpty = true;
        logger.debug("event value '{}'", (Object)eventValue);
        for (TextField field : filterFields) {
            logger.debug("filterfield Value {}", (Object)field.getValue());
            if (StringUtils.isEmpty((CharSequence)field.getValue())) continue;
            allEmpty = false;
        }
        if (allEmpty || StringUtils.isEmpty((CharSequence)eventValue)) {
            dataprovider.clearFilters();
        }
    }

    protected void reuseExistingFilter(List<TextField> filterFields) {
        for (TextField field : filterFields) {
            if (StringUtils.isEmpty((CharSequence)field.getValue())) continue;
            String oldValue = field.getValue();
            field.setValue("");
            field.setValue(oldValue);
        }
    }
}

