/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseView;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfirmDialog
extends BaseDialog {
    private static final Logger logger = LoggerFactory.getLogger(ConfirmDialog.class);
    private static final String MSG_KEY_DIALOGNAME = "InfoDialog.";
    private List<Component> infoComponents;
    private List<Button> buttons;

    public ConfirmDialog(@NotNull List<Component> infoComponents, @NotNull List<Button> buttons) {
        this(infoComponents, buttons, true);
    }

    public ConfirmDialog(@NotNull List<Component> infoComponents, @NotNull List<Button> buttons, boolean withInitLayout) {
        this.infoComponents = infoComponents;
        this.buttons = buttons;
        if (withInitLayout) {
            this.initLayout();
        }
    }

    private void initLayout() {
        VerticalLayout vLayout = new VerticalLayout();
        vLayout.setWidthFull();
        this.infoComponents.forEach(x -> vLayout.add(new Component[]{x}));
        Button cancelButton = new Button(I18nService.getInstance().getTranslation("InfoDialog.button.close", this.getLocale(), new Object[0]));
        cancelButton.setId("buttonCloseId");
        cancelButton.addClickListener((ComponentEventListener & Serializable)b -> this.close());
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidthFull();
        if (this.buttons != null && this.buttons.size() > 0) {
            this.buttons.forEach(x -> buttonLayout.add(new Component[]{x}));
            this.buttons.forEach(x -> x.addClickListener((ComponentEventListener & Serializable)event -> this.close()));
        }
        buttonLayout.add(new Component[]{cancelButton});
        buttonLayout.setAlignItems(FlexComponent.Alignment.STRETCH);
        vLayout.add(new Component[]{buttonLayout});
        this.add(new Component[]{vLayout});
    }

    public void pushUI() {
        try {
            UI.getCurrent().push();
        }
        catch (Exception e) {
            logger.warn("Exception while updateing confirmDialog ", (Throwable)e);
        }
    }

    public void setSpinner(ClickEvent event) {
        Button b = (Button)event.getSource();
        if (!b.getParent().isEmpty()) {
            Div spinnerDiv = BaseView.createSpinnerDiv((Locale)this.getLocale());
            HorizontalLayout parent = (HorizontalLayout)b.getParent().get();
            parent.add(new Component[]{spinnerDiv});
            try {
                UI.getCurrent().push();
            }
            catch (Exception e) {
                logger.error("Exception while set spinner in confirmdialog {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

