/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.validator.RegexpValidator;
import de.mahlsdorf.groupservice.constants.ConstantsNeoc;
import de.mahlsdorf.groupservice.model.node.Course;
import de.mahlsdorf.groupservice.model.node.Subject;
import de.mahlsdorf.groupservice.model.ui.ComboShort;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.CourseView;
import de.mahlsdorf.groupservice.validator.DatePickerValidator;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CourseDialog
extends BaseDialog {
    private static final Logger logger = LoggerFactory.getLogger(CourseDialog.class);
    private static final String MSG_KEY_DIALOGNAME = "CourseDialog.";
    private final MainAppLayout mainLayoutUI;
    private final String learningGroupId;
    private final CourseView courseView;
    private Course course;
    private DatePicker fromDatePicker;
    private ComboBox<ComboShort<String>> subjectComboBox;
    private DatePicker toDatePicker;
    private boolean isNew = false;
    private Neo4JBaseService neo4JService;
    Binder<Course> courseBinder;
    private final I18nService i18nService;

    public CourseDialog(@NotNull MainAppLayout mainLayoutUI, @NotNull String learningGroupId, Course course, @NotNull CourseView courseView) {
        this.mainLayoutUI = mainLayoutUI;
        this.learningGroupId = learningGroupId;
        this.course = course;
        this.courseView = courseView;
        this.i18nService = I18nService.getInstance();
        this.neo4JService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.initLayout();
    }

    private void initLayout() {
        try {
            if (this.course == null) {
                this.course = new Course();
                this.isNew = true;
            }
            this.setCloseOnOutsideClick(false);
            FormLayout formLayout = new FormLayout();
            String nameLabel = this.i18nService.getTranslation("CourseDialog.label.name", this.getLocale(), new Object[0]);
            this.courseBinder = new Binder(Course.class);
            TextField nameTF = new TextField("* " + nameLabel);
            nameTF.setPlaceholder(nameLabel);
            String commentLabel = this.i18nService.getTranslation("CourseDialog.label.comment", this.getLocale(), new Object[0]);
            TextField commentTF = new TextField(commentLabel);
            commentTF.setPlaceholder(commentLabel);
            String subjectLabel = this.i18nService.getTranslation("CourseDialog.label.subject", this.getLocale(), new Object[0]);
            List allSubjects = this.neo4JService.findSubjectsBySchoolId(this.mainLayoutUI.getSchool().getSchoolId());
            if (allSubjects == null || allSubjects.isEmpty()) {
                this.showNotificationMiddle(this.i18nService.getTranslation("CourseDialog.msg.createSubjectFirst", this.getLocale(), new Object[0]), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
                this.close();
                return;
            }
            Subject selectedCS = null;
            ArrayList<ComboShort> cbShortList = new ArrayList<ComboShort>();
            for (Subject subject : allSubjects) {
                ComboShort cs = new ComboShort((Object)subject.getSubjectId(), subject.getSubjectName());
                if (subject.getSubjectId().equals(this.course.getSubjectId())) {
                    selectedCS = subject;
                }
                cbShortList.add(cs);
            }
            BeanComparator beanComparator = new BeanComparator("description");
            Collections.sort(cbShortList, beanComparator);
            this.subjectComboBox = new ComboBox("* " + subjectLabel, cbShortList);
            this.subjectComboBox.setPlaceholder(subjectLabel);
            if (selectedCS == null) {
                this.subjectComboBox.setValue((Object)((ComboShort)cbShortList.get(0)));
            } else {
                this.subjectComboBox.setValue((Object)new ComboShort((Object)selectedCS.getSubjectId(), selectedCS.getSubjectName()));
            }
            String startLabel = this.i18nService.getTranslation("CourseDialog.label.start", this.getLocale(), new Object[0]);
            String endLabel = this.i18nService.getTranslation("CourseDialog.label.end", this.getLocale(), new Object[0]);
            this.fromDatePicker = new DatePicker(startLabel);
            this.toDatePicker = new DatePicker(endLabel);
            formLayout.add(new Component[]{nameTF, this.subjectComboBox, commentTF, new Span(""), this.fromDatePicker, this.toDatePicker});
            Button saveButton = new Button(this.i18nService.getTranslation("CourseDialog.button.save", this.getLocale(), new Object[0]));
            saveButton.addClickListener((ComponentEventListener & Serializable)event -> this.save());
            Button cancelButton = new Button(this.i18nService.getTranslation("CourseDialog.button.cancel", this.getLocale(), new Object[0]));
            cancelButton.addClickListener((ComponentEventListener & Serializable)event -> this.cancel());
            HorizontalLayout buttonLayout = new HorizontalLayout();
            buttonLayout.add(new Component[]{saveButton, cancelButton});
            buttonLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
            String msgIsRequired = this.i18nService.getTranslation("CourseDialog.msg.isRequired", this.getLocale(), new Object[0]);
            String min3Chars = this.i18nService.getTranslation("CourseDialog.msg.min3Chars", this.getLocale(), new Object[0]);
            this.courseBinder.forField((HasValue)nameTF).asRequired(msgIsRequired).withNullRepresentation((Object)"").withValidator((Validator)new RegexpValidator(min3Chars, "[\\w]{1}[\\w\\d\\s\\w]{3,50}")).bind("name");
            this.courseBinder.bind((HasValue)commentTF, "comment");
            DatePickerValidator datePickerValidator1 = new DatePickerValidator(this.fromDatePicker, this.toDatePicker, true, this.getLocale());
            DatePickerValidator datePickerValidator2 = new DatePickerValidator(this.fromDatePicker, this.toDatePicker, false, this.getLocale());
            this.courseBinder.forField((HasValue)this.fromDatePicker).withValidator((Validator)datePickerValidator1).bind("startsAtLocalTime");
            this.courseBinder.forField((HasValue)this.toDatePicker).withValidator((Validator)datePickerValidator2).bind("endsAtLocalTime");
            this.courseBinder.readBean((Object)this.course);
            this.fromDatePicker.setEnabled(true);
            this.toDatePicker.setEnabled(true);
            this.fromDatePicker.setReadOnly(false);
            this.toDatePicker.setReadOnly(false);
            formLayout.add(new Component[]{buttonLayout});
            this.add(new Component[]{formLayout});
            this.fromDatePicker.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                if (this.isNew) {
                    LocalDate localDate = (LocalDate)event.getValue();
                    LocalDate toDate = localDate.plusMonths(12L);
                    this.toDatePicker.setValue(toDate);
                }
                this.courseBinder.validate();
            });
            this.toDatePicker.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.courseBinder.validate());
        }
        catch (Exception t) {
            logger.error("Exception while creating CourseDialog {}", (Object)t.getMessage(), (Object)t);
            this.showNotificationMiddle("Exception while creating CourseDialog ".concat(t.getMessage()), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
            throw t;
        }
    }

    private void save() {
        if (this.course == null) {
            this.course = new Course();
        }
        try {
            this.courseBinder.writeBean((Object)this.course);
            this.course.setStartsAtLocalTime((LocalDate)this.fromDatePicker.getValue());
            this.course.setEndsAtLocalTime((LocalDate)this.toDatePicker.getValue());
            this.course.setSubjectId((String)((ComboShort)this.subjectComboBox.getValue()).getId());
            if (this.isNew) {
                this.neo4JService.createCourse(this.course, this.learningGroupId);
            } else {
                this.neo4JService.updateCourse(this.course);
            }
            this.courseView.learnGroupHasChangedFillUpCourses();
            this.close();
        }
        catch (Exception e) {
            String exceptionMessage = this.i18nService.getTranslation("CourseDialog.msg.exceptionSaveCourse", this.getLocale(), new Object[]{e.getMessage()});
            this.showNotificationMiddle(exceptionMessage + e.getMessage(), ConstantsNeoc.Durations.DURATION_MIDDLE.intValue());
        }
    }

    private void cancel() {
        this.close();
    }
}

