/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.validator.RegexpValidator;
import de.mahlsdorf.groupservice.model.node.LearningGroup;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.LearningGroupNamesView;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearngroupDialog
extends BaseDialog {
    private static final Logger logger = LoggerFactory.getLogger(LearngroupDialog.class);
    private static final String MSG_KEY_DIALOGNAME = "LearngroupDialog.";
    private final MainAppLayout mainLayoutUI;
    private final Teacher teacher;
    private final LearningGroupNamesView learningGroupNamesView;
    private final Neo4JBaseService neo4JService;
    private final Binder<LearningGroup> binder = new Binder(LearningGroup.class);
    private LearningGroup learnGroup;
    private TextField nameTextField;
    private Button saveButton;
    private Button cancelButton;
    private boolean isNew = false;
    private final I18nService i18nService;

    public LearngroupDialog(MainAppLayout mainLayoutUI, Teacher teacher, LearningGroup learnGroup, LearningGroupNamesView groupView) {
        this.mainLayoutUI = mainLayoutUI;
        this.teacher = teacher;
        this.learnGroup = learnGroup;
        this.learningGroupNamesView = groupView;
        this.neo4JService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.i18nService = I18nService.getInstance();
        this.initLayout();
    }

    private void initLayout() {
        if (this.learnGroup == null) {
            this.learnGroup = new LearningGroup();
            this.isNew = true;
        }
        this.setCloseOnOutsideClick(false);
        FormLayout formLayout = new FormLayout();
        String labelName = this.i18nService.getTranslation("LearngroupDialog.label.name", this.getLocale(), new Object[0]);
        this.nameTextField = new TextField();
        this.nameTextField.setLabel(labelName);
        this.nameTextField.setPlaceholder(labelName);
        this.nameTextField.setId("tfLgNameId");
        String min3Chars = this.i18nService.getTranslation("LearngroupDialog.msg.min3Chars", this.getLocale(), new Object[0]);
        formLayout.add(new Component[]{this.nameTextField});
        this.binder.forField((HasValue)this.nameTextField).asRequired(this.i18nService.getTranslation("LearngroupDialog.msg.required", this.getLocale(), new Object[0])).withNullRepresentation((Object)"").withValidator((Validator)new RegexpValidator(min3Chars, "[\\w\\d]{1,1}[\\d\\w\\s]{2,}")).bind("learnGroupname");
        this.saveButton = new Button(this.i18nService.getTranslation("LearngroupDialog.button.save", this.getLocale(), new Object[0]));
        this.saveButton.setId("BtnSaveId");
        this.saveButton.addClickListener((ComponentEventListener & Serializable)event -> this.save());
        this.cancelButton = new Button(this.i18nService.getTranslation("LearngroupDialog.button.cancel", this.getLocale(), new Object[0]));
        this.cancelButton.setId("BtnCancelId");
        this.cancelButton.addClickListener((ComponentEventListener & Serializable)event -> this.cancel());
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.add(new Component[]{this.saveButton, this.cancelButton});
        HorizontalLayout hlButtons = new HorizontalLayout();
        hlButtons.add(new Component[]{this.saveButton, this.cancelButton});
        formLayout.add(new Component[]{hlButtons});
        this.add(new Component[]{formLayout});
        this.binder.readBean((Object)this.learnGroup);
    }

    private synchronized void save() {
        try {
            this.binder.writeBean((Object)this.learnGroup);
            logger.info("Bean before Save {} ", (Object)this.learnGroup);
            String teacherNumber = this.teacher.getTeacherId();
            String learnGroupId = this.learnGroup.getGroupId();
            boolean isNew = false;
            if (learnGroupId == null) {
                learnGroupId = UUID.randomUUID().toString();
                this.learnGroup.setGroupId(learnGroupId);
                this.neo4JService.createLearnGroup(this.learnGroup);
                this.neo4JService.createRelLearnGroupTeacher(learnGroupId, teacherNumber);
            } else {
                this.neo4JService.updateLearnGroup(this.learnGroup);
            }
            this.showNotificationMiddle(this.i18nService.getTranslation("LearngroupDialog.msg.saved", this.getLocale(), new Object[]{this.learnGroup.getLearnGroupname()}), 2);
            this.learningGroupNamesView.teacherHasChanged(false);
            this.close();
        }
        catch (Exception e) {
            logger.error("Exception while saving LearningGroup ", (Throwable)e);
            this.showNotificationMiddle(this.i18nService.getTranslation("LearngroupDialog.msg.exceptionWhileSaving", this.getLocale(), new Object[]{e.getMessage()}), 2);
        }
    }

    private void cancel() {
        this.close();
    }
}

