/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.i18n.I18NProvider;
import de.mahlsdorf.groupservice.model.node.PersonIF;
import de.mahlsdorf.groupservice.model.node.School;
import de.mahlsdorf.groupservice.model.node.Student;
import de.mahlsdorf.groupservice.model.node.Teacher;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.security.CryptDecryptHelper;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.utils.CookieUtil;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.students.StudentCourseView;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.TeacherView;
import jakarta.servlet.http.Cookie;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginDialog
extends BaseDialog {
    public static final String MSG_KEY_VIEWNAME = "LoginDialog.";
    private static final Logger logger = LoggerFactory.getLogger(LoginDialog.class);
    private String teacherLabel = "Lehrer";
    private final MainAppLayout mainLayoutUI;
    private TextField userNameTF;
    private PasswordField passwordTF;
    private ComboBox<String> typeComboBox;
    private String studentLabel = "Sch\u00fcler";
    private final I18NProvider i18nService;
    private String typeFromCookie = "";
    private Neo4JBaseService neo4JBaseService;

    public LoginDialog(MainAppLayout mainLayoutUI) {
        this.mainLayoutUI = mainLayoutUI;
        this.i18nService = mainLayoutUI.getI18nService();
        this.teacherLabel = this.i18nService.getTranslation("Global.views.teacher", this.getLocale(), new Object[0]);
        this.studentLabel = this.i18nService.getTranslation("Global.views.student", this.getLocale(), new Object[0]);
        this.neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.initLayout();
    }

    private void initLayout() {
        Cookie userType;
        VerticalLayout vlayout = new VerticalLayout();
        this.userNameTF = new TextField(this.i18nService.getTranslation("LoginDialog.label.username", this.getLocale(), new Object[0]));
        this.userNameTF.setId("tfUserNameId");
        this.passwordTF = new PasswordField(this.i18nService.getTranslation("LoginDialog.label.password", this.getLocale(), new Object[0]));
        this.passwordTF.setId("tfPasswordId");
        this.typeComboBox = new ComboBox(this.i18nService.getTranslation("LoginDialog.label.logintype", this.getLocale(), new Object[0]));
        List<String> typeList = Arrays.asList(this.studentLabel, this.teacherLabel);
        this.typeComboBox.setId("typeComboId");
        this.typeComboBox.setItems(typeList);
        this.typeComboBox.setValue((Object)this.studentLabel);
        this.typeComboBox.setValue((Object)this.teacherLabel);
        this.typeComboBox.setRequired(true);
        Button save = new Button(this.i18nService.getTranslation("LoginDialog.button.login", this.getLocale(), new Object[0]));
        save.addClickListener((ComponentEventListener & Serializable)event -> this.checkLogin());
        save.setId("submitLoginId");
        vlayout.add(new Component[]{this.userNameTF, this.passwordTF, this.typeComboBox, save});
        this.add(new Component[]{vlayout});
        Cookie userCookie = CookieUtil.getCookie((String)"vaadineo-LN");
        if (userCookie != null) {
            this.userNameTF.setValue(userCookie.getValue());
        }
        if ((userType = CookieUtil.getCookie((String)"vaadineo-LT")) != null) {
            this.typeComboBox.setValue((Object)userType.getValue());
            this.typeFromCookie = userType.getValue();
        }
    }

    private void checkLogin() {
        String loginName = this.userNameTF.getValue();
        boolean isStudent = ((String)this.typeComboBox.getValue()).equals(this.studentLabel);
        List schoolList = isStudent ? this.neo4JBaseService.getSchoolForStudentByLoginName(loginName) : this.neo4JBaseService.getSchoolForTeacherByLoginName(loginName);
        if (schoolList != null && !schoolList.isEmpty()) {
            School school = (School)schoolList.get(0);
            logger.info("found School {} school", (Object)school);
            this.mainLayoutUI.setSchool(school);
            if (isStudent) {
                Student student = this.neo4JBaseService.findStudentByLoginName(loginName);
                if (!this.checkPassword((PersonIF)student)) {
                    return;
                }
                this.mainLayoutUI.setLoggedInStudent(student);
                this.mainLayoutUI.setLayoutType(MainAppLayout.LayoutType.STUDENT_LAYOUT);
            } else {
                Teacher teacher = this.neo4JBaseService.findTeacherByLoginName(loginName);
                if (!this.checkPassword((PersonIF)teacher)) {
                    return;
                }
                this.showNotificationMiddle(this.i18nService.getTranslation("LoginDialog.msg.loginsuccess", this.getLocale(), new Object[]{school.getName(), teacher.getFirstName() + teacher.getLastName()}), 2);
                this.mainLayoutUI.setLoggedInTeacher(teacher);
                this.mainLayoutUI.setLayoutType(MainAppLayout.LayoutType.TEACHER_LAYOUT);
            }
            UI.getCurrent().getSession().setAttribute("loginData", (Object)this.mainLayoutUI);
            this.lookForThePathtoNavigateTo();
            this.setLoginCookies(loginName);
            this.mainLayoutUI.setLoginShown(false);
            this.close();
        } else {
            this.showLoginFailed();
        }
    }

    private void setLoginCookies(String loginName) {
        CookieUtil.setCookie((String)"vaadineo-LN", (String)loginName);
        CookieUtil.setCookie((String)"vaadineo-LT", (String)((String)this.typeComboBox.getValue()));
    }

    private void lookForThePathtoNavigateTo() {
        Object o = UI.getCurrent().getSession().getAttribute("loginUrl");
        if (this.typeFromCookie.equals(this.typeComboBox.getValue())) {
            if (o != null) {
                URL url = (URL)o;
                UI.getCurrent().navigate(url.toString());
                logger.info("take url from session");
            } else {
                Cookie urlCookie = CookieUtil.getCookie((String)"vaadineo-URL");
                if (urlCookie != null) {
                    UI.getCurrent().navigate(urlCookie.getValue());
                }
                logger.info("taking url from cookie ");
            }
        } else if (this.teacherLabel.equals(this.typeComboBox.getValue())) {
            UI.getCurrent().navigate(TeacherView.class);
        } else {
            UI.getCurrent().navigate(StudentCourseView.class);
        }
    }

    private void showLoginFailed() {
        this.showNotificationMiddle(this.i18nService.getTranslation("LoginDialog.msg.loginfailed", this.getLocale(), new Object[0]), 2);
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            logger.error("Exception ", (Throwable)e);
        }
    }

    private boolean checkPassword(PersonIF person) {
        try {
            String password;
            if (StringUtils.isEmpty((CharSequence)person.getPassword())) {
                return true;
            }
            String userPassword = CryptDecryptHelper.decrypt((String)person.getPassword());
            if (userPassword.equals(password = this.passwordTF.getValue())) {
                return true;
            }
            this.showLoginFailed();
        }
        catch (Exception e) {
            this.showNotificationMiddle("Exception " + e.getMessage(), 5);
        }
        return false;
    }
}

