/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.groupservice.ui.layout.dialogs;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.model.ui.ComboShort;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.groupservice.service.ui.I18nService;
import de.mahlsdorf.groupservice.ui.layout.MainAppLayout;
import de.mahlsdorf.groupservice.ui.layout.baseui.BaseDialog;
import de.mahlsdorf.groupservice.ui.layout.utils.VaadineoServiceHolder;
import de.mahlsdorf.groupservice.ui.layout.views.teacher.TaskView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lti13DeeplinkDialog
extends BaseDialog {
    private static final Logger logger = LoggerFactory.getLogger(Lti13DeeplinkDialog.class);
    private static final String MSG_KEY_DIALOGNAME = "Lti13DeeplinkDialog.";
    private final MainAppLayout mainLayoutUI;
    private final TaskView taskView;
    private final Neo4JBaseService neo4JBaseService;
    private static final String FORMAT_DEEPLINK_URL = "/platformapi/v1/lti13/deepLinkingStart/?teacherId=%s&toolId=%s&courseId=%s&localeTag=%s";
    private final String userId;
    private final String courseId;
    private ComboBox<ComboShort<String>> toolComboBox;
    private final I18nService i18nService;
    HorizontalLayout linkLayout;

    public Lti13DeeplinkDialog(MainAppLayout mainLayoutUI, String userId, String courseId, TaskView taskView) {
        this.mainLayoutUI = mainLayoutUI;
        this.taskView = taskView;
        this.userId = userId;
        this.courseId = courseId;
        this.neo4JBaseService = VaadineoServiceHolder.getINSTANCE().getNeo4JBaseService();
        this.i18nService = I18nService.getInstance();
        this.initLayout();
    }

    private void initLayout() {
        logger.debug("start loginInit");
        this.setCloseOnOutsideClick(false);
        this.setCloseOnEsc(false);
        this.removeAll();
        this.toolComboBox = new ComboBox(this.i18nService.getTranslation("Lti13DeeplinkDialog.label.availableTools", this.getLocale(), new Object[0]));
        this.fillUpToolComboBox(this.toolComboBox);
        this.toolComboBox.setWidth("80%");
        Button closeButton = new Button(this.i18nService.getTranslation("Lti13DeeplinkDialog.button.close", this.getLocale(), new Object[0]));
        closeButton.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.closeThis());
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.add(new Component[]{this.toolComboBox, closeButton});
        buttonLayout.setWidthFull();
        buttonLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        VerticalLayout layout = new VerticalLayout();
        layout.setWidthFull();
        layout.add(new Component[]{buttonLayout});
        Div div = this.getDeepLink(this.userId, this.courseId);
        this.linkLayout = new HorizontalLayout(new Component[]{div});
        layout.add(new Component[]{this.linkLayout});
        this.add(new Component[]{layout});
        if (logger.isDebugEnabled()) {
            logger.debug("Ende intoLayout");
        }
        this.setWidth("100%");
        this.toolComboBox.addValueChangeListener(arg_0 -> this.changeDeeplinlinkinLink(arg_0));
    }

    private Div getDeepLink(String userId, String courseId) {
        String mytoolId;
        Div div = new Div();
        String string = mytoolId = this.toolComboBox.getValue() == null ? "" : (String)((ComboShort)this.toolComboBox.getValue()).getId();
        if (StringUtils.isEmpty((CharSequence)mytoolId)) {
            String msg = this.i18nService.getTranslation("Lti13DeeplinkDialog.msg.selectTool", this.getLocale(), new Object[0]);
            Span span = new Span(msg);
            div.add(new Component[]{span});
        } else {
            String href = String.format(FORMAT_DEEPLINK_URL, userId, mytoolId, courseId, this.getLocale().toLanguageTag());
            Anchor anchor = new Anchor();
            anchor.setHref(href);
            anchor.setText(this.i18nService.getTranslation("Lti13DeeplinkDialog.msg.startDeepLinking", this.getLocale(), new Object[0]) + "  " + ((ComboShort)this.toolComboBox.getValue()).getDescription());
            anchor.setTarget("_myWindow");
            div.add(new Component[]{anchor});
        }
        return div;
    }

    private void closeThis() {
        this.taskView.fillUpGridWithTasksForSelectedCourse();
        this.close();
    }

    private void fillUpToolComboBox(ComboBox toolComboBox) {
        List tools = this.neo4JBaseService.getToolsForSchool(this.mainLayoutUI.getSchoolId());
        ArrayList<ComboShort> toolCSList = new ArrayList<ComboShort>();
        for (Tool tool : tools) {
            String formatLabel = "%s (%s)";
            ComboShort cs = new ComboShort((Object)tool.getToolId(), String.format(formatLabel, tool.getToolName(), tool.getToolDescription()));
            toolCSList.add(cs);
        }
        toolComboBox.setItems(toolCSList);
        if (!toolCSList.isEmpty()) {
            toolComboBox.setValue(toolCSList.get(0));
        }
    }

    private void changeDeeplinlinkinLink(AbstractField.ComponentValueChangeEvent x) {
        if (logger.isDebugEnabled()) {
            logger.debug("Value of toolComboBox {} ", this.toolComboBox.getValue());
        }
        Div result = this.getDeepLink(this.userId, this.courseId);
        this.linkLayout.removeAll();
        this.linkLayout.add(new Component[]{result});
    }

    private void cancel() {
        this.close();
    }
}

